/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.news;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.google.gson.JsonObject;
import com.taboola.android.plus.common.AbstractAnalyticsManager;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.home.screen.news.HomeScreenNewsEventProperties;
import com.taboola.android.utils.Logger;
import org.json.JSONObject;

@RequiresApi(api=21)
public class HomeScreenNewsAnalyticsManager
extends AbstractAnalyticsManager<HomeScreenNewsEventProperties> {
    private static final String TAG = HomeScreenNewsAnalyticsManager.class.getSimpleName();
    private static final String HOME_SCREEN_NEWS_TRIGGERED_EVENT = "HSNTriggered";
    private static final String HOME_SCREEN_NEWS_DISPLAYED_EVENT = "HSNDisplayed";

    public HomeScreenNewsAnalyticsManager(ISdkPlusCore sdkPlusCore) {
        super(sdkPlusCore);
    }

    public void sendHomeScreenNewsTriggeredEvent() {
        HomeScreenNewsEventProperties eventProperties = new HomeScreenNewsEventProperties.Builder(HOME_SCREEN_NEWS_TRIGGERED_EVENT, false).build();
        this.sendEvent(eventProperties, false);
    }

    public void sendHomeScreenNewsDisplayedEvent() {
        HomeScreenNewsEventProperties eventProperties = new HomeScreenNewsEventProperties.Builder(HOME_SCREEN_NEWS_DISPLAYED_EVENT, false).build();
        this.sendEvent(eventProperties, false);
    }

    @Override
    protected void broadcastEvent(@NonNull HomeScreenNewsEventProperties eventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction("tb.analytics.action.name");
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra("key_event_name", eventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, eventProperties.getError(), eventProperties.isBlocked(), eventProperties.isDeviceLocked(), eventProperties.getExceptionMessage(), eventProperties.getExceptionStackTrace(), eventProperties.getErrorMessage());
            intent.putExtra("key_event_properties", eventsProperties.toString());
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra("key_user_properties", userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable String error, Boolean isBlocked, Boolean isDeviceLocked, String exceptionMessage, String exceptionStackTrace, String errorMessage) {
        return this.getCommonEventProperties(appContext, error, isBlocked, isDeviceLocked, exceptionMessage, exceptionStackTrace, errorMessage);
    }

    @Override
    public JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull HomeScreenNewsEventProperties eventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        return super.getJsonObjectForKusto(appContext, eventProperties, sharedLocalStorage);
    }
}

