/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.ConfigManager;
import com.taboola.android.plus.core.InternalSdkPlusCoreInitCallback;

@RequiresApi(api=21)
public class RemoteConfigRefreshJob
extends JobService {
    private static final String TAG = RemoteConfigRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 64879728;
    private static final String BUNDLE_EXTRAS_REFRESH_INTERVAL_MS = "com.taboola.android.plus.core.remote_config.extras.refreshIntervalMs";
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900000L;

    public static void scheduleRemoteConfigRefreshJob(@NonNull Context context, long refreshIntervalMs) {
        Log.d((String)TAG, (String)("scheduleRemoteConfigRefreshJob() called with: refreshIntervalMs = [" + refreshIntervalMs + "]"));
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler == null) {
            Log.e((String)TAG, (String)"scheduleRemoteConfigRefreshJob: failed to schedule the job: jobScheduler is null");
            return;
        }
        ComponentName componentName = new ComponentName(context, RemoteConfigRefreshJob.class);
        long actualRefreshInterval = Math.max(900000L, refreshIntervalMs);
        JobInfo.Builder builder = new JobInfo.Builder(64879728, componentName);
        builder.setPeriodic(actualRefreshInterval);
        builder.setPersisted(true);
        PersistableBundle extras = new PersistableBundle();
        extras.putLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS, refreshIntervalMs);
        builder.setExtras(extras);
        jobScheduler.schedule(builder.build());
    }

    public static void cancelRemoteConfigRefreshJob(Context context) {
        Log.d((String)TAG, (String)"Canceling periodic config refresh");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler == null) {
            Log.e((String)TAG, (String)"scheduleRemoteConfigRefreshJob: failed to cancel the job: jobScheduler is null");
            return;
        }
        jobScheduler.cancel(64879728);
    }

    public static void rescheduleJobIfNeeded(@NonNull Context context, long refreshIntervalMs) {
        Log.d((String)TAG, (String)("rescheduleJobIfNeeded() called with: refreshIntervalMs = [" + refreshIntervalMs + "]"));
        if (RemoteConfigRefreshJob.shouldRescheduleJob(context, refreshIntervalMs)) {
            RemoteConfigRefreshJob.scheduleRemoteConfigRefreshJob(context, refreshIntervalMs);
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: Job rescheduled");
        }
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        BridgeInternalCore.getSdkPlusCoreAsync(new InternalSdkPlusCoreInitCallback(){

            @Override
            public void onSdkPlusCoreInitSuccessful(ISdkPlusCore sdkPlusCore) {
                Log.d((String)TAG, (String)"onSdkPlusCoreInitSuccessful() called");
                sdkPlusCore.getConfigManager().triggerAsyncConfigsUpdate(new ConfigManager.AsyncConfigsUpdateCallback(){

                    @Override
                    public void onConfigUpdatedSuccessfully() {
                        Log.d((String)TAG, (String)"onConfigUpdatedSuccessfully() called");
                        RemoteConfigRefreshJob.this.jobFinished(params, false);
                    }

                    @Override
                    public void onConfigUpdateFailed(Throwable throwable) {
                        Log.e((String)TAG, (String)"onConfigUpdateFailed: ", (Throwable)throwable);
                        RemoteConfigRefreshJob.this.jobFinished(params, false);
                    }
                });
            }

            @Override
            public void onSdkPlusCoreInitFailed(Throwable throwable) {
                Log.e((String)TAG, (String)"onSdkPlusCoreInitFailed: ", (Throwable)throwable);
                RemoteConfigRefreshJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        Log.w((String)TAG, (String)"onStopJob: RemoteConfigRefreshJob job was stopped");
        return false;
    }

    private static boolean shouldRescheduleJob(@NonNull Context context, long newRefreshIntervalMs) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        JobInfo currentJobInfo = null;
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 64879728) continue;
                currentJobInfo = jobInfo;
                break;
            }
        }
        if (currentJobInfo == null) {
            Log.d((String)TAG, (String)"shouldRescheduleJob: job is not currently scheduled. Should reschedule.");
            return true;
        }
        if (currentJobInfo.getIntervalMillis() != newRefreshIntervalMs) {
            Log.d((String)TAG, (String)"shouldRescheduleJob: job interval has changed. Should reschedule.");
            return true;
        }
        Log.d((String)TAG, (String)"shouldRescheduleJob: job is already running with the correct interval. No need to reschedule.");
        return false;
    }
}

