/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.plus.common.AbstractLocalStorage;
import java.util.HashSet;
import java.util.Set;

public class SharedLocalStorage
extends AbstractLocalStorage {
    private static final String TAG = SharedLocalStorage.class.getSimpleName();
    public static final String SHARED_STORAGE_PREFS_FILE_NAME = "shared_local_storage";
    public static final String SHARED_PREFS_KEY_LAST_EVENT_TIME = "tb_last_event_time";
    public static final String SHARED_PREFS_KEY_CONFIG_VARIANT = "tb_config_variant";
    public static final String SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM = "is_notification_block_by_system";
    public static final String SHARED_PREFS_KEY_PUBLISHER = "tb_publisher";
    public static final String SHARED_PREFS_KEY_USER_UNIFIED_ID = "tb_user_unified_id";
    public static final String SHARED_PREFS_KEY_SIM_COUNTRY = "sim_country";
    public static final String SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME = "last_check_notification_disabled_status_event_time";
    public static final String CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO = "crashes_events_need_to_send_to_kusto";
    public static final String SHARED_PREFS_KEY_IS_KUSTO_ENABLED = "is_kibana_analytics_enabled";
    public static final String SHARED_LOCAL_STORAGE_SCHEMA_VERSION = "local_storage_schema_version";

    public SharedLocalStorage(@NonNull Context applicationContext) {
        super(applicationContext, SHARED_STORAGE_PREFS_FILE_NAME);
    }

    public long getLastEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_EVENT_TIME);
    }

    public void setLastEventTime(long lastEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_EVENT_TIME, lastEventTime);
    }

    public void setConfigVariant(String configVariant) {
        this.putString(SHARED_PREFS_KEY_CONFIG_VARIANT, configVariant);
    }

    @NonNull
    public String getConfigVariant() {
        String configVariant = this.getString(SHARED_PREFS_KEY_CONFIG_VARIANT);
        return configVariant == null ? "" : configVariant;
    }

    public void setIsNotificationBlockBySystem(boolean isNotificationBlockBySystem) {
        this.putBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM, isNotificationBlockBySystem);
    }

    public boolean isNotificationBlockBySystem() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_NOTIFICATION_BLOCK_BY_SYSTEM);
    }

    public void setPublisher(String publisher) {
        this.putString(SHARED_PREFS_KEY_PUBLISHER, publisher);
    }

    @Nullable
    public String getPublisher() {
        return this.getString(SHARED_PREFS_KEY_PUBLISHER);
    }

    public void setUserUnifiedId(String userUnifiedId) {
        this.putString(SHARED_PREFS_KEY_USER_UNIFIED_ID, userUnifiedId);
    }

    @Nullable
    public String getUserUnifiedId() {
        return this.getString(SHARED_PREFS_KEY_USER_UNIFIED_ID);
    }

    public void setKustoAnalyticsEnabled(boolean enabled) {
        this.putBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED, enabled);
    }

    public boolean isKustoEnabled() {
        return this.getBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED);
    }

    public boolean isKustoEnabled(boolean defValue) {
        return this.getBoolean(SHARED_PREFS_KEY_IS_KUSTO_ENABLED, defValue);
    }

    public void setSimCountry(@NonNull String simCountry) {
        this.putString(SHARED_PREFS_KEY_SIM_COUNTRY, simCountry);
    }

    public String getSimCountry() {
        return this.getString(SHARED_PREFS_KEY_SIM_COUNTRY);
    }

    public void addCrashEventThatNeedSendToKusto(String event) {
        HashSet<String> kustoCrashEventsThatNeedToSend = new HashSet<String>(this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()));
        kustoCrashEventsThatNeedToSend.add(event);
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, kustoCrashEventsThatNeedToSend).apply();
    }

    public Set<String> getCrashEventsThatNeedSendToKusto() {
        return this.sharedPreferences.getStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet());
    }

    public void clearCrashEventsThatNeedSendToKusto() {
        this.sharedPreferences.edit().putStringSet(CRASHES_EVENTS_NEED_TO_SEND_TO_KUSTO, new HashSet()).apply();
    }

    public void setLastCheckNotificationDisabledStatusEventTime(long lastCheckNotificationDisabledStatusEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME, lastCheckNotificationDisabledStatusEventTime);
    }

    public long getLastCheckNotificationDisabledStatusEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CHECK_NOTIFICATION_DISABLED_STATUS_EVENT_TIME);
    }
}

