/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.util;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.PlacementSharedUtil;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedNotificationUtil;
import com.taboola.android.plus.notifications.scheduled.IScheduledNotificationsInternal;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBNotificationRefreshJob;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@RequiresApi(api=21)
public class ScheduledNotificationUtil
extends PlacementSharedUtil {
    private static final String TAG = ScheduledNotificationUtil.class.getSimpleName();
    private final TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager;
    private final ScheduledNotificationsLocalStorage notificationsLocalStorage;
    private final Context context;
    private static final String TB_ITEM_KEY_DISTRIBUTED_CONTENT = "is-dc";
    private static final String TB_ITEM_KEY_ORIGIN = "origin";
    private static final String TB_ITEM_BOOLEAN_VALUE_FALSE = "false";
    private static final String TB_ITEM_ORIGIN_VALUE_SPONSORED = "sponsored";

    public ScheduledNotificationUtil(@NonNull TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager, @NonNull ScheduledNotificationsLocalStorage notificationsLocalStorage, @NonNull Context context) {
        this.scheduledAnalyticsManager = scheduledAnalyticsManager;
        this.notificationsLocalStorage = notificationsLocalStorage;
        this.context = context;
    }

    public static void rescheduleJobIfNeeded(IScheduledNotificationsInternal manager) {
        Log.d((String)TAG, (String)"rescheduleJobIfNeeded() called");
        Context context = manager.getApplicationContext();
        ScheduledNotificationsLocalStorage scheduledLocalStorage = manager.getScheduledLocalStorage();
        if (!scheduledLocalStorage.isNotificationEnabled()) {
            Log.d((String)TAG, (String)"rescheduleJobIfNeeded: Scheduled notifications are disabled");
            return;
        }
        List<String> notificationCategories = scheduledLocalStorage.getNotificationCategories();
        if (notificationCategories.isEmpty()) {
            Log.w((String)TAG, (String)"rescheduleJobIfNeeded: failed to restore notification refresh job: empty categories");
            return;
        }
        if (TBNotificationRefreshJob.isJobRunning(context)) {
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: job is already scheduled, no actions needed");
        } else {
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: periodic refresh job is not scheduled, scheduling");
            manager.getScheduledNotificationController().dismissNotification();
            TBNotificationRefreshJob.scheduleNotificationRefreshJob(manager.getApplicationContext(), notificationCategories, manager.getNotificationConfig().getJobTriggerIntervalMs());
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: successfully restored notification refresh job");
        }
    }

    @UiThread
    public void reportPlacementVisibility(@NonNull List<TBPlacement> placementsToReportVisibility) {
        if (TaboolaApi.getInstance().isInitialized()) {
            for (TBPlacement tbPlacement : placementsToReportVisibility) {
                int itemIndex = 0;
                TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)tbPlacement.getItems().get(itemIndex);
                tbRecommendationItem.notifyAvailable();
                tbRecommendationItem.notifyVisible();
            }
        } else {
            String info = "ScheduledNotificationStateReceiver: reportVisibility()";
            this.scheduledAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    public int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public int getNotificationAppIconId() {
        int cachedNotificationAppIconId = this.notificationsLocalStorage.getNotificationAppIconId();
        if (ResourcesUtil.isResourceValid(this.context, cachedNotificationAppIconId)) {
            return cachedNotificationAppIconId;
        }
        return this.context.getApplicationInfo().icon;
    }

    public void setNotificationAppIconId(int newNotificationAppIconId) {
        if (ResourcesUtil.isResourceValid(this.context, newNotificationAppIconId)) {
            this.notificationsLocalStorage.setNotificationAppIconId(newNotificationAppIconId);
        }
    }

    public String getNotificationAppNameLabel(ScheduledNotificationsConfig.ScheduledNotificationsLayout scheduledNotificationsLayout) {
        String appName = this.notificationsLocalStorage.getNotificationAppNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        appName = scheduledNotificationsLayout.getApplicationNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        return SharedNotificationUtil.getCurrentApplicationName(this.context);
    }

    public void setNotificationAppNameLabel(String newAppNameLabel) {
        this.notificationsLocalStorage.setNotificationAppNameLabel(newAppNameLabel);
    }

    public static List<Integer> generateHotItemIdsList(int contentSize, int hotItemsCount) {
        if (hotItemsCount > contentSize) {
            hotItemsCount = contentSize;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(contentSize);
        for (int i = 0; i < contentSize; ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        return list.subList(0, hotItemsCount);
    }

    public static JsonElement createJsonElementFromRecommendationItem(TBRecommendationItem item) {
        HashMap map = item.getExtraDataMap();
        JsonObject jsonElement = new JsonObject();
        jsonElement.addProperty("description", (String)map.get("description"));
        jsonElement.addProperty("branding", (String)map.get("branding"));
        jsonElement.addProperty("name", (String)map.get("name"));
        jsonElement.addProperty("created", (String)map.get("created"));
        jsonElement.addProperty(TB_ITEM_ORIGIN_VALUE_SPONSORED, Boolean.valueOf(ScheduledNotificationUtil.isSponsoredItem(item)));
        jsonElement.addProperty("thumbnail", ScheduledNotificationUtil.getItemThumbnailUrl(item));
        return jsonElement;
    }

    public static boolean isSponsoredItem(@NonNull TBRecommendationItem item) {
        if (item.getExtraDataMap().containsKey(TB_ITEM_KEY_DISTRIBUTED_CONTENT)) {
            return TB_ITEM_BOOLEAN_VALUE_FALSE.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DISTRIBUTED_CONTENT))) && item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && TB_ITEM_ORIGIN_VALUE_SPONSORED.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)));
        }
        return item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && TB_ITEM_ORIGIN_VALUE_SPONSORED.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)));
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }
}

