/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.taboola.android.plus.common.BaseConfig;
import com.taboola.android.plus.notifications.scheduled.content.NotificationContentConfig;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreItemConfig;
import com.taboola.android.plus.notifications.scheduled.read_more.ReadMoreNotificationsLayoutConfig;
import com.taboola.android.plus.notifications.scheduled.time_window.AllowedTimeWindows;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class ScheduledNotificationsConfig
extends BaseConfig
implements Parcelable {
    static final String NOTIFICATIONS_CONTENT = "notificationsContent";
    static final String SMART_NOTIFICATION_FREQUENCY = "smartNotificationFrequency";
    static final String READ_MORE_ITEM = "readMoreItem";
    static final String SCHEDULED_NOTIFICATIONS_LAYOUT = "scheduledNotificationsLayout";
    private static final String IS_SCHEDULED_NOTIFICATIONS_FEATURE_ENABLED = "isScheduledNotificationsFeatureEnabled";
    private static final String JOB_TRIGGER_INTERVAL_MS = "jobTriggerIntervalMs";
    @SerializedName(value="isScheduledNotificationsFeatureEnabled")
    private boolean isScheduledNotificationsFeatureEnabled = true;
    @SerializedName(value="jobTriggerIntervalMs")
    private long jobTriggerIntervalMs = 900000L;
    @SerializedName(value="notificationsContent")
    private NotificationContentConfig notificationContent = new NotificationContentConfig();
    @SerializedName(value="smartNotificationFrequency")
    private SmartNotificationFrequency smartNotificationFrequency = new SmartNotificationFrequency();
    @SerializedName(value="scheduledNotificationsLayout")
    private ScheduledNotificationsLayout scheduledNotificationsLayout = new ScheduledNotificationsLayout();
    @SerializedName(value="readMoreItem")
    private ReadMoreItemConfig readMoreItem = new ReadMoreItemConfig();
    public static final Parcelable.Creator<ScheduledNotificationsConfig> CREATOR = new Parcelable.Creator<ScheduledNotificationsConfig>(){

        public ScheduledNotificationsConfig createFromParcel(Parcel source) {
            return new ScheduledNotificationsConfig(source);
        }

        public ScheduledNotificationsConfig[] newArray(int size) {
            return new ScheduledNotificationsConfig[size];
        }
    };

    public static ArrayList<String> getRequiredFields() {
        return new ArrayList<String>(Arrays.asList(NOTIFICATIONS_CONTENT, SMART_NOTIFICATION_FREQUENCY));
    }

    public boolean isScheduledNotificationsFeatureEnabled() {
        return this.isScheduledNotificationsFeatureEnabled;
    }

    public long getJobTriggerIntervalMs() {
        return this.jobTriggerIntervalMs;
    }

    public NotificationContentConfig getNotificationContent() {
        return this.notificationContent;
    }

    public SmartNotificationFrequency getSmartNotificationFrequency() {
        return this.smartNotificationFrequency;
    }

    public ScheduledNotificationsLayout getScheduledNotificationsLayout() {
        return this.scheduledNotificationsLayout;
    }

    public ReadMoreItemConfig getReadMoreItem() {
        return this.readMoreItem;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.isScheduledNotificationsFeatureEnabled ? (byte)1 : 0);
        dest.writeLong(this.jobTriggerIntervalMs);
        dest.writeParcelable((Parcelable)this.notificationContent, flags);
        dest.writeParcelable((Parcelable)this.smartNotificationFrequency, flags);
        dest.writeParcelable((Parcelable)this.scheduledNotificationsLayout, flags);
        dest.writeParcelable((Parcelable)this.readMoreItem, flags);
    }

    public ScheduledNotificationsConfig() {
    }

    private ScheduledNotificationsConfig(Parcel in) {
        this.isScheduledNotificationsFeatureEnabled = in.readByte() != 0;
        this.jobTriggerIntervalMs = in.readLong();
        this.notificationContent = (NotificationContentConfig)in.readParcelable(NotificationContentConfig.class.getClassLoader());
        this.smartNotificationFrequency = (SmartNotificationFrequency)in.readParcelable(SmartNotificationFrequency.class.getClassLoader());
        this.scheduledNotificationsLayout = (ScheduledNotificationsLayout)in.readParcelable(ScheduledNotificationsLayout.class.getClassLoader());
        this.readMoreItem = (ReadMoreItemConfig)in.readParcelable(ReadMoreItemConfig.class.getClassLoader());
    }

    public static class ScheduledNotificationsLayout
    implements Parcelable {
        private static final String APPLICATION_NAME_LABEL = "applicationNameLabel";
        private static final String PREFERRED_CONTENT_NOTIFICATION_LAYOUT = "preferredContentNotificationLayout";
        static final String READ_MORE_NOTIFICATIONS_LAYOUT = "readMoreNotificationsLayout";
        static final String CONTENT_NOTIFICATION_LAYOUT = "contentNotificationLayout";
        @SerializedName(value="readMoreNotificationsLayout")
        private ReadMoreNotificationsLayoutConfig readMoreNotificationsLayoutConfig = new ReadMoreNotificationsLayoutConfig();
        @SerializedName(value="applicationNameLabel")
        private String applicationNameLabel = "";
        @SerializedName(value="preferredContentNotificationLayout")
        private String preferredContentNotificationLayout = "singleItemNotificationsLayout";
        @SerializedName(value="contentNotificationLayout")
        private ContentNotificationLayout contentNotificationLayout = new ContentNotificationLayout();
        public static final Parcelable.Creator<ScheduledNotificationsLayout> CREATOR = new Parcelable.Creator<ScheduledNotificationsLayout>(){

            public ScheduledNotificationsLayout createFromParcel(Parcel source) {
                return new ScheduledNotificationsLayout(source);
            }

            public ScheduledNotificationsLayout[] newArray(int size) {
                return new ScheduledNotificationsLayout[size];
            }
        };

        public static ArrayList<String> getRequiredFields() {
            return new ArrayList<String>(Collections.singletonList(PREFERRED_CONTENT_NOTIFICATION_LAYOUT));
        }

        public ReadMoreNotificationsLayoutConfig getReadMoreNotificationsLayoutConfig() {
            return this.readMoreNotificationsLayoutConfig;
        }

        public String getApplicationNameLabel() {
            return this.applicationNameLabel;
        }

        public String getPreferredContentNotificationLayout() {
            return this.preferredContentNotificationLayout;
        }

        public ContentNotificationLayout getContentNotificationLayout() {
            return this.contentNotificationLayout;
        }

        public static Parcelable.Creator<ScheduledNotificationsLayout> getCREATOR() {
            return CREATOR;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.readMoreNotificationsLayoutConfig, flags);
            dest.writeString(this.applicationNameLabel);
            dest.writeString(this.preferredContentNotificationLayout);
            dest.writeParcelable((Parcelable)this.contentNotificationLayout, flags);
        }

        ScheduledNotificationsLayout() {
        }

        ScheduledNotificationsLayout(Parcel in) {
            this.readMoreNotificationsLayoutConfig = (ReadMoreNotificationsLayoutConfig)in.readParcelable(ReadMoreNotificationsLayoutConfig.class.getClassLoader());
            this.applicationNameLabel = in.readString();
            this.preferredContentNotificationLayout = in.readString();
            this.contentNotificationLayout = (ContentNotificationLayout)in.readParcelable(ContentNotificationLayout.class.getClassLoader());
        }

        public static class MultipleItemNotificationsLayout
        implements Parcelable {
            private static final String LAYOUT_SPECIFIC_PROPERTIES = "layoutSpecificProperties";
            private static final String PREFERRED_COLLAPSED_MULTIPLE_ITEM_LAYOUT = "preferredCollapsedMultipleItemLayout";
            private static final String PREFERRED_EXPANDED_MULTIPLE_ITEM_LAYOUT = "preferredExpandedMultipleItemLayout";
            @SerializedName(value="preferredCollapsedMultipleItemLayout")
            private String preferredCollapsedMultipleItemLayout = "layout_collapsed_multiple_default";
            @SerializedName(value="preferredExpandedMultipleItemLayout")
            private String preferredExpandedMultipleItemLayout = "layout_expanded_multiple_default";
            @SerializedName(value="layoutSpecificProperties")
            private LayoutSpecificProperties layoutSpecificProperties = new LayoutSpecificProperties();
            public static final Parcelable.Creator<MultipleItemNotificationsLayout> CREATOR = new Parcelable.Creator<MultipleItemNotificationsLayout>(){

                public MultipleItemNotificationsLayout createFromParcel(Parcel source) {
                    return new MultipleItemNotificationsLayout(source);
                }

                public MultipleItemNotificationsLayout[] newArray(int size) {
                    return new MultipleItemNotificationsLayout[size];
                }
            };

            public static ArrayList<String> getRequiredFields() {
                return new ArrayList<String>(Arrays.asList(PREFERRED_COLLAPSED_MULTIPLE_ITEM_LAYOUT, PREFERRED_EXPANDED_MULTIPLE_ITEM_LAYOUT));
            }

            public String getPreferredCollapsedMultipleItemLayout() {
                return this.preferredCollapsedMultipleItemLayout;
            }

            public String getPreferredExpandedMultipleItemLayout() {
                return this.preferredExpandedMultipleItemLayout;
            }

            public LayoutSpecificProperties getLayoutSpecificProperties() {
                return this.layoutSpecificProperties;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.preferredCollapsedMultipleItemLayout);
                dest.writeString(this.preferredExpandedMultipleItemLayout);
                dest.writeParcelable((Parcelable)this.layoutSpecificProperties, flags);
            }

            MultipleItemNotificationsLayout() {
            }

            MultipleItemNotificationsLayout(Parcel in) {
                this.preferredCollapsedMultipleItemLayout = in.readString();
                this.preferredExpandedMultipleItemLayout = in.readString();
                this.layoutSpecificProperties = (LayoutSpecificProperties)in.readParcelable(LayoutSpecificProperties.class.getClassLoader());
            }

            public static class LayoutSpecificProperties
            implements Parcelable {
                public static final Parcelable.Creator<LayoutSpecificProperties> CREATOR = new Parcelable.Creator<LayoutSpecificProperties>(){

                    public LayoutSpecificProperties createFromParcel(Parcel source) {
                        return new LayoutSpecificProperties(source);
                    }

                    public LayoutSpecificProperties[] newArray(int size) {
                        return new LayoutSpecificProperties[size];
                    }
                };

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                }

                LayoutSpecificProperties() {
                }

                LayoutSpecificProperties(Parcel in) {
                }
            }
        }

        public static class SingleItemNotificationsLayout
        implements Parcelable {
            static final String TRENDING_NOTIFICATIONS_LAYOUT = "trendingNotificationsLayout";
            static final String SPONSORED_NOTIFICATIONS_LAYOUT = "sponsoredNotificationsLayout";
            @SerializedName(value="trendingNotificationsLayout")
            private TrendingNotificationsLayout trendingNotificationsLayout = new TrendingNotificationsLayout();
            @SerializedName(value="sponsoredNotificationsLayout")
            private SponsoredNotificationsLayout sponsoredNotificationsLayout = new SponsoredNotificationsLayout();
            public static final Parcelable.Creator<SingleItemNotificationsLayout> CREATOR = new Parcelable.Creator<SingleItemNotificationsLayout>(){

                public SingleItemNotificationsLayout createFromParcel(Parcel source) {
                    return new SingleItemNotificationsLayout(source);
                }

                public SingleItemNotificationsLayout[] newArray(int size) {
                    return new SingleItemNotificationsLayout[size];
                }
            };

            public TrendingNotificationsLayout getTrendingNotificationsLayout() {
                return this.trendingNotificationsLayout;
            }

            public SponsoredNotificationsLayout getSponsoredNotificationsLayout() {
                return this.sponsoredNotificationsLayout;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeParcelable((Parcelable)this.trendingNotificationsLayout, flags);
                dest.writeParcelable((Parcelable)this.sponsoredNotificationsLayout, flags);
            }

            SingleItemNotificationsLayout() {
            }

            SingleItemNotificationsLayout(Parcel in) {
                this.trendingNotificationsLayout = (TrendingNotificationsLayout)in.readParcelable(TrendingNotificationsLayout.class.getClassLoader());
                this.sponsoredNotificationsLayout = (SponsoredNotificationsLayout)in.readParcelable(SponsoredNotificationsLayout.class.getClassLoader());
            }

            public static class SponsoredNotificationsLayout
            implements Parcelable {
                private static final String LAYOUT_SPECIFIC_PROPERTIES = "layoutSpecificProperties";
                private static final String PREFERRED_COLLAPSED_SPONSORED_LAYOUT = "preferredCollapsedSponsoredLayout";
                private static final String PREFERRED_EXPANDED_SPONSORED_LAYOUT = "preferredExpandedSponsoredLayout";
                @SerializedName(value="preferredCollapsedSponsoredLayout")
                private String preferredCollapsedSponsoredLayout = "layout_sponsored_content_collapsed_default";
                @SerializedName(value="preferredExpandedSponsoredLayout")
                private String preferredExpandedSponsoredLayout = "layout_sponsored_content_expanded_default";
                @SerializedName(value="layoutSpecificProperties")
                private LayoutSpecificProperties layoutSpecificProperties = new LayoutSpecificProperties();
                public static final Parcelable.Creator<SponsoredNotificationsLayout> CREATOR = new Parcelable.Creator<SponsoredNotificationsLayout>(){

                    public SponsoredNotificationsLayout createFromParcel(Parcel source) {
                        return new SponsoredNotificationsLayout(source);
                    }

                    public SponsoredNotificationsLayout[] newArray(int size) {
                        return new SponsoredNotificationsLayout[size];
                    }
                };

                public static ArrayList<String> getRequiredFields() {
                    return new ArrayList<String>(Arrays.asList(PREFERRED_COLLAPSED_SPONSORED_LAYOUT, PREFERRED_EXPANDED_SPONSORED_LAYOUT));
                }

                public String getPreferredCollapsedSponsoredLayout() {
                    return this.preferredCollapsedSponsoredLayout;
                }

                public String getPreferredExpandedSponsoredLayout() {
                    return this.preferredExpandedSponsoredLayout;
                }

                public LayoutSpecificProperties getLayoutSpecificProperties() {
                    return this.layoutSpecificProperties;
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeString(this.preferredCollapsedSponsoredLayout);
                    dest.writeString(this.preferredExpandedSponsoredLayout);
                    dest.writeParcelable((Parcelable)this.layoutSpecificProperties, flags);
                }

                SponsoredNotificationsLayout() {
                }

                SponsoredNotificationsLayout(Parcel in) {
                    this.preferredCollapsedSponsoredLayout = in.readString();
                    this.preferredExpandedSponsoredLayout = in.readString();
                    this.layoutSpecificProperties = (LayoutSpecificProperties)in.readParcelable(LayoutSpecificProperties.class.getClassLoader());
                }

                public static class LayoutSpecificProperties
                implements Parcelable {
                    public static final Parcelable.Creator<LayoutSpecificProperties> CREATOR = new Parcelable.Creator<LayoutSpecificProperties>(){

                        public LayoutSpecificProperties createFromParcel(Parcel source) {
                            return new LayoutSpecificProperties(source);
                        }

                        public LayoutSpecificProperties[] newArray(int size) {
                            return new LayoutSpecificProperties[size];
                        }
                    };

                    public int describeContents() {
                        return 0;
                    }

                    public void writeToParcel(Parcel dest, int flags) {
                    }

                    LayoutSpecificProperties() {
                    }

                    LayoutSpecificProperties(Parcel in) {
                    }
                }
            }

            public static class TrendingNotificationsLayout
            implements Parcelable {
                private static final String HOT_ITEMS_COUNT = "hotItemsCount";
                private static final String LAYOUT_SPECIFIC_PROPERTIES = "layoutSpecificProperties";
                private static final String PREFERRED_COLLAPSED_TRENDING_LAYOUT = "preferredCollapsedTrendingLayout";
                private static final String PREFERRED_EXPANDED_TRENDING_LAYOUT = "preferredExpandedTrendingLayout";
                @SerializedName(value="preferredCollapsedTrendingLayout")
                private String preferredCollapsedTrendingLayout = "layout_collapsed_single_default";
                @SerializedName(value="preferredExpandedTrendingLayout")
                private String preferredExpandedTrendingLayout = "layout_expanded_single_default";
                @SerializedName(value="hotItemsCount")
                private int hotItemsCount = 0;
                @SerializedName(value="layoutSpecificProperties")
                private LayoutSpecificProperties layoutSpecificProperties = new LayoutSpecificProperties();
                public static final Parcelable.Creator<TrendingNotificationsLayout> CREATOR = new Parcelable.Creator<TrendingNotificationsLayout>(){

                    public TrendingNotificationsLayout createFromParcel(Parcel source) {
                        return new TrendingNotificationsLayout(source);
                    }

                    public TrendingNotificationsLayout[] newArray(int size) {
                        return new TrendingNotificationsLayout[size];
                    }
                };

                public static ArrayList<String> getRequiredFields() {
                    return new ArrayList<String>(Arrays.asList(PREFERRED_COLLAPSED_TRENDING_LAYOUT, PREFERRED_EXPANDED_TRENDING_LAYOUT));
                }

                public String getPreferredCollapsedTrendingLayout() {
                    return this.preferredCollapsedTrendingLayout;
                }

                public String getPreferredExpandedTrendingLayout() {
                    return this.preferredExpandedTrendingLayout;
                }

                public int getHotItemsCount() {
                    return this.hotItemsCount;
                }

                public LayoutSpecificProperties getLayoutSpecificProperties() {
                    return this.layoutSpecificProperties;
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeString(this.preferredCollapsedTrendingLayout);
                    dest.writeString(this.preferredExpandedTrendingLayout);
                    dest.writeInt(this.hotItemsCount);
                    dest.writeParcelable((Parcelable)this.layoutSpecificProperties, flags);
                }

                TrendingNotificationsLayout() {
                }

                TrendingNotificationsLayout(Parcel in) {
                    this.preferredCollapsedTrendingLayout = in.readString();
                    this.preferredExpandedTrendingLayout = in.readString();
                    this.hotItemsCount = in.readInt();
                    this.layoutSpecificProperties = (LayoutSpecificProperties)in.readParcelable(LayoutSpecificProperties.class.getClassLoader());
                }

                public static class LayoutSpecificProperties
                implements Parcelable {
                    private static final String LAYOUT_COLLAPSED_SINGLE_DEFAULT = "layout_collapsed_single_default";
                    private static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_1 = "layout_collapsed_single_item_v1";
                    private static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V_2 = "layout_collapsed_single_item_v2";
                    private static final String LAYOUT_EXPANDED_SINGLE_DEFAULT = "layout_expanded_single_default";
                    @SerializedName(value="layout_collapsed_single_default")
                    private LayoutCollapsedSingleDefault layoutCollapsedSingleDefault = new LayoutCollapsedSingleDefault();
                    @SerializedName(value="layout_collapsed_single_item_v1")
                    private LayoutCollapsedSingleItemV1 layoutCollapsedSingleItemV1 = new LayoutCollapsedSingleItemV1();
                    @SerializedName(value="layout_collapsed_single_item_v2")
                    private LayoutCollapsedSingleItemV2 layoutCollapsedSingleItemV2 = new LayoutCollapsedSingleItemV2();
                    @SerializedName(value="layout_expanded_single_default")
                    private LayoutExpandedSingleDefault layoutExpandedSingleDefault = new LayoutExpandedSingleDefault();
                    public static final Parcelable.Creator<LayoutSpecificProperties> CREATOR = new Parcelable.Creator<LayoutSpecificProperties>(){

                        public LayoutSpecificProperties createFromParcel(Parcel source) {
                            return new LayoutSpecificProperties(source);
                        }

                        public LayoutSpecificProperties[] newArray(int size) {
                            return new LayoutSpecificProperties[size];
                        }
                    };

                    public LayoutCollapsedSingleDefault getLayoutCollapsedSingleDefault() {
                        return this.layoutCollapsedSingleDefault;
                    }

                    public LayoutCollapsedSingleItemV1 getLayoutCollapsedSingleItemV1() {
                        return this.layoutCollapsedSingleItemV1;
                    }

                    public LayoutCollapsedSingleItemV2 getLayoutCollapsedSingleItemV2() {
                        return this.layoutCollapsedSingleItemV2;
                    }

                    public LayoutExpandedSingleDefault getLayoutExpandedSingleDefault() {
                        return this.layoutExpandedSingleDefault;
                    }

                    public int describeContents() {
                        return 0;
                    }

                    public void writeToParcel(Parcel dest, int flags) {
                        dest.writeParcelable((Parcelable)this.layoutCollapsedSingleDefault, flags);
                        dest.writeParcelable((Parcelable)this.layoutCollapsedSingleItemV1, flags);
                        dest.writeParcelable((Parcelable)this.layoutCollapsedSingleItemV2, flags);
                        dest.writeParcelable((Parcelable)this.layoutExpandedSingleDefault, flags);
                    }

                    LayoutSpecificProperties() {
                    }

                    LayoutSpecificProperties(Parcel in) {
                        this.layoutCollapsedSingleDefault = (LayoutCollapsedSingleDefault)in.readParcelable(LayoutCollapsedSingleDefault.class.getClassLoader());
                        this.layoutCollapsedSingleItemV1 = (LayoutCollapsedSingleItemV1)in.readParcelable(LayoutCollapsedSingleItemV1.class.getClassLoader());
                        this.layoutCollapsedSingleItemV2 = (LayoutCollapsedSingleItemV2)in.readParcelable(LayoutCollapsedSingleItemV2.class.getClassLoader());
                        this.layoutExpandedSingleDefault = (LayoutExpandedSingleDefault)in.readParcelable(LayoutExpandedSingleDefault.class.getClassLoader());
                    }

                    static class LayoutExpandedSingleDefault
                    implements Parcelable {
                        private static final String SHOULD_HIDE_TIME = "shouldHideTime";
                        private static final String SHOULD_HIDE_DESCRIPTION = "shouldHideDescription";
                        @SerializedName(value="shouldHideTime")
                        private boolean shouldHideTime = false;
                        @SerializedName(value="shouldHideDescription")
                        private boolean shouldHideDescription = false;
                        public static final Parcelable.Creator<LayoutExpandedSingleDefault> CREATOR = new Parcelable.Creator<LayoutExpandedSingleDefault>(){

                            public LayoutExpandedSingleDefault createFromParcel(Parcel source) {
                                return new LayoutExpandedSingleDefault(source);
                            }

                            public LayoutExpandedSingleDefault[] newArray(int size) {
                                return new LayoutExpandedSingleDefault[size];
                            }
                        };

                        public Boolean getShouldHideTime() {
                            return this.shouldHideTime;
                        }

                        public Boolean getShouldHideDescription() {
                            return this.shouldHideDescription;
                        }

                        public int describeContents() {
                            return 0;
                        }

                        public void writeToParcel(Parcel dest, int flags) {
                            dest.writeByte(this.shouldHideTime ? (byte)1 : 0);
                            dest.writeByte(this.shouldHideDescription ? (byte)1 : 0);
                        }

                        public LayoutExpandedSingleDefault() {
                        }

                        protected LayoutExpandedSingleDefault(Parcel in) {
                            this.shouldHideTime = in.readByte() != 0;
                            this.shouldHideDescription = in.readByte() != 0;
                        }
                    }

                    static class LayoutCollapsedSingleItemV2
                    implements Parcelable {
                        private static final String SHOULD_ACTION_BUTTON_BE_TRANSPARENT = "shouldActionButtonBeTransparent";
                        private static final String OPEN_BUTTON_TEXT_STRING_ID = "openButtonTextStringId";
                        private static final String SHOULD_HIDE_TIME = "shouldHideTime";
                        private static final String SHOULD_HIDE_DESCRIPTION = "shouldHideDescription";
                        @SerializedName(value="shouldActionButtonBeTransparent")
                        private boolean shouldActionButtonBeTransparent = false;
                        @SerializedName(value="openButtonTextStringId")
                        private String openButtonTextStringId;
                        @SerializedName(value="shouldHideTime")
                        private boolean shouldHideTime = false;
                        @SerializedName(value="shouldHideDescription")
                        private boolean shouldHideDescription = false;
                        public static final Parcelable.Creator<LayoutCollapsedSingleItemV2> CREATOR = new Parcelable.Creator<LayoutCollapsedSingleItemV2>(){

                            public LayoutCollapsedSingleItemV2 createFromParcel(Parcel source) {
                                return new LayoutCollapsedSingleItemV2(source);
                            }

                            public LayoutCollapsedSingleItemV2[] newArray(int size) {
                                return new LayoutCollapsedSingleItemV2[size];
                            }
                        };

                        public boolean getShouldActionButtonBeTransparent() {
                            return this.shouldActionButtonBeTransparent;
                        }

                        public String getOpenButtonTextStringId() {
                            return this.openButtonTextStringId;
                        }

                        public boolean getShouldHideTime() {
                            return this.shouldHideTime;
                        }

                        public boolean getShouldHideDescription() {
                            return this.shouldHideDescription;
                        }

                        public int describeContents() {
                            return 0;
                        }

                        public void writeToParcel(Parcel dest, int flags) {
                            dest.writeByte(this.shouldActionButtonBeTransparent ? (byte)1 : 0);
                            dest.writeString(this.openButtonTextStringId);
                            dest.writeByte(this.shouldHideTime ? (byte)1 : 0);
                            dest.writeByte(this.shouldHideDescription ? (byte)1 : 0);
                        }

                        public LayoutCollapsedSingleItemV2() {
                        }

                        protected LayoutCollapsedSingleItemV2(Parcel in) {
                            this.shouldActionButtonBeTransparent = in.readByte() != 0;
                            this.openButtonTextStringId = in.readString();
                            this.shouldHideTime = in.readByte() != 0;
                            this.shouldHideDescription = in.readByte() != 0;
                        }
                    }

                    static class LayoutCollapsedSingleItemV1
                    implements Parcelable {
                        private static final String ACTION_NEXT_TEXT_STRING_ID = "actionNextTextStringId";
                        private static final String ACTION_NEXT_ICON_URL = "actionNextIconUrl";
                        private static final String SHOULD_HIDE_TIME = "shouldHideTime";
                        private static final String SHOULD_HIDE_DESCRIPTION = "shouldHideDescription";
                        @SerializedName(value="actionNextTextStringId")
                        private String actionNextTextStringId;
                        @SerializedName(value="actionNextIconUrl")
                        private String actionNextIconUrl = "";
                        @SerializedName(value="shouldHideTime")
                        private boolean shouldHideTime = false;
                        @SerializedName(value="shouldHideDescription")
                        private boolean shouldHideDescription = false;
                        public static final Parcelable.Creator<LayoutCollapsedSingleItemV1> CREATOR = new Parcelable.Creator<LayoutCollapsedSingleItemV1>(){

                            public LayoutCollapsedSingleItemV1 createFromParcel(Parcel source) {
                                return new LayoutCollapsedSingleItemV1(source);
                            }

                            public LayoutCollapsedSingleItemV1[] newArray(int size) {
                                return new LayoutCollapsedSingleItemV1[size];
                            }
                        };

                        public String getActionNextTextStringId() {
                            return this.actionNextTextStringId;
                        }

                        public String getActionNextIconUrl() {
                            return this.actionNextIconUrl;
                        }

                        public boolean getShouldHideTime() {
                            return this.shouldHideTime;
                        }

                        public boolean getShouldHideDescription() {
                            return this.shouldHideDescription;
                        }

                        public int describeContents() {
                            return 0;
                        }

                        public void writeToParcel(Parcel dest, int flags) {
                            dest.writeString(this.actionNextTextStringId);
                            dest.writeString(this.actionNextIconUrl);
                            dest.writeByte(this.shouldHideTime ? (byte)1 : 0);
                            dest.writeByte(this.shouldHideDescription ? (byte)1 : 0);
                        }

                        public LayoutCollapsedSingleItemV1() {
                        }

                        protected LayoutCollapsedSingleItemV1(Parcel in) {
                            this.actionNextTextStringId = in.readString();
                            this.actionNextIconUrl = in.readString();
                            this.shouldHideTime = in.readByte() != 0;
                            this.shouldHideDescription = in.readByte() != 0;
                        }
                    }

                    static class LayoutCollapsedSingleDefault
                    implements Parcelable {
                        private static final String SHOULD_IMAGE_PLACED_RIGHT = "shouldImagePlacedRight";
                        @SerializedName(value="shouldImagePlacedRight")
                        private boolean shouldImagePlacedRight = false;
                        public static final Parcelable.Creator<LayoutCollapsedSingleDefault> CREATOR = new Parcelable.Creator<LayoutCollapsedSingleDefault>(){

                            public LayoutCollapsedSingleDefault createFromParcel(Parcel source) {
                                return new LayoutCollapsedSingleDefault(source);
                            }

                            public LayoutCollapsedSingleDefault[] newArray(int size) {
                                return new LayoutCollapsedSingleDefault[size];
                            }
                        };

                        public boolean getShouldImagePlacedRight() {
                            return this.shouldImagePlacedRight;
                        }

                        public int describeContents() {
                            return 0;
                        }

                        public void writeToParcel(Parcel dest, int flags) {
                            dest.writeByte(this.shouldImagePlacedRight ? (byte)1 : 0);
                        }

                        public LayoutCollapsedSingleDefault() {
                        }

                        protected LayoutCollapsedSingleDefault(Parcel in) {
                            this.shouldImagePlacedRight = in.readByte() != 0;
                        }
                    }
                }
            }
        }

        public static class ContentNotificationLayout
        implements Parcelable {
            static final String SINGLE_ITEM_NOTIFICATIONS_LAYOUT = "singleItemNotificationsLayout";
            static final String MULTIPLE_ITEM_NOTIFICATIONS_LAYOUT = "multipleItemNotificationsLayout";
            @SerializedName(value="singleItemNotificationsLayout")
            private SingleItemNotificationsLayout singleItemNotificationsLayout = new SingleItemNotificationsLayout();
            @SerializedName(value="multipleItemNotificationsLayout")
            MultipleItemNotificationsLayout multipleItemNotificationsLayout = new MultipleItemNotificationsLayout();
            public static final Parcelable.Creator<ContentNotificationLayout> CREATOR = new Parcelable.Creator<ContentNotificationLayout>(){

                public ContentNotificationLayout createFromParcel(Parcel source) {
                    return new ContentNotificationLayout(source);
                }

                public ContentNotificationLayout[] newArray(int size) {
                    return new ContentNotificationLayout[size];
                }
            };

            public SingleItemNotificationsLayout getSingleItemNotificationsLayout() {
                return this.singleItemNotificationsLayout;
            }

            public MultipleItemNotificationsLayout getMultipleItemNotificationsLayout() {
                return this.multipleItemNotificationsLayout;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeParcelable((Parcelable)this.singleItemNotificationsLayout, flags);
                dest.writeParcelable((Parcelable)this.multipleItemNotificationsLayout, flags);
            }

            ContentNotificationLayout() {
            }

            ContentNotificationLayout(Parcel in) {
                this.singleItemNotificationsLayout = (SingleItemNotificationsLayout)in.readParcelable(SingleItemNotificationsLayout.class.getClassLoader());
                this.multipleItemNotificationsLayout = (MultipleItemNotificationsLayout)in.readParcelable(MultipleItemNotificationsLayout.class.getClassLoader());
            }
        }
    }

    public static class SmartNotificationFrequency
    implements Parcelable {
        static final String ENGAGEMENT_GROUPS = "engagementGroups";
        @SerializedName(value="engagementGroups")
        private ArrayList<EngagementGroups> engagementGroups = new ArrayList();
        public static final Parcelable.Creator<SmartNotificationFrequency> CREATOR = new Parcelable.Creator<SmartNotificationFrequency>(){

            public SmartNotificationFrequency createFromParcel(Parcel source) {
                return new SmartNotificationFrequency(source);
            }

            public SmartNotificationFrequency[] newArray(int size) {
                return new SmartNotificationFrequency[size];
            }
        };

        public static ArrayList<String> getRequiredFields() {
            return new ArrayList<String>(Collections.singletonList(ENGAGEMENT_GROUPS));
        }

        public ArrayList<EngagementGroups> getEngagementGroups() {
            return this.engagementGroups;
        }

        void setEngagementGroups(ArrayList<EngagementGroups> engagementGroups) {
            this.engagementGroups = engagementGroups;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.engagementGroups);
        }

        SmartNotificationFrequency() {
        }

        SmartNotificationFrequency(Parcel in) {
            this.engagementGroups = in.createTypedArrayList(EngagementGroups.CREATOR);
        }

        public static class SmartNotificationFrequencyAdapter
        implements JsonDeserializer<SmartNotificationFrequency>,
        JsonSerializer<SmartNotificationFrequency> {
            public SmartNotificationFrequency deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray engagementGroups = json.getAsJsonObject().get(SmartNotificationFrequency.ENGAGEMENT_GROUPS).getAsJsonArray();
                JsonArray mergedEngagementGroups = new JsonArray();
                JsonObject defaultGroup = this.getGroupByName(engagementGroups, "Default");
                if (defaultGroup == null) {
                    throw new JsonParseException("Invalid config, \"Default\" engagement group is missing ");
                }
                for (JsonElement element : engagementGroups) {
                    mergedEngagementGroups.add((JsonElement)this.mergeObjects(defaultGroup, element.getAsJsonObject()));
                }
                return this.parseSmartNotificationFrequency(json, mergedEngagementGroups);
            }

            public JsonElement serialize(SmartNotificationFrequency src, Type typeOfSrc, JsonSerializationContext context) {
                Gson gson = new Gson();
                Class type = new TypeToken<SmartNotificationFrequency>(){}.getRawType();
                return gson.toJsonTree((Object)src, (Type)type);
            }

            @Nullable
            private JsonObject getGroupByName(@NonNull JsonArray groupList, @NonNull String groupName) {
                for (JsonElement element : groupList) {
                    if (!element.getAsJsonObject().get("groupName").getAsString().equalsIgnoreCase(groupName)) continue;
                    return element.getAsJsonObject();
                }
                return null;
            }

            @NonNull
            private JsonObject mergeObjects(@NonNull JsonObject defaultObject, @NonNull JsonObject objectToMerge) {
                for (Map.Entry entry : defaultObject.entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        if (objectToMerge.has((String)entry.getKey())) continue;
                        objectToMerge.add((String)entry.getKey(), (JsonElement)entry.getValue());
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonObject()) {
                        if (!objectToMerge.has((String)entry.getKey())) {
                            objectToMerge.add((String)entry.getKey(), (JsonElement)entry.getValue());
                            continue;
                        }
                        JsonObject temp = this.mergeObjects(((JsonElement)entry.getValue()).getAsJsonObject(), objectToMerge.getAsJsonObject((String)entry.getKey()));
                        objectToMerge.add((String)entry.getKey(), (JsonElement)temp);
                        continue;
                    }
                    if (!((JsonElement)entry.getValue()).isJsonArray() || objectToMerge.has((String)entry.getKey()) && objectToMerge.getAsJsonArray((String)entry.getKey()).size() != 0) continue;
                    objectToMerge.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                return objectToMerge;
            }

            @NonNull
            private SmartNotificationFrequency parseSmartNotificationFrequency(@NonNull JsonElement json, @NonNull JsonArray groupsArray) {
                Gson gson = new Gson();
                Type type = new TypeToken<ArrayList<EngagementGroups>>(){}.getType();
                ArrayList groupsArrayList = (ArrayList)gson.fromJson((JsonElement)groupsArray, type);
                SmartNotificationFrequency smartNotificationFrequency = (SmartNotificationFrequency)gson.fromJson(json, SmartNotificationFrequency.class);
                smartNotificationFrequency.setEngagementGroups(groupsArrayList);
                return smartNotificationFrequency;
            }
        }

        public static class EngagementGroups
        implements Parcelable {
            static final String GROUP_NAME = "groupName";
            static final String DOWNGRADE_TO = "downgradeTo";
            static final String UPGRADE_TO = "upgradeTo";
            static final String USER_ACTIONS_COUNT_INTERVAL_MS = "userActionsCountIntervalMs";
            static final String ENGAGED_NOTIFICATION_THRESHOLD = "engagedNotificationThreshold";
            static final String UNENGAGED_NOTIFICATION_THRESHOLD = "unengagedNotificationThreshold";
            static final String NOTIFICATIONS_CONFIG = "notificationsConfig";
            @SerializedName(value="groupName")
            private String groupName = "";
            @SerializedName(value="downgradeTo")
            private String downgradeTo = "";
            @SerializedName(value="upgradeTo")
            private String upgradeTo = "";
            @SerializedName(value="userActionsCountIntervalMs")
            private long userActionsCountIntervalMs = 86400000L;
            @SerializedName(value="unengagedNotificationThreshold")
            private int unengagedNotificationThreshold = -1;
            @SerializedName(value="engagedNotificationThreshold")
            private int engagedNotificationThreshold = -1;
            @SerializedName(value="notificationsConfig")
            private NotificationsConfig notificationsConfig = new NotificationsConfig();
            public static final Parcelable.Creator<EngagementGroups> CREATOR = new Parcelable.Creator<EngagementGroups>(){

                public EngagementGroups createFromParcel(Parcel source) {
                    return new EngagementGroups(source);
                }

                public EngagementGroups[] newArray(int size) {
                    return new EngagementGroups[size];
                }
            };

            public static ArrayList<String> getRequiredFields() {
                return new ArrayList<String>(Arrays.asList(GROUP_NAME, DOWNGRADE_TO, UPGRADE_TO));
            }

            public static ArrayList<String> getDefaultRequiredFields() {
                return new ArrayList<String>(Arrays.asList(GROUP_NAME, DOWNGRADE_TO, UPGRADE_TO, USER_ACTIONS_COUNT_INTERVAL_MS, ENGAGED_NOTIFICATION_THRESHOLD, UNENGAGED_NOTIFICATION_THRESHOLD, NOTIFICATIONS_CONFIG));
            }

            public String getGroupName() {
                return this.groupName;
            }

            public String getDowngradeTo() {
                return this.downgradeTo;
            }

            public String getUpgradeTo() {
                return this.upgradeTo;
            }

            public long getUserActionsCountIntervalMs() {
                return this.userActionsCountIntervalMs;
            }

            public int getUnengagedNotificationThreshold() {
                return this.unengagedNotificationThreshold;
            }

            public int getEngagedNotificationThreshold() {
                return this.engagedNotificationThreshold;
            }

            public NotificationsConfig getNotificationsConfig() {
                return this.notificationsConfig;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.groupName);
                dest.writeString(this.downgradeTo);
                dest.writeString(this.upgradeTo);
                dest.writeLong(this.userActionsCountIntervalMs);
                dest.writeInt(this.unengagedNotificationThreshold);
                dest.writeInt(this.engagedNotificationThreshold);
                dest.writeParcelable((Parcelable)this.notificationsConfig, flags);
            }

            public EngagementGroups() {
            }

            EngagementGroups(Parcel in) {
                this.groupName = in.readString();
                this.downgradeTo = in.readString();
                this.upgradeTo = in.readString();
                this.userActionsCountIntervalMs = in.readLong();
                this.unengagedNotificationThreshold = in.readInt();
                this.engagedNotificationThreshold = in.readInt();
                this.notificationsConfig = (NotificationsConfig)in.readParcelable(NotificationsConfig.class.getClassLoader());
            }

            public static class NotificationsConfig
            implements Parcelable {
                static final String SHOULD_FETCH_ONLY_OVER_WIFI = "shouldFetchOnlyOverWifi";
                static final String MAX_RENDER_COUNT_PER_DAY = "maxRenderCountPerDay";
                static final String MIN_INTERVAL_BETWEEN_RENDER_MS = "minIntervalBetweenRenderMs";
                static final String AUTO_NEXT_INTERVAL_MS = "autoNextIntervalMs";
                static final String IDLE_NOTIFICATION_TIMEOUT_MS = "idleNotificationTimeoutMs";
                static final String ALLOWED_TIME_WINDOWS = "allowedTimeWindows";
                @SerializedName(value="shouldFetchOnlyOverWifi")
                private boolean shouldFetchOnlyOverWifi = false;
                @SerializedName(value="maxRenderCountPerDay")
                private int maxRenderCountPerDay = -1;
                @SerializedName(value="minIntervalBetweenRenderMs")
                private long minIntervalBetweenRenderMs = 900000L;
                @SerializedName(value="autoNextIntervalMs")
                private long autoNextIntervalMs = 60000L;
                @SerializedName(value="idleNotificationTimeoutMs")
                private long idleNotificationTimeoutMs = -1L;
                @SerializedName(value="allowedTimeWindows")
                private ArrayList<AllowedTimeWindows> allowedTimeWindows = new ArrayList();
                public static final Parcelable.Creator<NotificationsConfig> CREATOR = new Parcelable.Creator<NotificationsConfig>(){

                    public NotificationsConfig createFromParcel(Parcel source) {
                        return new NotificationsConfig(source);
                    }

                    public NotificationsConfig[] newArray(int size) {
                        return new NotificationsConfig[size];
                    }
                };

                public static ArrayList<String> getDefaultRequiredFields() {
                    return new ArrayList<String>(Arrays.asList(MAX_RENDER_COUNT_PER_DAY, MIN_INTERVAL_BETWEEN_RENDER_MS, AUTO_NEXT_INTERVAL_MS, SHOULD_FETCH_ONLY_OVER_WIFI, ALLOWED_TIME_WINDOWS));
                }

                public boolean isShouldFetchOnlyOverWifi() {
                    return this.shouldFetchOnlyOverWifi;
                }

                public int getMaxRenderCountPerDay() {
                    return this.maxRenderCountPerDay;
                }

                public long getMinIntervalBetweenRenderMs() {
                    return this.minIntervalBetweenRenderMs;
                }

                public long getAutoNextIntervalMs() {
                    return this.autoNextIntervalMs;
                }

                public long getIdleNotificationTimeoutMs() {
                    return this.idleNotificationTimeoutMs;
                }

                public ArrayList<AllowedTimeWindows> getAllowedTimeWindows() {
                    return this.allowedTimeWindows;
                }

                public int describeContents() {
                    return 0;
                }

                public void writeToParcel(Parcel dest, int flags) {
                    dest.writeByte(this.shouldFetchOnlyOverWifi ? (byte)1 : 0);
                    dest.writeInt(this.maxRenderCountPerDay);
                    dest.writeLong(this.minIntervalBetweenRenderMs);
                    dest.writeLong(this.autoNextIntervalMs);
                    dest.writeLong(this.idleNotificationTimeoutMs);
                    dest.writeTypedList(this.allowedTimeWindows);
                }

                NotificationsConfig() {
                }

                NotificationsConfig(Parcel in) {
                    this.shouldFetchOnlyOverWifi = in.readByte() != 0;
                    this.maxRenderCountPerDay = in.readInt();
                    this.minIntervalBetweenRenderMs = in.readLong();
                    this.autoNextIntervalMs = in.readLong();
                    this.idleNotificationTimeoutMs = in.readLong();
                    this.allowedTimeWindows = in.createTypedArrayList(AllowedTimeWindows.CREATOR);
                }
            }
        }
    }
}

