/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget.content;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.home.screen.widget.TBWidgetAnalyticsManager;
import com.taboola.android.plus.home.screen.widget.WidgetConfig;
import com.taboola.android.plus.notifications.scheduled.util.PlacementValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
public class WidgetContentRepository {
    private static final String TAG = WidgetContentRepository.class.getSimpleName();
    private static final String PAGE_URL_DEF = "http://www.taboola.com";
    private static final String SRC_TYPE = "text";
    private static final String TABOOLA_API_NOT_INITIALIZED = "TaboolaApi not initialized";
    private final Object resultLock = new Object();
    volatile boolean hasFailed;
    private int requestsToComplete;
    private int completedRequests;
    private volatile Map<String, List<TBPlacement>> requestsResult;

    public void execute(final @NonNull TBWidgetAnalyticsManager tbWidgetAnalyticsManager, @NonNull Map<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> categorizedPlacementNames, @Nullable String userUnifiedId, String viewId, final @NonNull OnContentFetchCallback callback) {
        this.requestsToComplete = categorizedPlacementNames.size();
        this.completedRequests = 0;
        this.requestsResult = new HashMap<String, List<TBPlacement>>();
        this.hasFailed = false;
        for (Map.Entry<String, WidgetConfig.WidgetContentConfig.CategoryToPlacementItem> categoriesEntry : categorizedPlacementNames.entrySet()) {
            final String categoryName = categoriesEntry.getKey();
            this.getContentFromTrc(tbWidgetAnalyticsManager, categoriesEntry.getValue().getPlacementName(), userUnifiedId, categoriesEntry.getValue().getItemsBatchSize(), viewId, new TBRecommendationRequestCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFetched(TBRecommendationsResponse response) {
                    ArrayList validPlacements = new ArrayList();
                    for (Map.Entry placementEntry : response.getPlacementsMap().entrySet()) {
                        if (placementEntry.getValue() != null && ((TBPlacement)placementEntry.getValue()).getItems() != null && !((TBPlacement)placementEntry.getValue()).getItems().isEmpty()) {
                            if (PlacementValidationUtil.isPlacementValid((TBPlacement)placementEntry.getValue(), tbWidgetAnalyticsManager)) {
                                validPlacements.add(placementEntry.getValue());
                            } else {
                                Log.w((String)TAG, (String)"onRecommendationsFetched: invalid placement");
                            }
                            Object object = WidgetContentRepository.this.resultLock;
                            synchronized (object) {
                                WidgetContentRepository.this.requestsResult.put(categoryName, validPlacements);
                                WidgetContentRepository.this.completedRequests++;
                                if (WidgetContentRepository.this.completedRequests == WidgetContentRepository.this.requestsToComplete && !WidgetContentRepository.this.hasFailed) {
                                    callback.onContentFetched(WidgetContentRepository.this.requestsResult);
                                }
                                continue;
                            }
                        }
                        Log.w((String)TAG, (String)"onRecommendationsFetched: placement has no items or null");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFailed(Throwable t) {
                    Object object = WidgetContentRepository.this.resultLock;
                    synchronized (object) {
                        if (!WidgetContentRepository.this.hasFailed) {
                            WidgetContentRepository.this.hasFailed = true;
                            callback.onContentFetchFailed(t);
                        }
                        Log.e((String)TAG, (String)"onContentFailed: ", (Throwable)t);
                    }
                }
            });
        }
    }

    public void getContentFromTrc(TBWidgetAnalyticsManager tbWidgetAnalyticsManager, String placementName, String userUnifiedId, int numberOfItems, String viewId, TBRecommendationRequestCallback callback) {
        int placementItemsCount = numberOfItems <= 0 ? 5 : numberOfItems;
        TBRecommendationsRequest request = new TBRecommendationsRequest(PAGE_URL_DEF, SRC_TYPE);
        if (!TextUtils.isEmpty((CharSequence)userUnifiedId)) {
            request.setUserUnifiedId(userUnifiedId);
        }
        TBPlacementRequest placementRequest = new TBPlacementRequest(placementName, placementItemsCount).setAvailable(false);
        request.addPlacementRequest(placementRequest);
        request.setViewId(viewId);
        if (TaboolaApi.getInstance().isInitialized()) {
            TaboolaApi.getInstance().fetchRecommendations(request, callback);
        } else {
            Log.e((String)TAG, (String)"getContentFromTrc: TaboolaApi not initialized");
            callback.onRecommendationsFailed(new Throwable(TABOOLA_API_NOT_INITIALIZED));
            tbWidgetAnalyticsManager.sendTaboolaApiNotInitializedEvent(TABOOLA_API_NOT_INITIALIZED);
        }
    }

    public static interface OnContentFetchCallback {
        public void onContentFetched(Map<String, List<TBPlacement>> var1);

        public void onContentFetchFailed(Throwable var1);
    }
}

