/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.common.BaseConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class WidgetConfig
extends BaseConfig
implements Parcelable {
    public static final String WIDGET_CONTENT_CONFIG = "widgetContentConfig";
    private static final String IS_APP_WIDGET_FEATURE_ENABLED = "isAppWidgetFeatureEnabled";
    private static final String WIDGET_REFRESH_INTERVAL_MS = "widgetRefreshIntervalMs";
    private static final String WIDGET_LABEL = "widgetLabel";
    @SerializedName(value="isAppWidgetFeatureEnabled")
    private boolean isAppWidgetFeatureEnabled = false;
    @SerializedName(value="widgetRefreshIntervalMs")
    private long widgetRefreshIntervalMs = 3600000L;
    @SerializedName(value="widgetLabel")
    private String widgetLabel = "";
    @SerializedName(value="widgetContentConfig")
    private WidgetContentConfig widgetContentConfig = new WidgetContentConfig();
    public static final Parcelable.Creator<WidgetConfig> CREATOR = new Parcelable.Creator<WidgetConfig>(){

        public WidgetConfig createFromParcel(Parcel source) {
            return new WidgetConfig(source);
        }

        public WidgetConfig[] newArray(int size) {
            return new WidgetConfig[size];
        }
    };

    public static ArrayList<String> getRequiredFields() {
        return new ArrayList<String>(Arrays.asList(IS_APP_WIDGET_FEATURE_ENABLED, WIDGET_REFRESH_INTERVAL_MS, WIDGET_CONTENT_CONFIG));
    }

    public boolean isAppWidgetFeatureEnabled() {
        return this.isAppWidgetFeatureEnabled;
    }

    public long getWidgetRefreshIntervalMs() {
        return this.widgetRefreshIntervalMs;
    }

    public String getWidgetLabel() {
        return this.widgetLabel;
    }

    public WidgetContentConfig getWidgetContentConfig() {
        return this.widgetContentConfig;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.isAppWidgetFeatureEnabled ? (byte)1 : 0);
        dest.writeLong(this.widgetRefreshIntervalMs);
        dest.writeString(this.widgetLabel);
        dest.writeParcelable((Parcelable)this.widgetContentConfig, flags);
    }

    public WidgetConfig() {
    }

    protected WidgetConfig(Parcel in) {
        this.isAppWidgetFeatureEnabled = in.readByte() != 0;
        this.widgetRefreshIntervalMs = in.readLong();
        this.widgetLabel = in.readString();
        this.widgetContentConfig = (WidgetContentConfig)in.readParcelable(WidgetContentConfig.class.getClassLoader());
    }

    public static class WidgetContentConfig
    implements Parcelable {
        public static final String CATEGORIZED_PLACEMENTS = "categoryToPlacement";
        private static final String EXTRA_PROPERTIES = "extraProperties";
        @SerializedName(value="categoryToPlacement")
        private HashMap<String, CategoryToPlacementItem> categorizedPlacements = new HashMap();
        @SerializedName(value="extraProperties")
        private HashMap<String, String> extraProperties = new HashMap();
        public static final Parcelable.Creator<WidgetContentConfig> CREATOR = new Parcelable.Creator<WidgetContentConfig>(){

            public WidgetContentConfig createFromParcel(Parcel source) {
                return new WidgetContentConfig(source);
            }

            public WidgetContentConfig[] newArray(int size) {
                return new WidgetContentConfig[size];
            }
        };

        public static ArrayList<String> getRequiredFields() {
            return new ArrayList<String>(Arrays.asList(CATEGORIZED_PLACEMENTS));
        }

        public HashMap<String, CategoryToPlacementItem> getCategorizedPlacements() {
            return this.categorizedPlacements;
        }

        public HashMap<String, String> getExtraProperties() {
            return this.extraProperties;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.categorizedPlacements.size());
            for (Map.Entry<String, CategoryToPlacementItem> entry : this.categorizedPlacements.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeParcelable((Parcelable)entry.getValue(), flags);
            }
            dest.writeInt(this.extraProperties.size());
            for (Map.Entry<String, Object> entry : this.extraProperties.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString((String)entry.getValue());
            }
        }

        public WidgetContentConfig() {
        }

        protected WidgetContentConfig(Parcel in) {
            int categoryToPlacementSize = in.readInt();
            this.categorizedPlacements = new HashMap(categoryToPlacementSize);
            for (int i = 0; i < categoryToPlacementSize; ++i) {
                String key = in.readString();
                CategoryToPlacementItem item = (CategoryToPlacementItem)in.readParcelable(CategoryToPlacementItem.class.getClassLoader());
                this.categorizedPlacements.put(key, item);
            }
            int taboolaApiExtraPropertiesSize = in.readInt();
            this.extraProperties = new HashMap(taboolaApiExtraPropertiesSize);
            for (int i = 0; i < taboolaApiExtraPropertiesSize; ++i) {
                String key = in.readString();
                String value = in.readString();
                if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) continue;
                this.extraProperties.put(key, value);
            }
        }

        public static class CategoryToPlacementItem
        implements Parcelable {
            public static final int DEFAULT_ITEMS_BATCH_SIZE = 5;
            private static final String ITEMS_BATCH_SIZE = "itemsBatchSize";
            private static final String PLACEMENT_NAME = "placementName";
            @SerializedName(value="placementName")
            String placementName = "";
            @SerializedName(value="itemsBatchSize")
            int itemsBatchSize = 5;
            public static final Parcelable.Creator<CategoryToPlacementItem> CREATOR = new Parcelable.Creator<CategoryToPlacementItem>(){

                public CategoryToPlacementItem createFromParcel(Parcel source) {
                    return new CategoryToPlacementItem(source);
                }

                public CategoryToPlacementItem[] newArray(int size) {
                    return new CategoryToPlacementItem[size];
                }
            };

            public String getPlacementName() {
                return this.placementName;
            }

            public int getItemsBatchSize() {
                return this.itemsBatchSize;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.placementName);
                dest.writeInt(this.itemsBatchSize);
            }

            public CategoryToPlacementItem() {
            }

            protected CategoryToPlacementItem(Parcel in) {
                this.placementName = in.readString();
                this.itemsBatchSize = in.readInt();
            }
        }
    }
}

