/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.home.screen.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.widget.RemoteViews;
import android.widget.RemoteViewsService;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.R;
import com.taboola.android.plus.common.ConditionCheckUtil;
import com.taboola.android.plus.common.PlacementSharedUtil;
import com.taboola.android.plus.home.screen.widget.IWidgetManager;
import com.taboola.android.plus.home.screen.widget.TBHomeScreenWidget;
import com.taboola.android.plus.home.screen.widget.WidgetBridgeInternal;
import com.taboola.android.plus.home.screen.widget.WidgetLocalStorage;
import com.taboola.android.plus.home.screen.widget.content.WidgetContentRepository;
import com.taboola.android.plus.home.screen.widget.util.RoundedCornersTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
public class TBAppWidgetFactory
implements RemoteViewsService.RemoteViewsFactory {
    private static final String TAG = TBAppWidgetFactory.class.getSimpleName();
    private static final int VIEW_TYPE_COUNT = 2;
    private static boolean isContentFetchFinished = false;
    private List<TBRecommendationItem> recommendationItems = new ArrayList<TBRecommendationItem>();
    private Context context;

    public TBAppWidgetFactory(Context context) {
        this.context = context;
    }

    public void onCreate() {
        if (ConditionCheckUtil.isNetworkAvailable(this.context)) {
            isContentFetchFinished = false;
            this.fetchContent();
        } else {
            isContentFetchFinished = true;
            Log.i((String)TAG, (String)"onCreate: network connection unavailable, cannot fetch the content");
        }
    }

    private void fetchContent() {
        WidgetBridgeInternal.getWidgetManagerAsync(new IWidgetManager.WidgetManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IWidgetManager manager) {
                manager.fetchContent(new WidgetContentRepository.OnContentFetchCallback(){

                    @Override
                    public void onContentFetched(Map<String, List<TBPlacement>> placements) {
                        if (placements != null && !placements.isEmpty()) {
                            placements.entrySet().iterator().next().getValue();
                            for (Map.Entry<String, List<TBPlacement>> entry : placements.entrySet()) {
                                TBAppWidgetFactory.this.recommendationItems.addAll(entry.getValue().get(0).getItems());
                            }
                            TBHomeScreenWidget.isNoContentState = TBAppWidgetFactory.this.recommendationItems.size() < 1;
                            TBHomeScreenWidget.sendRefreshBroadcast(TBAppWidgetFactory.this.context);
                            isContentFetchFinished = true;
                        }
                    }

                    @Override
                    public void onContentFetchFailed(Throwable t) {
                        isContentFetchFinished = true;
                        Log.e((String)TAG, (String)"onContentFetchFailed: ", (Throwable)t);
                    }
                });
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                isContentFetchFinished = true;
                Log.e((String)TAG, (String)"onManagerRetrieveFailed: ", (Throwable)t);
            }
        });
    }

    public void onDataSetChanged() {
        Log.i((String)TAG, (String)"onDataSetChanged");
        long identityToken = Binder.clearCallingIdentity();
        Binder.restoreCallingIdentity((long)identityToken);
        WidgetBridgeInternal.getWidgetManagerAsync(new IWidgetManager.WidgetManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IWidgetManager manager) {
                WidgetLocalStorage storage = manager.getWidgetLocalStorage();
                long updateInterval = manager.widgetConfig().getWidgetRefreshIntervalMs();
                if (TBAppWidgetFactory.this.didIntervalPass(storage.getLastWidgetRefreshTimestamp(), updateInterval, System.currentTimeMillis())) {
                    TBAppWidgetFactory.this.recommendationItems.clear();
                }
                if (isContentFetchFinished && TBAppWidgetFactory.this.recommendationItems.isEmpty()) {
                    if (ConditionCheckUtil.isNetworkAvailable(TBAppWidgetFactory.this.context)) {
                        TBAppWidgetFactory.this.fetchContent();
                    } else {
                        Log.i((String)TAG, (String)"onCreate: network connection unavailable, cannot fetch the content");
                    }
                }
            }

            @Override
            public void onManagerRetrieveFailed(Throwable t) {
                Log.e((String)TAG, (String)"onManagerRetrieveFailed: cannot handle intent, failed to get widget manager");
            }
        });
    }

    private boolean didIntervalPass(long lastShownTimestamp, long minTriggerInterval, long currentTime) {
        return currentTime - lastShownTimestamp > minTriggerInterval;
    }

    public void onDestroy() {
    }

    public int getCount() {
        return this.recommendationItems.size();
    }

    public RemoteViews getViewAt(int position) {
        if (position == -1 || this.recommendationItems.isEmpty() || this.recommendationItems.size() < position + 1) {
            return null;
        }
        TBRecommendationItem item = this.recommendationItems.get(position);
        HashMap extraDataMap = item.getExtraDataMap();
        RemoteViews rv = position == 0 ? this.getBigItemRemoteView(position, item, extraDataMap) : this.getSmallItemRemoteView(position, item, extraDataMap);
        return rv;
    }

    private RemoteViews getSmallItemRemoteView(int position, TBRecommendationItem item, Map<String, String> extraDataMap) {
        RemoteViews rv = new RemoteViews(this.context.getPackageName(), R.layout.layout_widget_item_small);
        this.setItemMainData(item, extraDataMap, rv, R.id.brandingTv, R.id.timeTv, R.id.titleTv);
        int imageHeight = (int)this.context.getResources().getDimension(R.dimen.tbn_widget_item_image_small_height);
        int imageWidth = (int)this.context.getResources().getDimension(R.dimen.tbn_widget_item_image_small_height);
        RoundedCornersTransformation trans2 = new RoundedCornersTransformation(15, 2);
        String itemThumbnailUrl = PlacementSharedUtil.getItemThumbnailUrlWithSizes(item, imageWidth, imageHeight);
        try {
            Bitmap bitmap = Picasso.get().load(itemThumbnailUrl).transform((Transformation)trans2).get();
            rv.setImageViewBitmap(R.id.widget_itemIv, bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Intent clickIntent = this.getIntent(position, item);
        rv.setOnClickFillInIntent(R.id.widget_item_smallContainer, clickIntent);
        return rv;
    }

    private RemoteViews getBigItemRemoteView(int position, TBRecommendationItem item, Map<String, String> extraDataMap) {
        RemoteViews rv = new RemoteViews(this.context.getPackageName(), R.layout.layout_widget_item_big);
        this.setItemMainData(item, extraDataMap, rv, R.id.brandingTv, R.id.timeTv, R.id.titleTv);
        int imageHeight = (int)this.context.getResources().getDimension(R.dimen.tbn_widget_item_image_big_height);
        RoundedCornersTransformation trans = new RoundedCornersTransformation(20, 7);
        String itemThumbnailUrl = PlacementSharedUtil.getItemThumbnailUrlWithSizes(item, Resources.getSystem().getDisplayMetrics().widthPixels, imageHeight);
        try {
            Bitmap bitmap = Picasso.get().load(itemThumbnailUrl).transform((Transformation)trans).get();
            rv.setImageViewBitmap(R.id.widget_itemIv, bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Intent clickIntent = this.getIntent(position, item);
        rv.setOnClickFillInIntent(R.id.widget_item_bigContainer, clickIntent);
        return rv;
    }

    private void setItemMainData(TBRecommendationItem item, Map<String, String> extraDataMap, RemoteViews rv, int p, int p2, int p3) {
        rv.setTextViewText(p, (CharSequence)extraDataMap.get("branding"));
        rv.setTextViewText(p2, (CharSequence)PlacementSharedUtil.getItemDate(item, extraDataMap.get("name")));
        rv.setTextViewText(p3, (CharSequence)extraDataMap.get("name"));
    }

    private Intent getIntent(int position, TBRecommendationItem item) {
        Intent clickIntent = new Intent();
        clickIntent.putExtra("widget_placement", (Parcelable)item.getPlacement());
        clickIntent.putExtra("widget_clicked_item_position", position);
        return clickIntent;
    }

    public RemoteViews getLoadingView() {
        return null;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean hasStableIds() {
        return true;
    }
}

