/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.google.gson.JsonObject;
import com.taboola.android.plus.common.AbstractAnalyticsManager;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.CoreEventProperties;
import com.taboola.android.plus.core.CoreLocalStorage;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.network.KibanaUtils;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

@RequiresApi(api=21)
public class CoreAnalyticsManager
extends AbstractAnalyticsManager<CoreEventProperties> {
    private static final String TAG = CoreAnalyticsManager.class.getSimpleName();
    private static final String NOTIFICATION_CONFIG_REFRESHED_EVENT = "NotifCfgRefresh";
    private static final String NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT = "FrqntCrshBlkd";
    private static final String UNCAUGHT_EXCEPTION_EVENT = "UncaughtException";
    private static final int REPORT_TIMEOUT = 5;
    protected Handler guehReportingHandler;
    @NonNull
    private final CoreLocalStorage coreLocalStorage;

    CoreAnalyticsManager(@NonNull ISdkPlusCore sdkPlusCore, @NonNull CoreLocalStorage coreLocalStorage) {
        super(sdkPlusCore);
        this.coreLocalStorage = coreLocalStorage;
        Looper guehReportLooper = this.createGuehReportLooper();
        if (guehReportLooper != null) {
            this.guehReportingHandler = new Handler(guehReportLooper);
        }
    }

    private Looper createGuehReportLooper() {
        HandlerThread handlerThread = new HandlerThread("SdkPlusExceptionHandler");
        try {
            handlerThread.start();
            return handlerThread.getLooper();
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("createGuehReportLooper fail [" + e.getMessage() + "]"), (Throwable)e);
            return null;
        }
    }

    void sendNotificationConfigRefreshedEvent() {
        String previousConfig = this.coreLocalStorage.getPreviousConfig();
        String currentConfig = this.coreLocalStorage.getCurrentConfig();
        if (TextUtils.isEmpty((CharSequence)previousConfig) || TextUtils.isEmpty((CharSequence)currentConfig) || !currentConfig.equals(previousConfig)) {
            CoreEventProperties eventProperties = ((CoreEventProperties.Builder)new CoreEventProperties.Builder(NOTIFICATION_CONFIG_REFRESHED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext))).build();
            this.sendEvent(eventProperties, false);
        }
    }

    public void sendBlockedByFrequentCrashesExceeded(int currentExceptionCountForPeriod) {
        CoreEventProperties eventProperties = new CoreEventProperties.Builder(NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT, false).setExceptionCount(currentExceptionCountForPeriod).build();
        this.sendEvent(eventProperties, false);
    }

    @Override
    public JsonObject getJsonObjectForKusto(@NonNull Context appContext, @NonNull CoreEventProperties coreEventProperties, @NonNull SharedLocalStorage sharedLocalStorage) {
        JsonObject event = super.getJsonObjectForKusto(appContext, coreEventProperties, sharedLocalStorage);
        if (coreEventProperties.getExceptionCount() != -1) {
            event.addProperty("exceptionCount", (Number)coreEventProperties.getExceptionCount());
        }
        if (coreEventProperties.getExceptionCountPeriodMs() != -1L) {
            event.addProperty("exceptionCountPeriodMs", (Number)coreEventProperties.getExceptionCountPeriodMs());
        }
        return event;
    }

    @Override
    @NonNull
    protected Map<String, String> getEventMap(@NonNull Context appContext, @NonNull CoreEventProperties coreEventProperties) {
        Map<String, String> map = super.getEventMap(appContext, coreEventProperties);
        if (coreEventProperties.getExceptionCount() != -1) {
            map.put("exceptionCount", String.valueOf(coreEventProperties.getExceptionCount()));
        }
        if (coreEventProperties.getExceptionCountPeriodMs() != -1L) {
            map.put("exceptionCountPeriodMs", String.valueOf(coreEventProperties.getExceptionCountPeriodMs()));
        }
        return map;
    }

    private JSONObject getEventProperties(@NonNull Context appContext, @Nullable String error, Boolean isBlocked, Boolean isDeviceLocked, String exceptionMessage, String exceptionStackTrace, String errorMessage, int exceptionCount, long exceptionCountPeriodMs) {
        JSONObject eventProperties = this.getCommonEventProperties(appContext, error, isBlocked, isDeviceLocked, exceptionMessage, exceptionStackTrace, errorMessage);
        try {
            if (exceptionCount != -1) {
                eventProperties.put("exceptionCount", exceptionCount);
            }
            if (exceptionCountPeriodMs != -1L) {
                eventProperties.put("exceptionCountPeriodMs", exceptionCountPeriodMs);
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getEventProperties: parsing issue [" + e.getMessage() + "]"), (Throwable)e);
        }
        return eventProperties;
    }

    @Override
    public void broadcastEvent(@NonNull CoreEventProperties coreEventProperties) {
        try {
            Intent intent = new Intent();
            intent.setAction("tb.analytics.action.name");
            intent.setPackage(this.appContext.getPackageName());
            intent.putExtra("key_event_name", coreEventProperties.getEventName());
            JSONObject eventsProperties = this.getEventProperties(this.appContext, coreEventProperties.getError(), coreEventProperties.isBlocked(), coreEventProperties.isDeviceLocked(), coreEventProperties.getExceptionMessage(), coreEventProperties.getExceptionStackTrace(), coreEventProperties.getErrorMessage(), coreEventProperties.getExceptionCount(), coreEventProperties.getExceptionCountPeriodMs());
            intent.putExtra("key_event_properties", eventsProperties.toString());
            JSONObject userProperties = this.getUserProperties(this.appContext);
            intent.putExtra("key_user_properties", userProperties.toString());
            this.appContext.sendBroadcast(intent);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("broadcastEvent fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    public void sendUncaughtExceptionEvent(String exceptionMessage, String exceptionStackTrace, int exceptionCount, long exceptionCountPeriodMs, Integer ... reports) {
        CoreEventProperties eventProperties = ((CoreEventProperties.Builder)((CoreEventProperties.Builder)new CoreEventProperties.Builder(UNCAUGHT_EXCEPTION_EVENT, false).setExceptionMessage(exceptionMessage)).setExceptionCount(exceptionCount).setExceptionCountPeriodMs(exceptionCountPeriodMs).setExceptionStackTrace(exceptionStackTrace)).build();
        CountDownLatch countDownLatch = new CountDownLatch(reports.length);
        block6: for (Integer action : reports) {
            switch (action) {
                case 1: {
                    this.sendGUEHExceptionToKibana(this.appContext, eventProperties, countDownLatch);
                    continue block6;
                }
                case 0: {
                    this.sendGUEHExceptionToKusto(eventProperties, countDownLatch);
                    continue block6;
                }
                default: {
                    countDownLatch.countDown();
                }
            }
        }
        try {
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.e((String)TAG, (String)"handleCrashAction thread interrupted while waiting for report.");
        }
    }

    private void sendGUEHExceptionToKusto(final CoreEventProperties eventProperties, final CountDownLatch countDownLatch) {
        try {
            if (this.sharedLocalStorage.isKustoEnabled(true)) {
                Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKusto. Message: " + eventProperties.getExceptionMessage()));
                final HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse response) {
                        Logger.d((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception reported, response: " + response));
                        countDownLatch.countDown();
                    }

                    public void onError(HttpError httpError) {
                        Logger.e((String)"SdkPlusExceptionHandler", (String)("sendCrashEventsToKustoIfNeed Exception not reported, error: " + httpError));
                        countDownLatch.countDown();
                    }
                };
                if (this.guehReportingHandler != null) {
                    this.guehReportingHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            CoreAnalyticsManager.this.sendEventToKusto(CoreAnalyticsManager.this.appContext, eventProperties, networkResponse);
                        }
                    });
                } else {
                    networkResponse.onError(new HttpError("reporting handler not available"));
                }
            } else {
                Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKusto. cache crash for next session, Message: " + eventProperties.getExceptionMessage()));
                JsonObject event = this.getJsonObjectForKusto(this.appContext, eventProperties, this.sharedLocalStorage);
                this.sharedLocalStorage.addCrashEventThatNeedSendToKusto(String.valueOf(event));
                countDownLatch.countDown();
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendGUEHExceptionToKusto fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }

    private void sendGUEHExceptionToKibana(Context appContext, CoreEventProperties eventProperties, final CountDownLatch countDownLatch) {
        try {
            Logger.e((String)"SdkPlusExceptionHandler", (String)("Sending exception to Kibana. Message: " + eventProperties.getExceptionMessage()));
            final HttpManager.NetworkResponse networkResponse = new HttpManager.NetworkResponse(){

                public void onResponse(HttpResponse response) {
                    Logger.d((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception reported, response: " + response));
                    countDownLatch.countDown();
                }

                public void onError(HttpError error) {
                    Logger.e((String)"SdkPlusExceptionHandler", (String)("sendGUEHExceptionToKibana Exception not reported, error: " + error));
                    countDownLatch.countDown();
                }
            };
            if (this.guehReportingHandler != null) {
                JsonObject jsonReportBody = this.getJsonObjectForKusto(appContext, eventProperties, this.sharedLocalStorage);
                jsonReportBody.remove("time");
                String timeStamp = KibanaUtils.getISO8601currentTime();
                jsonReportBody.addProperty("timestamp", timeStamp);
                final JSONObject exceptionReportJsonObject = new JSONObject(jsonReportBody.toString());
                this.guehReportingHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CoreAnalyticsManager.this.sdkPlusNetworkManager.getKibanaHandler().sendGUEHExceptionToKibana(exceptionReportJsonObject, networkResponse);
                    }
                });
            } else {
                networkResponse.onError(new HttpError("reporting handler not available"));
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("sendGUEHExceptionToKibana fail [" + e.getMessage() + "]"), (Throwable)e);
        }
    }
}

