/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.OnClickHelper;
import java.util.List;

@RequiresApi(api=21)
public class UrlOpenUtil {
    private static final String TAG = UrlOpenUtil.class.getSimpleName();

    public static void handleAttributionClick(@NonNull Context appContext) {
        String locale = appContext.getResources().getConfiguration().locale.getCountry();
        String url = "https://popup.taboola.com/" + locale;
        UrlOpenUtil.openUrlInTabsOrBrowser(appContext, url);
    }

    public static boolean openUrlInTabsOrBrowser(@NonNull Context context, @Nullable String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            Log.i((String)TAG, (String)"openUrlInTabsOrBrowser() failed to run - url is empty");
        }
        try {
            if (OnClickHelper.areChromeCustomTabsSupported((Context)context)) {
                Logger.d((String)TAG, (String)"openChromeTab :: opening url in a ChromeTab");
                CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
                UrlOpenUtil.handleNonActivityContext(context, customTabsIntent.intent);
                customTabsIntent.launchUrl(context, Uri.parse((String)url));
                return true;
            }
            if (UrlOpenUtil.areOpenUrlInBrowserSupported(context)) {
                Logger.d((String)TAG, (String)"openNativeBrowser :: opening url");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                UrlOpenUtil.handleNonActivityContext(context, intent);
                context.startActivity(intent);
                return true;
            }
        }
        catch (Exception var3) {
            Logger.e((String)TAG, (String)("openUrlInTabsOrBrowser :: failed to open url " + var3.toString()));
        }
        return false;
    }

    private static void handleNonActivityContext(Context context, Intent intent) {
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10008000);
        }
    }

    public static boolean areOpenUrlInBrowserSupported(@NonNull Context context) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.taboola.com"));
        UrlOpenUtil.handleNonActivityContext(context, intent);
        List infoList = context.getPackageManager().queryIntentServices(intent, 0);
        return infoList != null && !infoList.isEmpty();
    }
}

