/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.common;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.UrlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=21)
public class PlacementSharedUtil {
    private static final String TAG = PlacementSharedUtil.class.getSimpleName();
    public static final String TB_ITEM_KEY_TITLE = "name";
    public static final String TB_ITEM_KEY_THUMBNAIL = "thumbnail";
    public static final String TB_ITEM_KEY_DATE = "created";
    public static final String TB_ITEM_KEY_BRAND = "branding";
    public static final String TB_ITEM_KEY_DESCRIPTION = "description";
    public static final String TB_ITEM_KEY_CLICK_URL = "url";
    public static final String TB_ITEM_KEY_ID = "id";
    public static final String TB_ITEM_KEY_IS_ORGANIC = "is-dc";

    public static String getItemTitle(@NonNull TBRecommendationItem item) {
        return PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_TITLE));
    }

    public static String getItemBrand(@NonNull TBRecommendationItem item) {
        return PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_BRAND));
    }

    public static String getItemDescription(@NonNull TBRecommendationItem item) {
        return PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DESCRIPTION));
    }

    public static String getItemClickUrl(@NonNull TBRecommendationItem item) {
        return PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_CLICK_URL));
    }

    public static String getItemId(@NonNull TBRecommendationItem item) {
        return PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ID));
    }

    public static Boolean isItemOrganic(@NonNull TBRecommendationItem item) {
        return Boolean.valueOf(PlacementSharedUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_IS_ORGANIC)));
    }

    public static String getItemDate(TBRecommendationItem item, String nowLabelText) {
        String createdTime = (String)item.getExtraDataMap().get(TB_ITEM_KEY_DATE);
        return TextUtils.isEmpty((CharSequence)createdTime) ? "" : PlacementSharedUtil.getTimeBetween(createdTime, nowLabelText);
    }

    @Nullable
    public static String getItemThumbnailUrlWithSizes(@NonNull TBRecommendationItem item, int imageWidth, int imageHeight) {
        try {
            String imageUrl = PlacementSharedUtil.getItemThumbnailUrl(item);
            return TextUtils.isEmpty((CharSequence)imageUrl) ? null : UrlUtils.replaceImageSizeInUrl((String)imageUrl, (int)imageHeight, (int)imageWidth);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)"getItemThumbnailUrl: ", (Throwable)e);
            return null;
        }
    }

    protected static String getItemThumbnailUrl(@NonNull TBRecommendationItem item) {
        try {
            String thumbnail = (String)item.getExtraDataMap().get(TB_ITEM_KEY_THUMBNAIL);
            if (TextUtils.isEmpty((CharSequence)thumbnail)) {
                Log.e((String)TAG, (String)"getItemThumbnailUrl: missing thumbnail url");
                return null;
            }
            JSONArray thumbnailJsonArray = new JSONArray(thumbnail);
            if (thumbnailJsonArray.length() > 0) {
                JSONObject thumbnailJsonObj = (JSONObject)thumbnailJsonArray.get(0);
                return thumbnailJsonObj.getString(TB_ITEM_KEY_CLICK_URL);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"getItemThumbnailUrl: ", (Throwable)e);
        }
        return null;
    }

    private static String getTimeBetween(@NonNull String createdTime, String nowLabelText) {
        Date date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        try {
            date = simpleDateFormat.parse(createdTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        if (System.currentTimeMillis() < date.getTime()) {
            return nowLabelText;
        }
        return (String)DateUtils.getRelativeTimeSpanString((long)date.getTime());
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }
}

