/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.layout_model;

import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.layout_model.AbstractNotificationsLayoutModel;

public class SingleNotificationLayoutModel
extends AbstractNotificationsLayoutModel {
    private static final String TAG = SingleNotificationLayoutModel.class.getSimpleName();
    private static final int MIN_ITEMS_COUNT = 1;
    private static final int MAX_ITEMS_COUNT = 1;
    private static final String TRENDING_NOTIFICATION_LAYOUT_MODEL = "trendingNotificationLayoutModel";
    private static final String SPONSORED_NOTIFICATION_LAYOUT_MODEL = "sponsoredNotificationLayoutModel";
    private TrendingNotificationLayoutModel trendingNotificationLayoutModel;
    private SponsoredNotificationLayoutModel sponsoredNotificationLayoutModel;

    public static SingleNotificationLayoutModel determineNotificationLayout(@NonNull ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout config, @IntRange(from=1L) int availableItemsCount) {
        if (availableItemsCount < 1) {
            throw new IllegalArgumentException("Item count must be greater than 0");
        }
        ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout trendingNotificationsLayout = config.getTrendingNotificationsLayout();
        ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout sponsoredNotificationsLayout = config.getSponsoredNotificationsLayout();
        SingleNotificationLayoutModel model = new SingleNotificationLayoutModel();
        TrendingNotificationLayoutModel trendingNotificationLayoutModel = TrendingNotificationLayoutModel.determineTrendingLayout(trendingNotificationsLayout.getLayoutSpecificProperties(), trendingNotificationsLayout.getPreferredCollapsedTrendingLayout(), trendingNotificationsLayout.getPreferredExpandedTrendingLayout());
        SponsoredNotificationLayoutModel sponsoredNotificationLayoutModel = SponsoredNotificationLayoutModel.determineSponsoredLayout(sponsoredNotificationsLayout.getLayoutSpecificProperties(), sponsoredNotificationsLayout.getPreferredCollapsedSponsoredLayout(), sponsoredNotificationsLayout.getPreferredExpandedSponsoredLayout());
        model.setTrendingNotificationLayoutModel(trendingNotificationLayoutModel);
        model.setSponsoredNotificationLayoutModel(sponsoredNotificationLayoutModel);
        return model;
    }

    @Override
    @NonNull
    JsonElement getJsonObject() {
        JsonObject jsonElement = new JsonObject();
        jsonElement.add(TRENDING_NOTIFICATION_LAYOUT_MODEL, this.trendingNotificationLayoutModel.getJsonObject());
        jsonElement.add(SPONSORED_NOTIFICATION_LAYOUT_MODEL, this.sponsoredNotificationLayoutModel.getJsonObject());
        return jsonElement;
    }

    public TrendingNotificationLayoutModel getTrendingNotificationLayoutModel() {
        return this.trendingNotificationLayoutModel;
    }

    private void setTrendingNotificationLayoutModel(TrendingNotificationLayoutModel trendingNotificationLayoutModel) {
        this.trendingNotificationLayoutModel = trendingNotificationLayoutModel;
    }

    public SponsoredNotificationLayoutModel getSponsoredNotificationLayoutModel() {
        return this.sponsoredNotificationLayoutModel;
    }

    private void setSponsoredNotificationLayoutModel(SponsoredNotificationLayoutModel sponsoredNotificationLayoutModel) {
        this.sponsoredNotificationLayoutModel = sponsoredNotificationLayoutModel;
    }

    public static class SponsoredNotificationLayoutModel
    extends AbstractNotificationsLayoutModel {
        public static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_DEFAULT = "layout_sponsored_content_collapsed_default";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_1 = "layout_sponsored_content_collapsed_1";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_2 = "layout_sponsored_content_collapsed_2";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_3 = "layout_sponsored_content_collapsed_3";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_4 = "layout_sponsored_content_collapsed_4";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_5 = "layout_sponsored_content_collapsed_5";
        private static final String LAYOUT_SPONSORED_CONTENT_COLLAPSED_6 = "layout_sponsored_content_collapsed_6";
        public static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_DEFAULT = "layout_sponsored_content_expanded_default";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_1 = "layout_sponsored_content_expanded_1";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_2 = "layout_sponsored_content_expanded_2";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_3 = "layout_sponsored_content_expanded_3";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_4 = "layout_sponsored_content_expanded_4";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_5 = "layout_sponsored_content_expanded_5";
        private static final String LAYOUT_SPONSORED_CONTENT_EXPANDED_6 = "layout_sponsored_content_expanded_6";
        private static final String SPONSORED_COLLAPSED_LAYOUT = "sponsoredCollapsedLayout";
        private static final String SPONSORED_EXPANDED_LAYOUT = "sponsoredExpandedLayout";
        private SponsoredCollapsedLayout sponsoredCollapsedLayout;
        private SponsoredExpandedLayout sponsoredExpandedLayout;
        private ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout.LayoutSpecificProperties sponsoredLayoutSpecificProperties;

        public static SponsoredNotificationLayoutModel determineSponsoredLayout(@NonNull ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout.LayoutSpecificProperties sponsoredLayoutSpecificProperties, @NonNull String collapsedLayout, @NonNull String exandedLayout) {
            SponsoredNotificationLayoutModel sponsoredNotificationLayoutModel = new SponsoredNotificationLayoutModel();
            sponsoredNotificationLayoutModel.setSponsoredLayoutSpecificProperties(sponsoredLayoutSpecificProperties);
            SponsoredCollapsedLayout preferredSponsoredCollapsedLayout = SponsoredCollapsedLayout.parseLayout(collapsedLayout);
            SponsoredExpandedLayout preferredSponsoredExpandedLayout = SponsoredExpandedLayout.parseLayout(exandedLayout);
            sponsoredNotificationLayoutModel.setSponsoredCollapsedLayout(preferredSponsoredCollapsedLayout);
            sponsoredNotificationLayoutModel.setSponsoredExpandedLayout(preferredSponsoredExpandedLayout);
            return sponsoredNotificationLayoutModel;
        }

        @Override
        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.add(SPONSORED_COLLAPSED_LAYOUT, this.sponsoredCollapsedLayout.getJsonObject());
            jsonElement.add(SPONSORED_EXPANDED_LAYOUT, this.sponsoredExpandedLayout.getJsonObject());
            return jsonElement;
        }

        public SponsoredCollapsedLayout getSponsoredCollapsedLayout() {
            return this.sponsoredCollapsedLayout;
        }

        void setSponsoredCollapsedLayout(SponsoredCollapsedLayout sponsoredCollapsedLayout) {
            this.sponsoredCollapsedLayout = sponsoredCollapsedLayout;
        }

        public SponsoredExpandedLayout getSponsoredExpandedLayout() {
            return this.sponsoredExpandedLayout;
        }

        void setSponsoredExpandedLayout(SponsoredExpandedLayout sponsoredExpandedLayout) {
            this.sponsoredExpandedLayout = sponsoredExpandedLayout;
        }

        public ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout.LayoutSpecificProperties getSponsoredLayoutSpecificProperties() {
            return this.sponsoredLayoutSpecificProperties;
        }

        void setSponsoredLayoutSpecificProperties(ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.SponsoredNotificationsLayout.LayoutSpecificProperties sponsoredLayoutSpecificProperties) {
            this.sponsoredLayoutSpecificProperties = sponsoredLayoutSpecificProperties;
        }

        public static enum SponsoredExpandedLayout {
            SponsoredExpandedLayoutDefault("layout_sponsored_content_expanded_default"),
            SponsoredExpandedLayout_1("layout_sponsored_content_expanded_1"),
            SponsoredExpandedLayout_2("layout_sponsored_content_expanded_2"),
            SponsoredExpandedLayout_3("layout_sponsored_content_expanded_3"),
            SponsoredExpandedLayout_4("layout_sponsored_content_expanded_4"),
            SponsoredExpandedLayout_5("layout_sponsored_content_expanded_5"),
            SponsoredExpandedLayout_6("layout_sponsored_content_expanded_6");

            private final String layoutStringKey;
            private final int minNumberOfItems;
            private final int maxNumberOfItems;

            static SponsoredExpandedLayout parseLayout(@NonNull String preferredExpandedLayoutString) {
                switch (preferredExpandedLayoutString) {
                    case "layout_sponsored_content_expanded_default": {
                        return SponsoredExpandedLayoutDefault;
                    }
                    case "layout_sponsored_content_expanded_1": {
                        return SponsoredExpandedLayout_1;
                    }
                    case "layout_sponsored_content_expanded_2": {
                        return SponsoredExpandedLayout_2;
                    }
                    case "layout_sponsored_content_expanded_3": {
                        return SponsoredExpandedLayout_3;
                    }
                    case "layout_sponsored_content_expanded_4": {
                        return SponsoredExpandedLayout_4;
                    }
                    case "layout_sponsored_content_expanded_5": {
                        return SponsoredExpandedLayout_5;
                    }
                    case "layout_sponsored_content_expanded_6": {
                        return SponsoredExpandedLayout_6;
                    }
                }
                Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
                return SponsoredExpandedLayout.getDefault();
            }

            private SponsoredExpandedLayout(String layoutStringKey) {
                this.layoutStringKey = layoutStringKey;
                this.minNumberOfItems = 1;
                this.maxNumberOfItems = 1;
            }

            static SponsoredExpandedLayout getDefault() {
                return SponsoredExpandedLayoutDefault;
            }

            public String getLayoutStringKey() {
                return this.layoutStringKey;
            }

            int getMinNumberOfItems() {
                return this.minNumberOfItems;
            }

            int getMaxNumberOfItems() {
                return this.maxNumberOfItems;
            }

            @NonNull
            public String toString() {
                return this.getLayoutStringKey();
            }

            @NonNull
            JsonElement getJsonObject() {
                JsonObject jsonElement = new JsonObject();
                jsonElement.addProperty("layout", this.layoutStringKey);
                jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
                jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
                return jsonElement;
            }
        }

        public static enum SponsoredCollapsedLayout {
            SponsoredCollapsedLayoutDefault("layout_sponsored_content_collapsed_default"),
            SponsoredCollapsedLayout_1("layout_sponsored_content_collapsed_1"),
            SponsoredCollapsedLayout_2("layout_sponsored_content_collapsed_2"),
            SponsoredCollapsedLayout_3("layout_sponsored_content_collapsed_3"),
            SponsoredCollapsedLayout_4("layout_sponsored_content_collapsed_4"),
            SponsoredCollapsedLayout_5("layout_sponsored_content_collapsed_5"),
            SponsoredCollapsedLayout_6("layout_sponsored_content_collapsed_6");

            private final String layoutStringKey;
            private final int minNumberOfItems;
            private final int maxNumberOfItems;

            static SponsoredCollapsedLayout parseLayout(@NonNull String preferredCollapsedLayoutString) {
                switch (preferredCollapsedLayoutString) {
                    case "layout_sponsored_content_collapsed_default": {
                        return SponsoredCollapsedLayoutDefault;
                    }
                    case "layout_sponsored_content_collapsed_1": {
                        return SponsoredCollapsedLayout_1;
                    }
                    case "layout_sponsored_content_collapsed_2": {
                        return SponsoredCollapsedLayout_2;
                    }
                    case "layout_sponsored_content_collapsed_3": {
                        return SponsoredCollapsedLayout_3;
                    }
                    case "layout_sponsored_content_collapsed_4": {
                        return SponsoredCollapsedLayout_4;
                    }
                    case "layout_sponsored_content_collapsed_5": {
                        return SponsoredCollapsedLayout_5;
                    }
                    case "layout_sponsored_content_collapsed_6": {
                        return SponsoredCollapsedLayout_6;
                    }
                }
                Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
                return SponsoredCollapsedLayout.getDefault();
            }

            private SponsoredCollapsedLayout(String layoutStringKey) {
                this.layoutStringKey = layoutStringKey;
                this.minNumberOfItems = 1;
                this.maxNumberOfItems = 1;
            }

            static SponsoredCollapsedLayout getDefault() {
                return SponsoredCollapsedLayoutDefault;
            }

            public String getLayoutStringKey() {
                return this.layoutStringKey;
            }

            int getMinNumberOfItems() {
                return this.minNumberOfItems;
            }

            int getMaxNumberOfItems() {
                return this.maxNumberOfItems;
            }

            @NonNull
            public String toString() {
                return this.getLayoutStringKey();
            }

            @NonNull
            JsonElement getJsonObject() {
                JsonObject jsonElement = new JsonObject();
                jsonElement.addProperty("layout", this.layoutStringKey);
                jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
                jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
                return jsonElement;
            }
        }
    }

    public static class TrendingNotificationLayoutModel
    extends AbstractNotificationsLayoutModel {
        private static final String LAYOUT_COLLAPSED_SINGLE_DEFAULT_STRING = "layout_collapsed_single_default";
        private static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V1_STRING = "layout_collapsed_single_item_v1";
        private static final String LAYOUT_COLLAPSED_SINGLE_ITEM_V2_STRING = "layout_collapsed_single_item_v2";
        private static final String TEST_LAYOUT_COLLAPSED_INVALID = "test_layout_collapsed_invalid";
        private static final String LAYOUT_EXPANDED_SINGLE_DEFAULT_STRING = "layout_expanded_single_default";
        private TrendingCollapsedLayout trendingCollapsedLayout;
        private TrendingExpandedLayout trendingExpandedLayout;
        private ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout.LayoutSpecificProperties trendingLayoutSpecificProperties;

        public static TrendingNotificationLayoutModel determineTrendingLayout(@NonNull ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout.LayoutSpecificProperties layoutSpecificProperties, @NonNull String collapsedLayout, @NonNull String expandedLayout) {
            TrendingNotificationLayoutModel trendingNotificationLayoutModel = new TrendingNotificationLayoutModel();
            trendingNotificationLayoutModel.setTrendingLayoutSpecificProperties(layoutSpecificProperties);
            TrendingCollapsedLayout preferredTrendingCollapsedLayout = TrendingCollapsedLayout.parseLayout(collapsedLayout);
            TrendingExpandedLayout preferredTrendingExpandedLayout = TrendingExpandedLayout.parseLayout(expandedLayout);
            trendingNotificationLayoutModel.setTrendingCollapsedLayout(preferredTrendingCollapsedLayout);
            trendingNotificationLayoutModel.setTrendingExpandedLayout(preferredTrendingExpandedLayout);
            return trendingNotificationLayoutModel;
        }

        @Override
        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.add("collapsedLayout", this.trendingCollapsedLayout.getJsonObject());
            jsonElement.add("expandedLayout", this.trendingExpandedLayout.getJsonObject());
            Parcelable collapseLayoutSpecificConfig = this.getCollapseLayoutSpecificConfig();
            if (collapseLayoutSpecificConfig != null) {
                jsonElement.add("collapseLayoutSpecificConfig", this.gson.toJsonTree((Object)collapseLayoutSpecificConfig));
            }
            jsonElement.add("expandedLayoutSpecificConfig", this.gson.toJsonTree((Object)this.trendingLayoutSpecificProperties.getLayoutExpandedSingleDefault()));
            return jsonElement;
        }

        @Nullable
        private Parcelable getCollapseLayoutSpecificConfig() {
            Object layoutSpecificConfig = null;
            switch (this.trendingCollapsedLayout) {
                case SingleItemV1: {
                    layoutSpecificConfig = this.trendingLayoutSpecificProperties.getLayoutCollapsedSingleItemV1();
                    break;
                }
                case SingleItemV2: {
                    layoutSpecificConfig = this.trendingLayoutSpecificProperties.getLayoutCollapsedSingleItemV2();
                    break;
                }
                case SingleDefault: {
                    layoutSpecificConfig = this.trendingLayoutSpecificProperties.getLayoutCollapsedSingleDefault();
                }
            }
            return layoutSpecificConfig;
        }

        public TrendingCollapsedLayout getTrendingCollapsedLayout() {
            return this.trendingCollapsedLayout;
        }

        void setTrendingCollapsedLayout(TrendingCollapsedLayout trendingCollapsedLayout) {
            this.trendingCollapsedLayout = trendingCollapsedLayout;
        }

        public TrendingExpandedLayout getTrendingExpandedLayout() {
            return this.trendingExpandedLayout;
        }

        public void setTrendingExpandedLayout(TrendingExpandedLayout trendingExpandedLayout) {
            this.trendingExpandedLayout = trendingExpandedLayout;
        }

        public ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout.LayoutSpecificProperties getTrendingLayoutSpecificProperties() {
            return this.trendingLayoutSpecificProperties;
        }

        void setTrendingLayoutSpecificProperties(ScheduledNotificationsConfig.ScheduledNotificationsLayout.SingleItemNotificationsLayout.TrendingNotificationsLayout.LayoutSpecificProperties trendingLayoutSpecificProperties) {
            this.trendingLayoutSpecificProperties = trendingLayoutSpecificProperties;
        }

        public static enum TrendingExpandedLayout {
            SingleDefault("layout_expanded_single_default");

            private final String layoutStringKey;
            private final int minNumberOfItems;
            private final int maxNumberOfItems;

            private TrendingExpandedLayout(String layoutStringKey) {
                this.layoutStringKey = layoutStringKey;
                this.minNumberOfItems = 1;
                this.maxNumberOfItems = 1;
            }

            static TrendingExpandedLayout parseLayout(String preferredExpandedLayoutString) {
                if (TrendingNotificationLayoutModel.LAYOUT_EXPANDED_SINGLE_DEFAULT_STRING.equals(preferredExpandedLayoutString)) {
                    return SingleDefault;
                }
                Log.e((String)TAG, (String)"parseLayout: unknown Expanded layout key. Using default");
                return TrendingExpandedLayout.getDefaultLayout();
            }

            public String getLayoutStringKey() {
                return this.layoutStringKey;
            }

            int getMinNumberOfItems() {
                return this.minNumberOfItems;
            }

            int getMaxNumberOfItems() {
                return this.maxNumberOfItems;
            }

            static TrendingExpandedLayout getDefaultLayout() {
                return SingleDefault;
            }

            @NonNull
            public String toString() {
                return this.getLayoutStringKey();
            }

            @NonNull
            JsonElement getJsonObject() {
                JsonObject jsonElement = new JsonObject();
                jsonElement.addProperty("layout", this.layoutStringKey);
                jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
                jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
                return jsonElement;
            }
        }

        public static enum TrendingCollapsedLayout {
            SingleDefault("layout_collapsed_single_default"),
            SingleItemV1("layout_collapsed_single_item_v1"),
            SingleItemV2("layout_collapsed_single_item_v2"),
            SingleTestInvalid("test_layout_collapsed_invalid");

            private final String layoutStringKey;
            private final int minNumberOfItems;
            private final int maxNumberOfItems;

            static TrendingCollapsedLayout parseLayout(String preferredCollapsedLayoutString) {
                switch (preferredCollapsedLayoutString) {
                    case "layout_collapsed_single_default": {
                        return SingleDefault;
                    }
                    case "layout_collapsed_single_item_v1": {
                        return SingleItemV1;
                    }
                    case "layout_collapsed_single_item_v2": {
                        return SingleItemV2;
                    }
                    case "test_layout_collapsed_invalid": {
                        return SingleTestInvalid;
                    }
                }
                Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
                return TrendingCollapsedLayout.getDefaultLayout();
            }

            private TrendingCollapsedLayout(String layoutStringKey) {
                this.layoutStringKey = layoutStringKey;
                this.minNumberOfItems = 1;
                this.maxNumberOfItems = 1;
            }

            public String getLayoutStringKey() {
                return this.layoutStringKey;
            }

            int getMinNumberOfItems() {
                return this.minNumberOfItems;
            }

            int getMaxNumberOfItems() {
                return this.maxNumberOfItems;
            }

            static TrendingCollapsedLayout getDefaultLayout() {
                return SingleDefault;
            }

            @NonNull
            public String toString() {
                return this.getLayoutStringKey();
            }

            @NonNull
            JsonElement getJsonObject() {
                JsonObject jsonElement = new JsonObject();
                jsonElement.addProperty("layout", this.layoutStringKey);
                jsonElement.addProperty("minNumberOfItems", (Number)this.minNumberOfItems);
                jsonElement.addProperty("maxNumberOfItems", (Number)this.maxNumberOfItems);
                return jsonElement;
            }
        }
    }
}

