/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.layout_model;

import android.support.annotation.NonNull;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.layout_model.AbstractNotificationsLayoutModel;

public class ScheduledNotificationsLayoutModel
extends AbstractNotificationsLayoutModel {
    private static final String TAG = ScheduledNotificationsLayoutModel.class.getSimpleName();
    private static final String SINGLE_ITEM_NOTIFICATIONS_LAYOUT = "singleItemNotificationsLayout";
    private static final String MULTIPLE_ITEM_NOTIFICATIONS_LAYOUT = "multipleItemNotificationsLayout";
    private ScheduledNotificationLayoutType preferredLayoutType;

    public static ScheduledNotificationsLayoutModel determineNotificationModel(@NonNull ScheduledNotificationsConfig.ScheduledNotificationsLayout config) {
        ScheduledNotificationsLayoutModel model = new ScheduledNotificationsLayoutModel();
        ScheduledNotificationLayoutType layoutType = ScheduledNotificationLayoutType.getLayoutType(config.getPreferredContentNotificationLayout());
        model.setPreferredLayoutType(layoutType);
        return model;
    }

    @Override
    @NonNull
    JsonElement getJsonObject() {
        JsonObject jsonElement = new JsonObject();
        jsonElement.add(ScheduledNotificationLayoutType.class.getSimpleName(), this.preferredLayoutType.getJsonObject());
        return jsonElement;
    }

    public ScheduledNotificationLayoutType getPreferredLayoutType() {
        return this.preferredLayoutType;
    }

    private void setPreferredLayoutType(ScheduledNotificationLayoutType preferredLayoutType) {
        this.preferredLayoutType = preferredLayoutType;
    }

    public static enum ScheduledNotificationLayoutType {
        SingleContentNotificationLayout("singleItemNotificationsLayout"),
        MultipleContentNotificationLayout("multipleItemNotificationsLayout");

        private final String layoutKey;

        static ScheduledNotificationLayoutType getLayoutType(String preferredContentNotificationLayout) {
            switch (preferredContentNotificationLayout) {
                case "singleItemNotificationsLayout": {
                    return SingleContentNotificationLayout;
                }
                case "multipleItemNotificationsLayout": {
                    return MultipleContentNotificationLayout;
                }
            }
            Log.e((String)TAG, (String)"parseLayout: unknown notification content layout key. Using default");
            return ScheduledNotificationLayoutType.getDefaultLayoutType();
        }

        private ScheduledNotificationLayoutType(String layoutKey) {
            this.layoutKey = layoutKey;
        }

        String getLayoutKey() {
            return this.layoutKey;
        }

        static ScheduledNotificationLayoutType getDefaultLayoutType() {
            return SingleContentNotificationLayout;
        }

        @NonNull
        public String toString() {
            return this.getLayoutKey();
        }

        @NonNull
        JsonElement getJsonObject() {
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty("layout", this.layoutKey);
            return jsonElement;
        }
    }
}

