/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.monitor;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.taboola.android.monitor.MonitorParser;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.plus.common.AbstractLocalStorage;
import com.taboola.android.utils.Logger;
import java.util.Map;

class MonitorLocalStorage
extends AbstractLocalStorage {
    private static final String TAG = "MonitorLocalStorage";
    private static final String SHARED_PREFS_FILE_NAME = "monitor_local_storage";
    private static final String SHARED_PREFS_KEY_FEATURES = "tb_features";
    private final Gson gson = new Gson();

    MonitorLocalStorage(@NonNull Context applicationContext) {
        super(applicationContext, SHARED_PREFS_FILE_NAME);
    }

    void setSdkFeatures(Map<Integer, TBSdkFeature> sdkFeatures) {
        if (sdkFeatures == null || sdkFeatures.isEmpty()) {
            this.putString(SHARED_PREFS_KEY_FEATURES, null);
        } else {
            try {
                String toJsonValue = this.gson.toJson(sdkFeatures);
                this.putString(SHARED_PREFS_KEY_FEATURES, toJsonValue);
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("setCurrentConfig: error " + e), (Throwable)e);
            }
        }
    }

    Map<Integer, TBSdkFeature> getSdkFeatures() {
        String jsonStr = this.getString(SHARED_PREFS_KEY_FEATURES);
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        try {
            return MonitorParser.parseSdkFeatures(jsonStr, false);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("getSdkFeatures fail [" + e.getMessage() + "]"), (Throwable)e);
            return null;
        }
    }
}

