/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.util;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedNotificationUtil;
import com.taboola.android.plus.notifications.scheduled.IScheduledNotificationsInternal;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.TBNotificationRefreshJob;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.UrlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(api=21)
public class ScheduledNotificationUtil {
    private static final String TAG = ScheduledNotificationUtil.class.getSimpleName();
    private final TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager;
    private final ScheduledNotificationsLocalStorage notificationsLocalStorage;
    private final Context context;
    private static final String TB_ITEM_KEY_TITLE = "name";
    private static final String TB_ITEM_KEY_THUMBNAIL = "thumbnail";
    private static final String TB_ITEM_KEY_DATE = "created";
    private static final String TB_ITEM_KEY_BRAND = "branding";
    private static final String TB_ITEM_KEY_DESCRIPTION = "description";
    private static final String TB_ITEM_KEY_DISTRIBUTED_CONTENT = "is-dc";
    private static final String TB_ITEM_KEY_ORIGIN = "origin";
    private static final String TB_ITEM_BOOLEAN_VALUE_FALSE = "false";
    private static final String TB_ITEM_ORIGIN_VALUE_SPONSORED = "sponsored";

    public ScheduledNotificationUtil(@NonNull TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager, @NonNull ScheduledNotificationsLocalStorage notificationsLocalStorage, @NonNull Context context) {
        this.scheduledAnalyticsManager = scheduledAnalyticsManager;
        this.notificationsLocalStorage = notificationsLocalStorage;
        this.context = context;
    }

    public static void rescheduleJobIfNeeded(IScheduledNotificationsInternal manager) {
        Log.d((String)TAG, (String)"rescheduleJobIfNeeded() called");
        Context context = manager.getApplicationContext();
        ScheduledNotificationsLocalStorage scheduledLocalStorage = manager.getScheduledLocalStorage();
        if (!scheduledLocalStorage.isNotificationEnabled()) {
            Log.d((String)TAG, (String)"rescheduleJobIfNeeded: Scheduled notifications are disabled");
            return;
        }
        List<String> notificationCategories = scheduledLocalStorage.getNotificationCategories();
        if (notificationCategories.isEmpty()) {
            Log.w((String)TAG, (String)"rescheduleJobIfNeeded: failed to restore notification refresh job: empty categories");
            return;
        }
        if (TBNotificationRefreshJob.isJobRunning(context)) {
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: job is already scheduled, no actions needed");
        } else {
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: periodic refresh job is not scheduled, scheduling");
            manager.getScheduledNotificationController().dismissNotification();
            TBNotificationRefreshJob.scheduleNotificationRefreshJob(manager.getApplicationContext(), notificationCategories, manager.getNotificationConfig().getJobTriggerIntervalMs());
            Log.i((String)TAG, (String)"rescheduleJobIfNeeded: successfully restored notification refresh job");
        }
    }

    @UiThread
    public void reportPlacementVisibility(@NonNull List<TBPlacement> placementsToReportVisibility) {
        if (TaboolaApi.getInstance().isInitialized()) {
            for (TBPlacement tbPlacement : placementsToReportVisibility) {
                int itemIndex = 0;
                TBRecommendationItem tbRecommendationItem = (TBRecommendationItem)tbPlacement.getItems().get(itemIndex);
                tbRecommendationItem.notifyAvailable();
                tbRecommendationItem.notifyVisible();
            }
        } else {
            String info = "ScheduledNotificationStateReceiver: reportVisibility()";
            this.scheduledAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    public int dpToPx(int dp) {
        float density = this.context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    public int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public int getNotificationAppIconId() {
        int cachedNotificationAppIconId = this.notificationsLocalStorage.getNotificationAppIconId();
        if (ResourcesUtil.isResourceValid(this.context, cachedNotificationAppIconId)) {
            return cachedNotificationAppIconId;
        }
        return this.context.getApplicationInfo().icon;
    }

    public void setNotificationAppIconId(int newNotificationAppIconId) {
        if (ResourcesUtil.isResourceValid(this.context, newNotificationAppIconId)) {
            this.notificationsLocalStorage.setNotificationAppIconId(newNotificationAppIconId);
        }
    }

    public String getNotificationAppNameLabel(ScheduledNotificationsConfig.ScheduledNotificationsLayout scheduledNotificationsLayout) {
        String appName = this.notificationsLocalStorage.getNotificationAppNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        appName = scheduledNotificationsLayout.getApplicationNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        return SharedNotificationUtil.getCurrentApplicationName(this.context);
    }

    public void setNotificationAppNameLabel(String newAppNameLabel) {
        this.notificationsLocalStorage.setNotificationAppNameLabel(newAppNameLabel);
    }

    public static List<Integer> generateHotItemIdsList(int contentSize, int hotItemsCount) {
        if (hotItemsCount > contentSize) {
            hotItemsCount = contentSize;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(contentSize);
        for (int i = 0; i < contentSize; ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        return list.subList(0, hotItemsCount);
    }

    public String getItemDate(TBRecommendationItem item, String nowLabelText) {
        String createdTime = (String)item.getExtraDataMap().get(TB_ITEM_KEY_DATE);
        return TextUtils.isEmpty((CharSequence)createdTime) ? "" : this.getTimeBetween(createdTime, nowLabelText);
    }

    public String getItemTitle(@NonNull TBRecommendationItem item) {
        return ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_TITLE));
    }

    @Nullable
    public static String getItemThumbnailUrl(@NonNull TBRecommendationItem item, int imageWidth, int imageHeight) {
        try {
            String imageUrl = ScheduledNotificationUtil.getItemThumbnailUrl(item);
            return TextUtils.isEmpty((CharSequence)imageUrl) ? null : UrlUtils.replaceImageSizeInUrl((String)imageUrl, (int)imageHeight, (int)imageWidth);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)"getItemThumbnailUrl: ", (Throwable)e);
            return null;
        }
    }

    private static String getItemThumbnailUrl(@NonNull TBRecommendationItem item) {
        try {
            String thumbnail = (String)item.getExtraDataMap().get(TB_ITEM_KEY_THUMBNAIL);
            if (TextUtils.isEmpty((CharSequence)thumbnail)) {
                Log.e((String)TAG, (String)"getItemThumbnailUrl: missing thumbnail url");
                return null;
            }
            JSONArray thumbnailJsonArray = new JSONArray(thumbnail);
            if (thumbnailJsonArray.length() > 0) {
                JSONObject thumbnailJsonObj = (JSONObject)thumbnailJsonArray.get(0);
                return thumbnailJsonObj.getString("url");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"getItemThumbnailUrl: ", (Throwable)e);
        }
        return null;
    }

    public String getItemBrand(@NonNull TBRecommendationItem item) {
        return ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_BRAND));
    }

    public String getItemDescription(@NonNull TBRecommendationItem item) {
        return ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DESCRIPTION));
    }

    public static JsonElement createJsonElementFromRecommendationItem(TBRecommendationItem item) {
        HashMap map = item.getExtraDataMap();
        JsonObject jsonElement = new JsonObject();
        jsonElement.addProperty(TB_ITEM_KEY_DESCRIPTION, (String)map.get(TB_ITEM_KEY_DESCRIPTION));
        jsonElement.addProperty(TB_ITEM_KEY_BRAND, (String)map.get(TB_ITEM_KEY_BRAND));
        jsonElement.addProperty(TB_ITEM_KEY_TITLE, (String)map.get(TB_ITEM_KEY_TITLE));
        jsonElement.addProperty(TB_ITEM_KEY_DATE, (String)map.get(TB_ITEM_KEY_DATE));
        jsonElement.addProperty(TB_ITEM_ORIGIN_VALUE_SPONSORED, Boolean.valueOf(ScheduledNotificationUtil.isSponsoredItem(item)));
        jsonElement.addProperty(TB_ITEM_KEY_THUMBNAIL, ScheduledNotificationUtil.getItemThumbnailUrl(item));
        return jsonElement;
    }

    private String getTimeBetween(@NonNull String createdTime, String nowLabelText) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        Date date = null;
        try {
            date = simpleDateFormat.parse(createdTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        if (System.currentTimeMillis() < date.getTime()) {
            return nowLabelText;
        }
        return (String)DateUtils.getRelativeTimeSpanString((long)date.getTime());
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }

    public static boolean isSponsoredItem(@NonNull TBRecommendationItem item) {
        if (item.getExtraDataMap().containsKey(TB_ITEM_KEY_DISTRIBUTED_CONTENT)) {
            return TB_ITEM_BOOLEAN_VALUE_FALSE.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DISTRIBUTED_CONTENT))) && item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && TB_ITEM_ORIGIN_VALUE_SPONSORED.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)));
        }
        return item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && TB_ITEM_ORIGIN_VALUE_SPONSORED.equalsIgnoreCase(ScheduledNotificationUtil.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)));
    }
}

