/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled.content;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.util.PlacementValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
class GetMultipleCategoriesInteractor {
    private static final String TAG = GetMultipleCategoriesInteractor.class.getSimpleName();
    private static final String PAGE_URL_DEF = "http://www.taboola.com";
    private static final String SRC_TYPE = "text";
    private int requestsToComplete;
    private final Object resultLock = new Object();
    private volatile int completedRequests;
    private volatile Map<String, List<TBPlacement>> requestsResult;
    private volatile boolean hasFailed;

    GetMultipleCategoriesInteractor() {
    }

    public void execute(final @NonNull TBScheduledNotificationAnalyticsManager analyticsManager, @NonNull Collection<String> categorizedPlacementNames, @Nullable String readMorePlacementName, @Nullable String userUnifiedId, int numberOfItems, final @NonNull GetNewNotificationContentCallback callback) {
        this.requestsToComplete = categorizedPlacementNames.size();
        this.completedRequests = 0;
        this.requestsResult = new HashMap<String, List<TBPlacement>>();
        this.hasFailed = false;
        HashMap<String, List<Object>> finalPlacementNames = new HashMap<String, List<Object>>();
        if (readMorePlacementName != null) {
            ++numberOfItems;
            ArrayList<String> readMorePlacements = new ArrayList<String>();
            readMorePlacements.add(readMorePlacementName);
            finalPlacementNames.put("read_more", readMorePlacements);
            ++this.requestsToComplete;
        }
        finalPlacementNames.putAll(GetMultipleCategoriesInteractor.getPlacementNamesWithCounter(categorizedPlacementNames, numberOfItems));
        for (Map.Entry categoriesEntry : finalPlacementNames.entrySet()) {
            final String categoryName = (String)categoriesEntry.getKey();
            GetMultipleCategoriesInteractor.getContentFromTrc(analyticsManager, (List)categoriesEntry.getValue(), userUnifiedId, new TBRecommendationRequestCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFetched(TBRecommendationsResponse response) {
                    ArrayList validPlacements = new ArrayList();
                    for (Map.Entry placementEntry : response.getPlacementsMap().entrySet()) {
                        if (placementEntry.getValue() != null) {
                            if (PlacementValidationUtil.isPlacementValid((TBPlacement)placementEntry.getValue(), analyticsManager)) {
                                validPlacements.add(placementEntry.getValue());
                                continue;
                            }
                            Log.w((String)TAG, (String)"onNotificationContentFetched: invalid placement");
                            continue;
                        }
                        Log.w((String)TAG, (String)"onRecommendationsFetched: placement is null");
                    }
                    Object object = GetMultipleCategoriesInteractor.this.resultLock;
                    synchronized (object) {
                        GetMultipleCategoriesInteractor.this.requestsResult.put(categoryName, validPlacements);
                        GetMultipleCategoriesInteractor.this.completedRequests++;
                        if (GetMultipleCategoriesInteractor.this.completedRequests == GetMultipleCategoriesInteractor.this.requestsToComplete && !GetMultipleCategoriesInteractor.this.hasFailed) {
                            callback.onContentFetched(GetMultipleCategoriesInteractor.this.requestsResult);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFailed(Throwable throwable) {
                    Object object = GetMultipleCategoriesInteractor.this.resultLock;
                    synchronized (object) {
                        if (!GetMultipleCategoriesInteractor.this.hasFailed) {
                            GetMultipleCategoriesInteractor.this.hasFailed = true;
                            callback.onContentFailed(throwable);
                        }
                        Log.e((String)TAG, (String)"onContentFailed: ", (Throwable)throwable);
                    }
                }
            });
        }
    }

    @NonNull
    private static Map<String, List<String>> getPlacementNamesWithCounter(Collection<String> categorizedPlacementNames, int numberOfItems) {
        HashMap<String, List<String>> finalPlacementNames = new HashMap<String, List<String>>();
        for (String categorizedName : categorizedPlacementNames) {
            ArrayList<String> categoryPlacements = new ArrayList<String>(numberOfItems);
            for (int i = numberOfItems - 1; i >= 0; --i) {
                categoryPlacements.add(categorizedName + " " + i);
            }
            finalPlacementNames.put(categorizedName, categoryPlacements);
        }
        return finalPlacementNames;
    }

    private static void getContentFromTrc(@NonNull TBScheduledNotificationAnalyticsManager analyticsManager, @NonNull @Size(min=1L) List<String> placementNames, @Nullable String userUnifiedId, @NonNull TBRecommendationRequestCallback callback) {
        TBRecommendationsRequest request = new TBRecommendationsRequest(PAGE_URL_DEF, SRC_TYPE);
        if (!TextUtils.isEmpty((CharSequence)userUnifiedId)) {
            request.setUserUnifiedId(userUnifiedId);
        }
        for (String categorizedPlacementName : placementNames) {
            TBPlacementRequest placementRequest = new TBPlacementRequest(categorizedPlacementName, 1).setAvailable(false);
            request.addPlacementRequest(placementRequest);
        }
        if (TaboolaApi.getInstance().isInitialized()) {
            TaboolaApi.getInstance().fetchRecommendations(request, callback);
        } else {
            Log.e((String)TAG, (String)"getContentFromTrc: TaboolaApi is not initialized");
            callback.onRecommendationsFailed(new Throwable("TaboolaApi is not initialized"));
            String info = "GetNewNotificationContentInteractor: getContentFromTrc: before fetchRecommendations()";
            analyticsManager.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    public static interface GetNewNotificationContentCallback {
        public void onContentFetched(@NonNull Map<String, List<TBPlacement>> var1);

        public void onContentFailed(Throwable var1);
    }
}

