/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.WorkerThread;
import android.support.v4.util.Pair;
import android.util.Log;
import com.google.gson.Gson;
import com.taboola.android.PublisherInfo;
import com.taboola.android.SdkCore;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.global_components.eventsmanager.events.TaboolaMobileEvent;
import com.taboola.android.monitor.MonitorHelper;
import com.taboola.android.plus.common.ISdkPlusCore;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.common.network.SdkPlusNetworkManager;
import com.taboola.android.plus.core.ConfigManager;
import com.taboola.android.plus.core.CoreAnalyticsManager;
import com.taboola.android.plus.core.CoreConfig;
import com.taboola.android.plus.core.CoreConfigValidator;
import com.taboola.android.plus.core.CoreInitCallback;
import com.taboola.android.plus.core.CoreLocalStorage;
import com.taboola.android.plus.core.CoreUtil;
import com.taboola.android.plus.core.ICoreController;
import com.taboola.android.plus.core.IStorageMigrationManager;
import com.taboola.android.plus.core.LanguagesConfig;
import com.taboola.android.plus.core.SdkPlusConfig;
import com.taboola.android.plus.core.SdkPlusExecutors;
import com.taboola.android.plus.core.SdkPlusPublisherInfo;
import com.taboola.android.plus.core.kill_switch.FrequentCrashBlockConfig;
import com.taboola.android.plus.core.kill_switch.SdkPlusExceptionHandler;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.State;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(api=21)
public class SdkPlusCore
extends ISdkPlusCore {
    private static final String TAG = SdkPlusCore.class.getSimpleName();
    private final AtomicBoolean isCoreInitialized = new AtomicBoolean(false);
    private final SdkCore sdkCore;
    private final ICoreController coreController;
    private final SdkPlusNetworkManager sdkPlusNetworkManager;
    private final Context applicationContext;
    private final SdkPlusExecutors sdkPlusExecutors;
    private final SharedLocalStorage sharedLocalStorage;
    private final CoreLocalStorage coreLocalStorage;
    private final CoreAnalyticsManager coreAnalyticsManager;
    private final ConfigManager configManager;
    private final Gson gson;
    private final MonitorHelper monitorHelper;
    private SdkPlusExceptionHandler sdkPlusExceptionHandler;
    private SdkPlusConfig sdkPlusConfig;
    private LanguagesConfig languagesConfig;
    private LocalizationStrings localizationStrings;
    private String localizedPublisherName;

    public SdkPlusCore(@NonNull Context applicationContext, @NonNull SdkCore sdkCore, @NonNull ICoreController coreController, @NonNull SdkPlusNetworkManager sdkPlusNetworkManager, @NonNull MonitorHelper monitorHelper) {
        this.sdkCore = sdkCore;
        this.coreController = coreController;
        this.sdkPlusNetworkManager = sdkPlusNetworkManager;
        this.applicationContext = applicationContext;
        this.monitorHelper = monitorHelper;
        this.sdkPlusExecutors = new SdkPlusExecutors();
        this.sharedLocalStorage = new SharedLocalStorage(applicationContext);
        this.coreLocalStorage = new CoreLocalStorage(applicationContext);
        this.coreAnalyticsManager = new CoreAnalyticsManager(this, this.coreLocalStorage);
        this.configManager = new ConfigManager(applicationContext, this.sharedLocalStorage, sdkPlusNetworkManager, this.getAdvertisingIdInfo(), this.coreLocalStorage);
        this.gson = new Gson();
        this.sdkPlusExecutors.getWorkerThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SdkPlusCore.this.initSdkPlusUncaughtExceptionHandler();
                }
                catch (Exception e) {
                    Logger.e((String)TAG, (String)"error while initSdkPlusUncaughtExceptionHandler", (Throwable)e);
                }
            }
        });
    }

    void init(final @NonNull SdkPlusPublisherInfo sdkPlusPublisherInfo, @NonNull IStorageMigrationManager migrationManager, final @NonNull CoreInitCallback coreInitCallback) {
        if (migrationManager.isMigrationRequired(this.applicationContext)) {
            migrationManager.migrate(this.applicationContext);
        }
        if (this.monitorHelper.shouldInitFromMonitor(this.applicationContext)) {
            Pair<String, String> initParamsFromMonitor = this.monitorHelper.getInitParamsFromMonitor(sdkPlusPublisherInfo);
            sdkPlusPublisherInfo.setPublisherName((String)initParamsFromMonitor.first);
            sdkPlusPublisherInfo.setConfigId((String)initParamsFromMonitor.second);
            if (this.monitorHelper.shouldOverrideConfigUrls()) {
                this.getSdkPlusNetworkManager().getConfigHandler().enableMonitorMode();
            }
        }
        this.sharedLocalStorage.setUserUnifiedId(sdkPlusPublisherInfo.getUserUnifiedId());
        this.sharedLocalStorage.setPublisher(sdkPlusPublisherInfo.getPublisherName());
        this.coreLocalStorage.setConfigId(sdkPlusPublisherInfo.getConfigId());
        android.util.Pair<SdkPlusConfig, LanguagesConfig> newConfigFromCache = this.configManager.getNewConfigFromCache(true);
        if (newConfigFromCache == null || newConfigFromCache.first == null || newConfigFromCache.second == null) {
            this.sdkPlusExecutors.getMainThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SdkPlusCore.this.fetchNewConfigs(sdkPlusPublisherInfo, coreInitCallback);
                }
            });
        } else {
            this.onGetNewConfig((SdkPlusConfig)newConfigFromCache.first, (LanguagesConfig)newConfigFromCache.second, coreInitCallback);
            this.configManager.triggerAsyncConfigsUpdate();
        }
    }

    boolean isCoreInitialized() {
        return this.isCoreInitialized.get();
    }

    private void onGetNewConfig(SdkPlusConfig sdkPlusConfig, LanguagesConfig languagesConfig, CoreInitCallback coreInitCallback) {
        boolean isConfigValid;
        try {
            CoreConfigValidator coreValidator = new CoreConfigValidator();
            String coreConfig = this.gson.toJson((Object)sdkPlusConfig.getCoreConfig());
            isConfigValid = coreValidator.isConfigValid(coreConfig);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("core init failed " + e));
            coreInitCallback.onCoreInitFailed(new Exception("error while parsing/validating config ", e));
            return;
        }
        if (!isConfigValid) {
            coreInitCallback.onCoreInitFailed(new Exception("SDK+ Core config is invalid"));
        } else {
            this.sdkPlusConfig = sdkPlusConfig;
            this.languagesConfig = languagesConfig;
            this.localizedPublisherName = CoreUtil.getLocalizedPublisherName(this.sharedLocalStorage, this.applicationContext, languagesConfig);
            this.sharedLocalStorage.setConfigVariant(sdkPlusConfig.getCoreConfig().getConfigVariant());
            String isoLanguage = Locale.getDefault().getLanguage().toUpperCase();
            String simCountry = TBDeviceInfoUtil.getSimCountry(this.sharedLocalStorage, this.applicationContext);
            this.localizationStrings = CoreUtil.getLocalizationStrings(sdkPlusConfig.getLocalizationStrings(), isoLanguage, simCountry);
            this.coreAnalyticsManager.sendNotificationConfigRefreshedEvent();
            long jobTriggerIntervalMs = sdkPlusConfig.getCoreConfig().getConfigRefreshJobTriggerIntervalMs();
            this.coreController.rescheduleJobIfNeeded(this.applicationContext, jobTriggerIntervalMs);
            this.isCoreInitialized.set(true);
            coreInitCallback.onCoreInitSuccessful(this);
        }
    }

    @Override
    public void rescheduleConfigJobIfNeeded() {
        long jobTriggerIntervalMs = this.sdkPlusConfig.getCoreConfig().getConfigRefreshJobTriggerIntervalMs();
        this.coreController.rescheduleJobIfNeeded(this.applicationContext, jobTriggerIntervalMs);
    }

    private void fetchNewConfigs(@NonNull SdkPlusPublisherInfo sdkPlusPublisherInfo, final @NonNull CoreInitCallback coreInitCallback) {
        this.configManager.getAllConfigsFromRemote(sdkPlusPublisherInfo.getPublisherName(), sdkPlusPublisherInfo.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                SdkPlusCore.this.onGetNewConfig(config, languagesConfig, coreInitCallback);
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("applyNewConfigs: failed to get configs: " + throwable.getMessage()));
                coreInitCallback.onCoreInitFailed(throwable);
            }
        });
    }

    @WorkerThread
    private void initSdkPlusUncaughtExceptionHandler() {
        android.util.Pair<SdkPlusConfig, LanguagesConfig> newConfigFromCache = this.configManager.getNewConfigFromCache(false);
        FrequentCrashBlockConfig frequentCrashBlockConfig = newConfigFromCache != null && newConfigFromCache.first != null ? ((SdkPlusConfig)newConfigFromCache.first).getCoreConfig().getKillSwitch().getFrequentCrashBlockConfig() : new FrequentCrashBlockConfig();
        if (frequentCrashBlockConfig.isFrequentCrashBlockEnabled() && this.sdkPlusExceptionHandler == null) {
            this.sdkPlusExceptionHandler = new SdkPlusExceptionHandler(this.applicationContext, frequentCrashBlockConfig, this.coreAnalyticsManager);
            this.sdkPlusExecutors.getMainThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    SdkPlusCore.this.sdkCore.registerTaboolaExceptionHandler(SdkPlusCore.this.sdkPlusExceptionHandler);
                }
            });
        }
    }

    @Override
    public void reportMobileEvent(TaboolaMobileEvent ... events) {
        try {
            CoreConfig coreConfig = this.sdkPlusConfig.getCoreConfig();
            String taboolaApiKey = coreConfig.getTaboolaApiKey();
            PublisherInfo sdkPublisherInfo = new PublisherInfo(this.localizedPublisherName).setApiKey(taboolaApiKey);
            this.sdkCore.reportMobileEvent(sdkPublisherInfo, events);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("reportMobileEvent | can't report mobile event " + e), (Throwable)e);
        }
    }

    void reportMobileEvent(PublisherInfo publisherInfo, TaboolaMobileEvent ... events) {
        this.sdkCore.reportMobileEvent(publisherInfo, events);
    }

    State getNetworkState() {
        return this.sdkCore.getSdkNetworkManager().getState();
    }

    @Override
    public AdvertisingIdInfo getAdvertisingIdInfo() {
        return this.sdkCore.getAdvertisingIdInfo();
    }

    @Override
    public SdkPlusNetworkManager getSdkPlusNetworkManager() {
        return this.sdkPlusNetworkManager;
    }

    @Override
    public Context getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public SdkPlusExecutors getSdkPlusExecutors() {
        return this.sdkPlusExecutors;
    }

    @Override
    public SharedLocalStorage getSharedLocalStorage() {
        return this.sharedLocalStorage;
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CoreAnalyticsManager getCoreAnalyticsManager() {
        return this.coreAnalyticsManager;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    public SdkPlusConfig getSdkPlusConfig() {
        return this.sdkPlusConfig;
    }

    public LanguagesConfig getLanguagesConfig() {
        return this.languagesConfig;
    }

    public LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    public String getLocalizedPublisherName() {
        return this.localizedPublisherName;
    }

    public MonitorHelper getMonitorHelper() {
        return this.monitorHelper;
    }
}

