/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.text.TextUtils;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.LanguagesConfig;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

@RequiresApi(api=21)
class CoreUtil {
    private static final String LOCALE_KEY_DEFAULT = "default";

    CoreUtil() {
    }

    static String getLocalizedPublisherName(@NonNull SharedLocalStorage sharedLocalStorage, @NonNull Context applicationContext, @NonNull LanguagesConfig languagesConfigJson) {
        String matchedName;
        Map<String, String> publisherMap = languagesConfigJson.getLanguages().getLocalizedPublisherMap();
        String language = Locale.getDefault().getLanguage().toUpperCase();
        String country = TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, applicationContext).toUpperCase();
        if (!TextUtils.isEmpty((CharSequence)country) && !TextUtils.isEmpty((CharSequence)(matchedName = publisherMap.get(language + "_" + country)))) {
            return matchedName;
        }
        matchedName = publisherMap.get(language + "*");
        if (!TextUtils.isEmpty((CharSequence)matchedName)) {
            return matchedName;
        }
        if (!TextUtils.isEmpty((CharSequence)country) && !TextUtils.isEmpty((CharSequence)(matchedName = publisherMap.get("*" + country)))) {
            return matchedName;
        }
        return publisherMap.get(LOCALE_KEY_DEFAULT);
    }

    public static LocalizationStrings getLocalizationStrings(@NonNull @Size(min=0L) ArrayList<LocalizationStrings> strings, @NonNull String isoLanguage, @NonNull String simCountry) {
        String localeKey = isoLanguage + "_" + simCountry;
        LocalizationStrings localizationStrings = CoreUtil.getStringsByLocale(strings, localeKey);
        if (localizationStrings != null) {
            return localizationStrings;
        }
        localeKey = isoLanguage + "*";
        localizationStrings = CoreUtil.getStringsByLocale(strings, localeKey);
        if (localizationStrings != null) {
            return localizationStrings;
        }
        localeKey = "*" + simCountry;
        localizationStrings = CoreUtil.getStringsByLocale(strings, localeKey);
        if (localizationStrings != null) {
            return localizationStrings;
        }
        localizationStrings = CoreUtil.getStringsByLocale(strings, LOCALE_KEY_DEFAULT);
        if (localizationStrings != null) {
            return localizationStrings;
        }
        return new LocalizationStrings();
    }

    private static LocalizationStrings getStringsByLocale(@NonNull @Size(min=0L) ArrayList<LocalizationStrings> strings, @NonNull String isoCode) {
        for (LocalizationStrings item : strings) {
            if (!item.getIsoLanguage().equalsIgnoreCase(isoCode)) continue;
            return item;
        }
        return null;
    }
}

