/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.Size;
import android.support.annotation.UiThread;
import android.util.Log;
import com.google.gson.JsonElement;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.core.CoreAnalyticsManager;
import com.taboola.android.plus.core.CoreConfig;
import com.taboola.android.plus.core.InternalFeatureInitCallback;
import com.taboola.android.plus.core.PlusFeature;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.core.SdkPlusExecutors;
import com.taboola.android.plus.core.TBLScheduledManager;
import com.taboola.android.plus.core.kill_switch.FrequentCrashBlockConfig;
import com.taboola.android.plus.core.kill_switch.KillSwitchUtil;
import com.taboola.android.plus.notifications.scheduled.EngagementGroupsHelper;
import com.taboola.android.plus.notifications.scheduled.IScheduledNotificationsInternal;
import com.taboola.android.plus.notifications.scheduled.NotificationBackgroundJobsManager;
import com.taboola.android.plus.notifications.scheduled.NotificationRefreshCallback;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationController;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfigValidator;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsLocalStorage;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsRenderer;
import com.taboola.android.plus.notifications.scheduled.TBScheduledNotificationAnalyticsManager;
import com.taboola.android.plus.notifications.scheduled.content.NotificationContentRepository;
import com.taboola.android.plus.notifications.scheduled.content.NotificationRemoteRepository;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationRenderingRestrictionsUtil;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(api=21)
public class TBScheduledNotificationsManager
extends IScheduledNotificationsInternal {
    private static final String TAG = TBScheduledNotificationsManager.class.getSimpleName();
    static final String NOTIFICATION_CLICK_INTENT_EXTRA_PLACEMENT = "com.taboola.android.plus.notifications.scheduled.NOTIFICATION_CLICK_EVENT_PLACEMENT";
    static final String NOTIFICATION_CLICK_INTENT_EXTRA_ITEM_INDEX = "com.taboola.android.plus.notifications.scheduled.NOTIFICATION_CLICK_EVENT_ITEM_INDEX";
    public static final String PLACEMENT_CLICK_URL_KEY = "url";
    private Context appContext;
    private SdkPlusCore sdkPlusCore;
    private CoreAnalyticsManager coreAnalyticsManager;
    private SharedLocalStorage sharedLocalStorage;
    private SdkPlusExecutors sdkPlusExecutors;
    private ScheduledNotificationController scheduledNotificationController;
    private NotificationBackgroundJobsManager backgroundManager;
    private ScheduledNotificationUtil scheduledNotificationUtil;
    private ScheduledNotificationsRenderer renderer;
    private TBScheduledNotificationAnalyticsManager scheduledAnalyticsManager;
    private ScheduledNotificationsLocalStorage scheduledLocalStorage;
    private CoreConfig coreConfig;
    private ScheduledNotificationsConfig notificationConfig;
    private LocalizationStrings localizationStrings;
    private ScheduledNotificationRenderingRestrictionsUtil renderRestrictionsUtil;
    private EngagementGroupsHelper engagementGroupsHelper;
    private boolean isScheduledManagerInitialized = false;
    private List<String> notificationCategories = new ArrayList<String>(0);

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void handleClick(@NonNull Bundle extras, @NonNull Context activityContext) {
        try {
            TBRecommendationItem item;
            int itemIndex = extras.getInt(NOTIFICATION_CLICK_INTENT_EXTRA_ITEM_INDEX);
            TBPlacement placement = (TBPlacement)extras.getParcelable(NOTIFICATION_CLICK_INTENT_EXTRA_PLACEMENT);
            boolean isPlacementValid = placement != null && !placement.getItems().isEmpty();
            TBRecommendationItem tBRecommendationItem = item = isPlacementValid ? (TBRecommendationItem)placement.getItems().get(itemIndex) : null;
            if (item != null) {
                this.handleItemClick(item, activityContext);
            } else {
                Logger.e((String)TAG, (String)"error while handle click item is missing");
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"error while handle click ", (Throwable)e);
        }
    }

    @Override
    public void rescheduleJobIfNeeded() {
        ScheduledNotificationUtil.rescheduleJobIfNeeded(this);
    }

    private void handleItemClick(TBRecommendationItem item, Context activityContext) {
        if (TaboolaApi.getInstance().isInitialized()) {
            item.handleClick(activityContext);
        } else {
            String info = "TBNotificationManager: handleClick()";
            this.scheduledAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
        }
    }

    @Override
    public void init(@NonNull SdkPlusCore sdkPlusCore, @Nullable Map<String, String> scheduledNotificationExtraProperties, @NonNull InternalFeatureInitCallback callback) {
        ScheduledNotificationsConfigValidator validator = new ScheduledNotificationsConfigValidator();
        JsonElement scheduledConfig = sdkPlusCore.getSdkPlusConfig().getScheduledNotificationsConfig();
        if (!validator.isConfigValid(scheduledConfig)) {
            callback.onFeatureInitFailed(PlusFeature.SCHEDULED_NOTIFICATIONS, new IllegalStateException("config validation failed"));
        } else {
            this.sdkPlusCore = sdkPlusCore;
            this.appContext = sdkPlusCore.getApplicationContext();
            this.coreAnalyticsManager = sdkPlusCore.getCoreAnalyticsManager();
            this.sharedLocalStorage = sdkPlusCore.getSharedLocalStorage();
            this.sdkPlusExecutors = sdkPlusCore.getSdkPlusExecutors();
            this.coreConfig = sdkPlusCore.getSdkPlusConfig().getCoreConfig();
            this.localizationStrings = sdkPlusCore.getLocalizationStrings();
            this.notificationConfig = validator.parseConfig(scheduledConfig, ScheduledNotificationsConfig.class);
            this.backgroundManager = new NotificationBackgroundJobsManager(this.appContext);
            this.scheduledLocalStorage = new ScheduledNotificationsLocalStorage(this.appContext);
            this.scheduledAnalyticsManager = new TBScheduledNotificationAnalyticsManager(sdkPlusCore, this.scheduledLocalStorage);
            this.engagementGroupsHelper = new EngagementGroupsHelper(this.scheduledAnalyticsManager, this.scheduledLocalStorage, this.notificationConfig.getSmartNotificationFrequency());
            this.scheduledNotificationUtil = new ScheduledNotificationUtil(this.scheduledAnalyticsManager, this.scheduledLocalStorage, this.appContext);
            this.renderRestrictionsUtil = new ScheduledNotificationRenderingRestrictionsUtil(this.appContext, this.sharedLocalStorage, this.scheduledLocalStorage, this.scheduledAnalyticsManager);
            this.renderer = new ScheduledNotificationsRenderer(this.scheduledAnalyticsManager, this.scheduledLocalStorage, this.scheduledNotificationUtil, this.renderRestrictionsUtil, this.appContext, this.localizationStrings);
            NotificationContentRepository contentRepository = new NotificationContentRepository(new NotificationRemoteRepository(this.scheduledAnalyticsManager), this.scheduledAnalyticsManager, this.scheduledLocalStorage, this.sharedLocalStorage, this.sdkPlusExecutors.getMainThreadExecutor(), this.sdkPlusExecutors.getDiskIOExecutor());
            this.scheduledNotificationController = new ScheduledNotificationController(contentRepository, this.renderer, this.scheduledAnalyticsManager, this.backgroundManager, this.scheduledLocalStorage, this.engagementGroupsHelper, this.scheduledNotificationUtil, this.notificationConfig);
            TBScheduledNotificationsManager.verifyScheduledNotificationsLocalStorage(this.scheduledLocalStorage, this.appContext);
            this.scheduledLocalStorage.setScheduledNotificationsExtraProperties(scheduledNotificationExtraProperties);
            this.initTaboolaApi(this.coreConfig.getTaboolaApiKey(), sdkPlusCore.getLocalizedPublisherName(), scheduledNotificationExtraProperties, this.notificationConfig.getNotificationContent().getTaboolaApiExtraProperties());
            this.isScheduledManagerInitialized = true;
            callback.onFeatureInitSuccessful(PlusFeature.SCHEDULED_NOTIFICATIONS);
        }
    }

    @Override
    public TBLScheduledManager setCategories(@NonNull @Size(min=1L) List<String> newCategories) {
        boolean shouldApplyNewCategories;
        Log.d((String)TAG, (String)("setCategories() called with: newCategories = [" + newCategories + "]"));
        List<String> oldCategories = this.scheduledLocalStorage.getNotificationCategories();
        boolean bl = shouldApplyNewCategories = !newCategories.equals(oldCategories);
        if (shouldApplyNewCategories) {
            this.notificationCategories = newCategories;
            this.scheduledLocalStorage.setNotificationCategories(this.notificationCategories);
            if (this.isEnabled() && !this.notificationCategories.isEmpty()) {
                this.initialNotificationRefresh(this.notificationCategories);
            }
        } else {
            this.notificationCategories = oldCategories;
        }
        return this;
    }

    @Override
    public TBLScheduledManager enable() {
        Log.d((String)TAG, (String)"enable() called");
        this.scheduledLocalStorage.setEnabled(true);
        this.scheduledAnalyticsManager.sendEnabledEvent();
        if (this.backgroundManager.isScheduledNotificationsRefreshJobRunning()) {
            Log.d((String)TAG, (String)"enable(): notification refresh job is already running");
        } else if (this.notificationCategories.isEmpty()) {
            Log.d((String)TAG, (String)"enable: notification categories are empty");
        } else {
            this.initialNotificationRefresh(this.notificationCategories);
        }
        return this;
    }

    @Override
    public TBLScheduledManager disable() {
        Log.d((String)TAG, (String)"disable() called");
        this.scheduledLocalStorage.setEnabled(false);
        this.backgroundManager.stopAllBackgroundTasks();
        this.renderer.onNotificationsDisabled();
        this.scheduledNotificationController.dismissNotification();
        this.scheduledAnalyticsManager.sendDisabledEvent();
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.scheduledLocalStorage.isNotificationEnabled();
    }

    @Override
    public void enableInternal() {
        Log.d((String)TAG, (String)"enable() called");
        this.scheduledLocalStorage.setEnabled(true);
        if (this.backgroundManager.isScheduledNotificationsRefreshJobRunning()) {
            Log.d((String)TAG, (String)"enable(): notification refresh job is already running");
        } else if (this.notificationCategories.isEmpty()) {
            Log.d((String)TAG, (String)"enable: notification categories are empty");
        } else {
            this.initialNotificationRefresh(this.notificationCategories);
        }
    }

    @Override
    public void disableInternal() {
        Log.d((String)TAG, (String)"disableInternal() called");
        this.scheduledLocalStorage.setEnabled(false);
        this.backgroundManager.stopAllBackgroundTasks();
        this.renderer.onNotificationsDisabled();
        this.scheduledNotificationController.dismissNotification();
    }

    @UiThread
    private void initTaboolaApi(@NonNull String taboolaApiKey, @NonNull String localizedPublisherName, @Nullable Map<String, String> taboolaPlusExtraProperties, @Nullable Map<String, String> taboolaApiExtraProperties) {
        HashMap<String, String> mergedExtraProperties = new HashMap<String, String>();
        if (taboolaPlusExtraProperties != null) {
            mergedExtraProperties.putAll(taboolaPlusExtraProperties);
        }
        if (taboolaApiExtraProperties != null) {
            mergedExtraProperties.putAll(taboolaApiExtraProperties);
        }
        mergedExtraProperties.put("enableFullRawDataResponse", "true");
        TaboolaApi.getInstance().init(this.appContext, localizedPublisherName, taboolaApiKey, mergedExtraProperties);
    }

    private void initialNotificationRefresh(@NonNull @Size(min=1L) List<String> notificationCategories) {
        boolean isRenderRestricted;
        if (!KillSwitchUtil.isDeviceSupported(this.coreConfig.getKillSwitch())) {
            Log.i((String)TAG, (String)"Notifications are blocked for this device model by remote config");
            this.scheduledAnalyticsManager.sendNotificationBlockedByConfig();
            return;
        }
        boolean isBlockedByFrequentCrashes = KillSwitchUtil.isNotificationBlockedByFrequentCrashes(this.appContext, this.coreConfig.getKillSwitch().getFrequentCrashBlockConfig());
        if (isBlockedByFrequentCrashes) {
            Log.i((String)TAG, (String)"Notifications are blocked by frequent crash kill switch");
            this.coreAnalyticsManager.sendBlockedByFrequentCrashesExceeded(-1);
            return;
        }
        this.engagementGroupsHelper.downgradeUserGroupIfNeeded();
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentEngagementGroup = this.engagementGroupsHelper.getCurrentEngagementGroup();
        if (this.scheduledLocalStorage.shouldSendUserAssignedToNotificationEngagementGroupEvent()) {
            this.scheduledAnalyticsManager.sendUserAssignedToNotificationEngagementGroupEvent(currentEngagementGroup.getGroupName());
            this.scheduledLocalStorage.setShouldSendUserAssignedToNotificationEngagementGroupEvent(false);
        }
        boolean bl = isRenderRestricted = this.renderRestrictionsUtil.isNotificationRenderingRestricted(currentEngagementGroup) || !this.notificationConfig.isScheduledNotificationsFeatureEnabled();
        if (isRenderRestricted) {
            Log.i((String)TAG, (String)"initialNotificationRefresh: notification rendering is restricted. Just scheduling refresh job");
            this.backgroundManager.scheduleNotificationsRefreshJob(this.notificationCategories, this.notificationConfig.getJobTriggerIntervalMs());
        } else {
            this.scheduledNotificationController.refreshNotification(notificationCategories, new NotificationRefreshCallback(){

                @Override
                public void onNotificationRefreshSuccessful() {
                    Log.d((String)TAG, (String)"onNotificationRefreshSuccessful() called");
                    TBScheduledNotificationsManager.this.backgroundManager.scheduleNotificationsRefreshJob(TBScheduledNotificationsManager.this.notificationCategories, TBScheduledNotificationsManager.this.notificationConfig.getJobTriggerIntervalMs());
                }

                @Override
                public void onNotificationRefreshFailed(Throwable t) {
                    Log.i((String)TAG, (String)("onNotificationRefreshFailed() called with: error = [" + t.getMessage() + "]"));
                    TBScheduledNotificationsManager.this.backgroundManager.scheduleNotificationsRefreshJob(TBScheduledNotificationsManager.this.notificationCategories, TBScheduledNotificationsManager.this.notificationConfig.getJobTriggerIntervalMs());
                }
            });
        }
    }

    @Override
    public TBLScheduledManager setIsWifiOnlyMode(@Nullable Boolean isWifiOnlyMode) {
        this.scheduledLocalStorage.setWifiOnlyModeRuntimeFlag(isWifiOnlyMode);
        return this;
    }

    @Override
    public TBLScheduledManager setNotificationAppIcon(int iconId) {
        if (ResourcesUtil.isResourceValid(this.appContext, iconId)) {
            this.scheduledNotificationUtil.setNotificationAppIconId(iconId);
        }
        return this;
    }

    @Override
    public TBLScheduledManager setNotificationAppNameLabel(String applicationName) {
        this.scheduledNotificationUtil.setNotificationAppNameLabel(applicationName);
        return this;
    }

    @Override
    public void onWakePushReceivedInternal() {
        ScheduledNotificationUtil.rescheduleJobIfNeeded(this);
    }

    @Override
    public boolean isInitialized() {
        return this.isScheduledManagerInitialized;
    }

    public SharedLocalStorage getSharedLocalStorage() {
        return this.sharedLocalStorage;
    }

    @Override
    public ScheduledNotificationsLocalStorage getScheduledLocalStorage() {
        return this.scheduledLocalStorage;
    }

    @Override
    public TBScheduledNotificationAnalyticsManager getScheduledAnalyticsManager() {
        return this.scheduledAnalyticsManager;
    }

    @Override
    public ScheduledNotificationController getScheduledNotificationController() {
        return this.scheduledNotificationController;
    }

    @Override
    public Context getApplicationContext() {
        return this.appContext;
    }

    @Override
    public ScheduledNotificationsConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    @Override
    public LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    @Override
    public EngagementGroupsHelper getEngagementGroupsHelper() {
        return this.engagementGroupsHelper;
    }

    public CoreConfig getCoreConfig() {
        return this.coreConfig;
    }

    @Override
    public ScheduledNotificationRenderingRestrictionsUtil getRenderRestrictionsUtil() {
        return this.renderRestrictionsUtil;
    }

    @Override
    public FrequentCrashBlockConfig getFrequentCrashBlockConfig() {
        return this.getCoreConfig().getKillSwitch().getFrequentCrashBlockConfig();
    }

    @Override
    public ScheduledNotificationUtil getScheduledNotificationUtil() {
        return this.scheduledNotificationUtil;
    }

    private static void verifyScheduledNotificationsLocalStorage(@NonNull ScheduledNotificationsLocalStorage scheduledLocalStorage, @NonNull Context appContext) {
        if (!ResourcesUtil.isResourceValid(appContext, scheduledLocalStorage.getNotificationAppIconId())) {
            scheduledLocalStorage.removeNotificationIcon();
        }
    }
}

