/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.scheduled;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.core.kill_switch.FrequentCrashBlockConfig;
import com.taboola.android.plus.core.kill_switch.KillSwitchUtil;
import com.taboola.android.plus.notifications.scheduled.IScheduledNotificationsInternal;
import com.taboola.android.plus.notifications.scheduled.NotificationRefreshCallback;
import com.taboola.android.plus.notifications.scheduled.ScheduledBridgeInternal;
import com.taboola.android.plus.notifications.scheduled.ScheduledNotificationsConfig;
import com.taboola.android.plus.notifications.scheduled.util.ScheduledNotificationRenderingRestrictionsUtil;
import com.taboola.android.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public class TBNotificationRefreshJob
extends JobService {
    private static final String TAG = TBNotificationRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 64879717;
    private static final String BUNDLE_EXTRAS_CATEGORIES = "com.taboola.android.plus.notification.job.extras.categories";
    private static final String BUNDLE_EXTRAS_REFRESH_INTERVAL_MS = "com.taboola.android.plus.notification.job.extras.refreshIntervalMs";
    private static final String CATEGORIES_DELIMITER = ", ";
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900000L;

    public static void scheduleNotificationRefreshJob(@NonNull Context context, @NonNull List<String> categories, long refreshIntervalMs) {
        Logger.d((String)TAG, (String)("scheduleNotificationRefreshJob() called with: categories = [" + categories + "], refreshIntervalMs = [" + refreshIntervalMs + "]"));
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            ComponentName componentName = new ComponentName(context, TBNotificationRefreshJob.class);
            long actualRefreshInterval = Math.max(900000L, refreshIntervalMs);
            JobInfo.Builder builder = new JobInfo.Builder(64879717, componentName);
            builder.setPeriodic(actualRefreshInterval);
            builder.setPersisted(true);
            PersistableBundle extras = new PersistableBundle();
            extras.putString(BUNDLE_EXTRAS_CATEGORIES, TextUtils.join((CharSequence)CATEGORIES_DELIMITER, categories));
            extras.putLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS, refreshIntervalMs);
            builder.setExtras(extras);
            jobScheduler.schedule(builder.build());
        } else {
            Logger.e((String)TAG, (String)"scheduleNotificationRefreshJob error can't get JobScheduler reference");
        }
    }

    public static void cancelNotificationRefreshJob(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        if (jobScheduler != null) {
            jobScheduler.cancel(64879717);
            Logger.v((String)TAG, (String)"Canceling periodic refresh");
        }
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        ScheduledBridgeInternal.getScheduledNotificationManagerAsync(new IScheduledNotificationsInternal.ScheduledManagerInternalCallback(){

            @Override
            public void onManagerRetrieved(IScheduledNotificationsInternal scheduledNotificationsManager) {
                ScheduledNotificationsConfig notificationConfig = scheduledNotificationsManager.getNotificationConfig();
                ScheduledNotificationRenderingRestrictionsUtil renderRestrictionsUtil = scheduledNotificationsManager.getRenderRestrictionsUtil();
                boolean didRefreshIntervalPass = renderRestrictionsUtil.didJobTriggerIntervalPass(notificationConfig.getJobTriggerIntervalMs());
                if (didRefreshIntervalPass) {
                    TBNotificationRefreshJob.this.onManagerRetrieved(scheduledNotificationsManager, params, renderRestrictionsUtil);
                } else {
                    Log.i((String)TAG, (String)"onStartJob: trying to refresh Notification content before refreshNotification interval have passed. Ignoring call.");
                    TBNotificationRefreshJob.this.jobFinished(params, false);
                }
            }

            @Override
            public void onManagerRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)"onStartJob: failed to update notification: onManagerRetrieveFailed: ", (Throwable)throwable);
                TBNotificationRefreshJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    private void onManagerRetrieved(IScheduledNotificationsInternal notificationManager, JobParameters params, ScheduledNotificationRenderingRestrictionsUtil renderRestrictionsUtil) {
        FrequentCrashBlockConfig frequentCrashBlockConfig = notificationManager.getFrequentCrashBlockConfig();
        ScheduledNotificationsConfig scheduledNotificationsConfig = notificationManager.getNotificationConfig();
        ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentEngagementGroup = notificationManager.getEngagementGroupsHelper().getCurrentEngagementGroup();
        if (this.shouldDismissExistingNotification(currentEngagementGroup)) {
            Log.i((String)TAG, (String)"shouldDismissExistingNotification: true, auto-dismissing existing notification (if exists)");
            notificationManager.getScheduledNotificationController().dismissNotification();
        }
        boolean isBlockedByKillSwitch = KillSwitchUtil.isNotificationBlockedByFrequentCrashes(this.getApplicationContext(), frequentCrashBlockConfig);
        boolean isBlockedByFeatureFlag = !scheduledNotificationsConfig.isScheduledNotificationsFeatureEnabled();
        boolean isBlockedByRenderingRestrictions = renderRestrictionsUtil.isNotificationRenderingRestricted(currentEngagementGroup);
        if (isBlockedByKillSwitch || isBlockedByFeatureFlag || isBlockedByRenderingRestrictions) {
            Log.i((String)TAG, (String)("onManagerRetrieved: notification rendering is restricted: isBlockedByKillSwitch = [" + isBlockedByKillSwitch + "] isBlockedByFeatureFlag = [" + isBlockedByFeatureFlag + "] isBlockedByRenderingRestrictions = [" + isBlockedByRenderingRestrictions + "]"));
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        PersistableBundle extras = params.getExtras();
        String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
        if (categoriesStr == null) {
            Log.e((String)TAG, (String)"onManagerRetrieved: notification category list is empty");
            this.onNotificationUpdateFinished(notificationManager, params);
        } else {
            ArrayList<String> categories = new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)));
            this.refreshNotification(notificationManager, categories, params);
        }
    }

    private boolean shouldDismissExistingNotification(ScheduledNotificationsConfig.SmartNotificationFrequency.EngagementGroups currentEngagementGroup) {
        long idleNotificationTimeoutMs = currentEngagementGroup.getNotificationsConfig().getIdleNotificationTimeoutMs();
        if (idleNotificationTimeoutMs == -1L) {
            return false;
        }
        return idleNotificationTimeoutMs == 0L;
    }

    private void refreshNotification(final IScheduledNotificationsInternal notificationManager, List<String> categories, final JobParameters params) {
        notificationManager.getScheduledNotificationController().refreshNotification(categories, new NotificationRefreshCallback(){

            @Override
            public void onNotificationRefreshSuccessful() {
                Log.i((String)TAG, (String)"Notification content refreshed successfully!");
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }

            @Override
            public void onNotificationRefreshFailed(Throwable t) {
                Log.e((String)TAG, (String)("Failed to refresh Notification content with error: " + t.getMessage()));
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }
        });
    }

    private void onNotificationUpdateFinished(IScheduledNotificationsInternal notificationManager, JobParameters params) {
        long newRefreshIntervalMs;
        PersistableBundle extras = params.getExtras();
        long currentRefreshIntervalMs = extras.getLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS);
        if (currentRefreshIntervalMs != (newRefreshIntervalMs = notificationManager.getNotificationConfig().getJobTriggerIntervalMs())) {
            ArrayList<String> categories;
            Log.i((String)TAG, (String)"onNotificationUpdateFinished: notification RefreshInterval has changed. Rescheduling job");
            String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
            categories = !TextUtils.isEmpty((CharSequence)categoriesStr) ? (categories = new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)))) : new ArrayList<String>();
            TBNotificationRefreshJob.scheduleNotificationRefreshJob(notificationManager.getApplicationContext(), categories, newRefreshIntervalMs);
        }
        this.jobFinished(params, false);
    }

    public boolean onStopJob(JobParameters params) {
        Log.w((String)TAG, (String)"Job stopped by OS");
        return false;
    }

    public static boolean isJobRunning(@NonNull Context context) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        boolean hasBeenScheduled = false;
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 64879717) continue;
                hasBeenScheduled = true;
                break;
            }
        }
        return hasBeenScheduled;
    }
}

