/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notifications.push;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.taboola.android.plus.common.ResourcesUtil;
import com.taboola.android.plus.common.SharedNotificationUtil;
import com.taboola.android.plus.common.UrlOpenUtil;
import com.taboola.android.plus.core.BridgeInternalCore;
import com.taboola.android.plus.core.SdkPlusCore;
import com.taboola.android.plus.notifications.push.PushNotificationsConfig;
import com.taboola.android.plus.notifications.push.PushNotificationsLocalStorage;
import com.taboola.android.plus.notifications.push.TBPushNotificationsAnalyticsManager;
import com.taboola.android.plus.notifications.push.models.BreakingNotificationContent;
import com.taboola.android.plus.notifications.push.models.TBPushRawData;
import com.taboola.android.plus.notifications.push.models.WakeUpContent;
import java.util.HashMap;

@RequiresApi(api=21)
class PushNotificationsUtil {
    private static final String TAG = PushNotificationsUtil.class.getSimpleName();
    private static final String ACTION = "action";
    private static final String MESSAGE_ID = "messageId";
    private static final String BRAND_NAME = "brandName";
    private static final String TIMESTAMP = "timestamp";
    private final PushNotificationsLocalStorage pushNotificationsLocalStorage;
    private final Context context;

    public PushNotificationsUtil(@NonNull PushNotificationsLocalStorage pushNotificationsLocalStorage, @NonNull Context context) {
        this.pushNotificationsLocalStorage = pushNotificationsLocalStorage;
        this.context = context;
    }

    static boolean shouldUsePushNotificationsFeature(PushNotificationsConfig config, Context appContext) {
        if (!config.isPushNotificationsFeatureEnabled()) {
            Log.v((String)TAG, (String)"Push notifications are disabled in remote config");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)config.getApiKey(appContext))) {
            Log.v((String)TAG, (String)"Push notifications are enabled in remote config");
            return true;
        }
        Log.e((String)TAG, (String)"Push notifications are enabled in remote config but ApiKey is missing");
        return false;
    }

    public String getNotificationAppNameLabel(@NonNull PushNotificationsConfig.PushNotificationsLayout pushNotificationsLayout) {
        String appName = this.pushNotificationsLocalStorage.getNotificationAppNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        appName = pushNotificationsLayout.getApplicationNameLabel();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        return SharedNotificationUtil.getCurrentApplicationName(this.context);
    }

    public void setNotificationAppNameLabel(String newAppNameLabel) {
        this.pushNotificationsLocalStorage.setNotificationAppNameLabel(newAppNameLabel);
    }

    public int getNotificationAppIconId() {
        int cachedNotificationIconId = this.pushNotificationsLocalStorage.getNotificationAppIconId();
        if (ResourcesUtil.isResourceValid(this.context, cachedNotificationIconId)) {
            return cachedNotificationIconId;
        }
        return this.context.getApplicationInfo().icon;
    }

    public void setNotificationAppIconId(int newNotificationAppIconId) {
        if (ResourcesUtil.isResourceValid(this.context, newNotificationAppIconId)) {
            this.pushNotificationsLocalStorage.setNotificationAppIconId(newNotificationAppIconId);
        }
    }

    static boolean shouldAllowManualRendering(PushNotificationsConfig config) {
        return config != null && config.isManualRenderingEnabled();
    }

    static boolean shouldAllowManualReporting(PushNotificationsConfig config) {
        return config != null && config.isManualReportingEnabled();
    }

    static void onWakePushReceived(SdkPlusCore sdkPlusCore) {
        BridgeInternalCore.onWakePushReceived(sdkPlusCore);
    }

    static BreakingNotificationContent parseNotificationObjectIntoBreaking(OcambaNotificationObject notificationObject, HashMap<String, String> customDataMap, String messageId) {
        String title = notificationObject.getTitle();
        String description = notificationObject.getDescription();
        String image = notificationObject.getImage();
        String url = notificationObject.getUrl();
        String brand = PushNotificationsUtil.getBrandNameFromCustomData(customDataMap);
        return new BreakingNotificationContent(title, description, image, url, brand, messageId);
    }

    static TBPushRawData parseNotificationObjectIntoTBPushRawData(@NonNull OcambaNotificationObject notificationObject, @NonNull HashMap<String, String> customDataMap) {
        return new TBPushRawData(notificationObject.getTitle(), notificationObject.getDescription(), notificationObject.getImage(), notificationObject.getUrl(), customDataMap);
    }

    static WakeUpContent parseNotificationObjectIntoWake(String messageId) {
        return new WakeUpContent(messageId);
    }

    private static String getStringFromMap(@Nullable HashMap<String, String> map, String key) {
        String value = null;
        if (map != null && !map.isEmpty()) {
            value = map.get(key);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    static String getActionFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, ACTION);
    }

    static String getMessageIdFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, MESSAGE_ID);
    }

    static String getBrandNameFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, BRAND_NAME);
    }

    static String getTimestampFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, TIMESTAMP);
    }

    public static void openBreakingUrl(@NonNull TBPushNotificationsAnalyticsManager analyticsManager, @NonNull BreakingNotificationContent content, @NonNull Context context, @Nullable String url) {
        Log.i((String)TAG, (String)"openBreakingUrl: trying to open breaking url and report event ");
        boolean isOpened = UrlOpenUtil.openUrlInTabsOrBrowser(context, url);
        if (isOpened) {
            analyticsManager.sendPushBreakingOpenedSuccessfullyEvent(content);
        }
    }
}

