/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core.kill_switch;

import android.content.Context;
import android.support.annotation.NonNull;
import com.taboola.android.plus.common.TBDeviceInfoUtil;
import com.taboola.android.plus.core.kill_switch.FrequentCrashBlockConfig;
import com.taboola.android.plus.core.kill_switch.KillSwitchConfig;
import com.taboola.android.plus.core.kill_switch.KillSwitchStorage;
import java.util.List;

public class KillSwitchUtil {
    private static final String ID_STRING = "id=";
    private static final String NOTIFICATION_ERROR_MESSAGE_STRING = "Bad notification posted from package";

    public static boolean isNotificationBlockedByFrequentCrashes(@NonNull Context applicationContext, @NonNull FrequentCrashBlockConfig blockConfig) {
        if (!blockConfig.isFrequentCrashBlockEnabled()) {
            return false;
        }
        KillSwitchStorage killSwitchStorage = new KillSwitchStorage(applicationContext);
        long blockTriggeredTimestamp = killSwitchStorage.getLastNotificationBlockTriggeredTimestamp();
        return blockTriggeredTimestamp + blockConfig.getKillSwitchDurationMs() > System.currentTimeMillis();
    }

    public static boolean isDeviceSupported(KillSwitchConfig killSwitchConfig) {
        String deviceModel = TBDeviceInfoUtil.getDeviceName();
        List<String> notSupportedDevices = killSwitchConfig.getBlockedDevices();
        return !notSupportedDevices.contains(deviceModel);
    }

    static boolean isNotificationException(Throwable throwable) {
        return throwable.getMessage().contains(NOTIFICATION_ERROR_MESSAGE_STRING);
    }

    static int getNotificationId(Throwable throwable) {
        String[] words = throwable.getMessage().split("\\s+");
        String exceptionID = "";
        for (String item : words) {
            if (!item.startsWith(ID_STRING)) continue;
            exceptionID = item.substring(3);
        }
        if (!exceptionID.isEmpty()) {
            return Integer.parseInt(exceptionID);
        }
        return -1;
    }
}

