/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SdkPlusExecutors {
    private final Executor mainThreadExecutor = new MainThreadExecutor();
    private final Executor workerThreadExecutor = SdkPlusExecutors.getWorkerExecutor();
    private final Executor networkExecutor = SdkPlusExecutors.getWorkerExecutor();
    private final Executor diskIOExecutor = Executors.newSingleThreadExecutor();

    SdkPlusExecutors() {
    }

    public Executor getMainThreadExecutor() {
        return this.mainThreadExecutor;
    }

    public Executor getWorkerThreadExecutor() {
        return this.workerThreadExecutor;
    }

    public Executor getNetworkExecutor() {
        return this.networkExecutor;
    }

    public Executor getDiskIOExecutor() {
        return this.diskIOExecutor;
    }

    private static Executor getWorkerExecutor() {
        if (Build.VERSION.SDK_INT >= 24) {
            return Executors.newWorkStealingPool();
        }
        return Executors.newCachedThreadPool();
    }

    private static class MainThreadExecutor
    implements Executor {
        private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

