/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.taboola.android.plus.common.AbstractLocalStorage;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.core.SdkPlusConfig;
import com.taboola.android.utils.Logger;

public class CoreLocalStorage
extends AbstractLocalStorage {
    private static final String TAG = CoreLocalStorage.class.getSimpleName();
    public static final String CORE_SHARED_PREFS_FILE_NAME = "core_local_storage";
    public static final String SHARED_PREFS_KEY_PREVIOUS_CONFIG = "tb_previous_config";
    public static final String SHARED_PREFS_KEY_CURRENT_CONFIG = "tb_current_config";
    public static final String SHARED_PREFS_KEY_CONFIG_ID = "tb_config_id";
    public static final String CORE_LOCAL_STORAGE_SCHEMA_VERSION = "core_storage_schema_version";
    private final Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();

    CoreLocalStorage(@NonNull Context applicationContext) {
        super(applicationContext, CORE_SHARED_PREFS_FILE_NAME);
    }

    public void setConfigId(String configId) {
        this.putString(SHARED_PREFS_KEY_CONFIG_ID, configId);
    }

    @Nullable
    public String getConfigId() {
        return this.getString(SHARED_PREFS_KEY_CONFIG_ID);
    }

    public void setCurrentConfig(SdkPlusConfig currentConfig) {
        if (currentConfig == null) {
            this.putString(SHARED_PREFS_KEY_CURRENT_CONFIG, null);
        } else {
            try {
                String toJsonValue = this.gsonWithAdapter.toJson((Object)currentConfig);
                this.putString(SHARED_PREFS_KEY_CURRENT_CONFIG, toJsonValue);
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("setCurrentConfig: error " + e), (Throwable)e);
            }
        }
    }

    @Nullable
    public String getCurrentConfig() {
        return this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getCurrentConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_CURRENT_CONFIG);
        if (TextUtils.isEmpty((CharSequence)configJson)) {
            return null;
        }
        try {
            return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
        }
        catch (JsonSyntaxException e) {
            Logger.e((String)TAG, (String)("getCurrentConfigObj fail [" + e.getMessage() + "]"), (Throwable)e);
            return null;
        }
    }

    public void setPreviousConfig(String previousConfig) {
        this.putString(SHARED_PREFS_KEY_PREVIOUS_CONFIG, previousConfig);
    }

    @Nullable
    public String getPreviousConfig() {
        return this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
    }

    @Nullable
    public SdkPlusConfig getPreviousConfigObj() {
        String configJson = this.getString(SHARED_PREFS_KEY_PREVIOUS_CONFIG);
        if (configJson == null || configJson.isEmpty()) {
            return null;
        }
        try {
            return (SdkPlusConfig)this.gsonWithAdapter.fromJson(configJson, SdkPlusConfig.class);
        }
        catch (JsonSyntaxException e) {
            Logger.e((String)TAG, (String)("getPreviousConfigObj fail [" + e.getMessage() + "]"), (Throwable)e);
            return null;
        }
    }
}

