/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.monitor.ConfigHelper;
import com.taboola.android.plus.common.LocalizationStrings;
import com.taboola.android.plus.common.SharedLocalStorage;
import com.taboola.android.plus.common.network.Callback;
import com.taboola.android.plus.common.network.SdkPlusNetworkManager;
import com.taboola.android.plus.common.network.handlers.IConfigHandler;
import com.taboola.android.plus.core.CoreLocalStorage;
import com.taboola.android.plus.core.LanguagesConfig;
import com.taboola.android.plus.core.SdkPlusConfig;
import com.taboola.android.plus.core.SdkPlusConfigValidator;
import com.taboola.android.utils.Logger;
import java.util.Map;
import java.util.Random;

@RequiresApi(api=21)
public class ConfigManager {
    private static final String TAG = ConfigManager.class.getSimpleName();
    private static final String MINIMAL_SUPPORTED_CONFIG_VERSION = "2.0.0";
    private static final String SHARED_PREFS_KEY = "com.taboola.android.reader.SHARED_PREFERENCES_KEY";
    private static final String CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY = "CURRENT_SDK_CONFIG_JSON_v1_2";
    private static final String NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY = "NEW_SDK_CONFIG_JSON_v1_2";
    private static final String CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY = "CURRENT_LANGUAGES_CONFIG_JSON";
    private static final String NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY = "NEW_LANGUAGES_CONFIG_JSON";
    private final Context applicationContext;
    private final SharedLocalStorage sharedLocalStorage;
    private final CoreLocalStorage coreLocalStorage;
    private final IConfigHandler configHandler;
    private final AdvertisingIdInfo advertisingIdInfo;
    private final Gson gson;
    private final Gson gsonForCacheConfig;

    public ConfigManager(@NonNull Context applicationContext, @NonNull SharedLocalStorage sharedLocalStorage, @NonNull SdkPlusNetworkManager sdkPlusNetworkManager, @NonNull AdvertisingIdInfo advertisingIdInfo, @NonNull CoreLocalStorage coreLocalStorage) {
        this.applicationContext = applicationContext;
        this.sharedLocalStorage = sharedLocalStorage;
        this.coreLocalStorage = coreLocalStorage;
        this.configHandler = sdkPlusNetworkManager.getConfigHandler();
        this.advertisingIdInfo = advertisingIdInfo;
        this.gson = new Gson();
        this.gsonForCacheConfig = this.configHandler.getGson();
    }

    public void getCurrentConfigs(@NonNull String publisherName, @NonNull String configId, @NonNull OnGetAllConfigsCallback callback) {
        SdkPlusConfig sdkPlusConfig = null;
        LanguagesConfig languagesConfig = null;
        boolean isCurrentConfigValid = false;
        try {
            CachedSdkConfigContainer configContainer = this.getCurrentSdkConfig(this.applicationContext);
            sdkPlusConfig = configContainer != null ? configContainer.getSdkPlusConfig() : null;
            CachedLanguagesConfigContainer languagesConfigContainer = this.getCurrentLanguagesConfig(this.applicationContext);
            LanguagesConfig languagesConfig2 = languagesConfig = languagesConfigContainer != null ? languagesConfigContainer.getLanguagesConfig() : null;
            if (sdkPlusConfig != null && languagesConfig != null) {
                isCurrentConfigValid = ConfigManager.isConfigVersionSupported(MINIMAL_SUPPORTED_CONFIG_VERSION, sdkPlusConfig.getCoreConfig().getConfigVersion());
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"getCurrentConfigs error when parse current config");
            isCurrentConfigValid = false;
        }
        if (isCurrentConfigValid) {
            callback.onConfigsFetched(sdkPlusConfig, languagesConfig);
        } else {
            this.getNewCurrentConfigAsync(publisherName, configId, callback);
        }
    }

    private void getNewCurrentConfigAsync(String publisherName, String configId, @NonNull OnGetAllConfigsCallback callback) {
        if (TextUtils.isEmpty((CharSequence)publisherName) || TextUtils.isEmpty((CharSequence)configId)) {
            IllegalStateException throwable = new IllegalStateException("Missing publisher or configId to get config");
            Logger.e((String)TAG, (String)("getCurrentConfigs: failed to get configs: " + throwable.getMessage()));
            callback.onConfigsFailed(throwable);
        } else {
            Log.d((String)TAG, (String)"getCurrentConfigs: config cache is empty or expired or broken, getting new configs");
            this.getAllConfigsFromRemote(publisherName, configId, callback);
        }
    }

    @Nullable
    Pair<SdkPlusConfig, LanguagesConfig> getNewConfigFromCache(boolean shouldApplyNewConfig) {
        CachedSdkConfigContainer configContainer = null;
        CachedLanguagesConfigContainer cachedLangConfig = null;
        SdkPlusConfig sdkPlusConfig = null;
        LanguagesConfig languagesConfig = null;
        boolean isNewConfigValid = false;
        try {
            configContainer = this.getNewSdkConfig(this.applicationContext);
            cachedLangConfig = this.getNewLanguagesConfig(this.applicationContext);
            sdkPlusConfig = configContainer != null ? configContainer.getSdkPlusConfig() : null;
            LanguagesConfig languagesConfig2 = languagesConfig = cachedLangConfig != null ? cachedLangConfig.getLanguagesConfig() : null;
            if (sdkPlusConfig != null && languagesConfig != null) {
                isNewConfigValid = !configContainer.didExpire() && !cachedLangConfig.didExpire() && ConfigManager.isConfigVersionSupported(MINIMAL_SUPPORTED_CONFIG_VERSION, sdkPlusConfig.getCoreConfig().getConfigVersion());
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"getNewConfigs error when parse current config");
            isNewConfigValid = false;
        }
        if (isNewConfigValid) {
            if (shouldApplyNewConfig) {
                this.setCurrentSdkConfig(this.applicationContext, configContainer);
                this.setCurrentLanguagesConfig(this.applicationContext, cachedLangConfig);
            }
            return new Pair((Object)sdkPlusConfig, languagesConfig);
        }
        return null;
    }

    void getAllConfigsFromRemote(@NonNull String publisherName, @NonNull String configId, final @NonNull OnGetAllConfigsCallback callback) {
        new GetAllConfigsFromRemoteInteractor().execute(this.sharedLocalStorage, this.configHandler, this.applicationContext, publisherName, configId, this.advertisingIdInfo, new OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                Log.d((String)TAG, (String)"getCurrentConfigs: successfully fetched configs from remote");
                CachedSdkConfigContainer configContainer = new CachedSdkConfigContainer(System.currentTimeMillis(), config);
                CachedLanguagesConfigContainer languagesConfigContainer = new CachedLanguagesConfigContainer(System.currentTimeMillis(), languagesConfig);
                ConfigManager.this.setCurrentSdkConfig(ConfigManager.this.applicationContext, configContainer);
                ConfigManager.this.setNewSdkConfig(ConfigManager.this.applicationContext, configContainer);
                ConfigManager.this.setCurrentLanguagesConfig(ConfigManager.this.applicationContext, languagesConfigContainer);
                ConfigManager.this.setNewLanguagesConfig(ConfigManager.this.applicationContext, languagesConfigContainer);
                if (ConfigManager.isConfigVersionSupported(ConfigManager.MINIMAL_SUPPORTED_CONFIG_VERSION, configContainer.getSdkPlusConfig().getCoreConfig().getConfigVersion())) {
                    callback.onConfigsFetched(config, languagesConfig);
                } else {
                    Throwable throwable = new Throwable("minimal config version supported by sdk+ is higher than currently available on the server");
                    Log.e((String)TAG, (String)("error while getting configs from remote: " + throwable.getMessage()));
                    callback.onConfigsFailed(throwable);
                }
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("failed to get configs from remote: " + throwable.getMessage()));
                callback.onConfigsFailed(throwable);
            }
        });
    }

    void triggerAsyncConfigsUpdate() {
        this.triggerAsyncConfigsUpdate(null);
    }

    public void triggerAsyncConfigsUpdate(final @Nullable AsyncConfigsUpdateCallback configsUpdateCallback) {
        String publisherName = this.sharedLocalStorage.getPublisher();
        String configId = this.coreLocalStorage.getConfigId();
        if (publisherName == null || configId == null) {
            String msg = "triggerAsyncConfigsUpdate: can't update config: missing credentials";
            Log.e((String)TAG, (String)msg);
            if (configsUpdateCallback != null) {
                configsUpdateCallback.onConfigUpdateFailed(new IllegalStateException(msg));
            }
            return;
        }
        Callback<SdkPlusConfig> getSdkConfigCallback = new Callback<SdkPlusConfig>(){

            @Override
            public void onResponse(SdkPlusConfig response, String message) {
                Log.d((String)TAG, (String)"triggerAsyncConfigUpdate: onResponse successful. ");
                ConfigManager.this.setNewSdkConfig(ConfigManager.this.applicationContext, new CachedSdkConfigContainer(System.currentTimeMillis(), response));
                if (configsUpdateCallback != null) {
                    configsUpdateCallback.onConfigUpdatedSuccessfully();
                }
            }

            @Override
            public void onFailure(Throwable t) {
                Log.e((String)TAG, (String)("triggerAsyncConfigUpdate: onFailure: failed to refresh config. " + t.getMessage()), (Throwable)t);
                if (configsUpdateCallback != null) {
                    configsUpdateCallback.onConfigUpdateFailed(t);
                }
            }
        };
        Callback<LanguagesConfig> getLanguagesConfigCallback = new Callback<LanguagesConfig>(){

            @Override
            public void onResponse(LanguagesConfig response, String message) {
                Log.d((String)TAG, (String)"triggerAsyncLanguagesConfigUpdate: onResponse successful. ");
                ConfigManager.this.setNewLanguagesConfig(ConfigManager.this.applicationContext, new CachedLanguagesConfigContainer(System.currentTimeMillis(), response));
            }

            @Override
            public void onFailure(Throwable t) {
                Log.e((String)TAG, (String)("triggerAsyncLanguagesConfigUpdate: onFailure: failed to refresh config. " + t.getMessage()), (Throwable)t);
            }
        };
        ConfigManager.getConfigWithDeviceId(this.sharedLocalStorage, this.configHandler, this.applicationContext, publisherName, configId, this.advertisingIdInfo, getSdkConfigCallback, getLanguagesConfigCallback);
    }

    public static void clearConfigCache(Context appContext) {
        ConfigManager.resetCurrentSdkConfig(appContext, CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY);
        ConfigManager.resetCurrentSdkConfig(appContext, NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY);
        ConfigManager.resetCurrentSdkConfig(appContext, CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY);
        ConfigManager.resetCurrentSdkConfig(appContext, NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY);
    }

    private static void resetCurrentSdkConfig(Context appContext, String sharedPreferencesKey) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(sharedPreferencesKey, new Gson().toJson(null)).apply();
    }

    private void setCurrentSdkConfig(Context appContext, CachedSdkConfigContainer config) {
        String savedConfig;
        try {
            Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();
            savedConfig = gsonWithAdapter.toJson((Object)config);
        }
        catch (Throwable e) {
            Logger.e((String)TAG, (String)("setCurrentSdkConfig: error " + e), (Throwable)e);
            savedConfig = null;
        }
        if (!TextUtils.isEmpty((CharSequence)savedConfig)) {
            SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
            preferences.edit().putString(CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY, savedConfig).apply();
        }
    }

    private void setNewSdkConfig(Context appContext, CachedSdkConfigContainer config) {
        if (config != null) {
            try {
                this.coreLocalStorage.setPreviousConfig(this.coreLocalStorage.getCurrentConfig());
                this.coreLocalStorage.setCurrentConfig(config.sdkPlusConfig);
                String value = this.gson.toJson((Object)config);
                SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
                preferences.edit().putString(NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY, value).apply();
                this.updateAnalyticsEnabledState();
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("setNewSdkConfig: error " + e), (Throwable)e);
            }
        } else {
            this.coreLocalStorage.setCurrentConfig(null);
        }
    }

    private void updateAnalyticsEnabledState() {
        SdkPlusConfig previousConfig = this.coreLocalStorage.getPreviousConfigObj();
        SdkPlusConfig currentConfig = this.coreLocalStorage.getCurrentConfigObj();
        if (currentConfig == null) {
            this.sharedLocalStorage.setKustoAnalyticsEnabled(false);
            return;
        }
        float currentKustoReportFrequency = currentConfig.getCoreConfig().getKustoReportFrequency();
        if (previousConfig == null || previousConfig.getCoreConfig().getKustoReportFrequency() != currentKustoReportFrequency) {
            this.sharedLocalStorage.setKustoAnalyticsEnabled(ConfigManager.shouldReportToKusto(currentKustoReportFrequency));
        }
    }

    private static boolean shouldReportToKusto(float kustoReportFrequency) {
        return (float)new Random().nextInt(100) <= kustoReportFrequency * 100.0f;
    }

    private void setCurrentLanguagesConfig(@NonNull Context appContext, CachedLanguagesConfigContainer config) {
        String configJson = null;
        if (config != null) {
            try {
                configJson = this.gson.toJson((Object)config);
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("setCurrentLanguagesConfig: error " + e), (Throwable)e);
            }
            SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
            preferences.edit().putString(CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, configJson).apply();
        }
    }

    private void setNewLanguagesConfig(@NonNull Context appContext, CachedLanguagesConfigContainer config) {
        String configJson = null;
        if (config != null) {
            try {
                configJson = this.gson.toJson((Object)config);
            }
            catch (Throwable e) {
                Logger.e((String)TAG, (String)("setCurrentLanguagesConfig: error " + e), (Throwable)e);
            }
            SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
            preferences.edit().putString(NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, configJson).apply();
        }
    }

    @Nullable
    private CachedSdkConfigContainer getCachedSdkConfig(Context appContext, String prefsKey) {
        CachedSdkConfigContainer cachedSdkConfig;
        try {
            SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
            String configJson = preferences.getString(prefsKey, null);
            cachedSdkConfig = (CachedSdkConfigContainer)this.gson.fromJson(configJson, CachedSdkConfigContainer.class);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getCachedSdkConfig fail [" + e.getMessage() + "]"), (Throwable)e);
            cachedSdkConfig = null;
        }
        return cachedSdkConfig;
    }

    @Nullable
    private CachedLanguagesConfigContainer getCachedLanguagesConfig(Context appContext, String prefsKey) {
        CachedLanguagesConfigContainer cachedLanguagesConfig;
        try {
            SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
            String configJson = preferences.getString(prefsKey, null);
            cachedLanguagesConfig = (CachedLanguagesConfigContainer)this.gson.fromJson(configJson, CachedLanguagesConfigContainer.class);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("getCachedLanguagesConfig fail [" + e.getMessage() + "]"), (Throwable)e);
            cachedLanguagesConfig = null;
        }
        return cachedLanguagesConfig;
    }

    @Nullable
    private CachedSdkConfigContainer getCurrentSdkConfig(Context appContext) {
        return this.getCachedSdkConfig(appContext, CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY);
    }

    @Nullable
    private CachedSdkConfigContainer getNewSdkConfig(Context appContext) {
        return this.getCachedSdkConfig(appContext, NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY);
    }

    @Nullable
    private CachedLanguagesConfigContainer getCurrentLanguagesConfig(Context appContext) {
        return this.getCachedLanguagesConfig(appContext, CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY);
    }

    @Nullable
    private CachedLanguagesConfigContainer getNewLanguagesConfig(Context appContext) {
        return this.getCachedLanguagesConfig(appContext, NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY);
    }

    static boolean isConfigVersionSupported(@NonNull String minimalSupportedVersionString, @NonNull String availableVersionString) {
        if (availableVersionString.length() == 0) {
            return false;
        }
        if (availableVersionString.equalsIgnoreCase(minimalSupportedVersionString)) {
            return true;
        }
        int suffixStartIndex = availableVersionString.indexOf("-");
        if (suffixStartIndex == -1) {
            suffixStartIndex = availableVersionString.length();
        }
        String availableVersionWithoutSuffix = availableVersionString.substring(0, suffixStartIndex);
        String[] minimalVersionSplit = minimalSupportedVersionString.split("\\.");
        String[] availableVersionSplit = availableVersionWithoutSuffix.split("\\.");
        if (availableVersionSplit.length != 3) {
            throw new IllegalArgumentException("Invalid available config version");
        }
        for (int i = 0; i < 3; ++i) {
            int minimalVersionInt = Integer.parseInt(minimalVersionSplit[i]);
            int availableVersionInt = Integer.parseInt(availableVersionSplit[i]);
            int comparisonResult = availableVersionInt - minimalVersionInt;
            if (comparisonResult > 0) {
                return true;
            }
            if (comparisonResult >= 0) continue;
            return false;
        }
        throw new IllegalStateException(String.format("Error while validating config version. available: %1$s, minimal supported %2$s", availableVersionString, minimalSupportedVersionString));
    }

    private static void getConfigWithDeviceId(final @NonNull SharedLocalStorage sharedLocalStorage, final @NonNull IConfigHandler configHandler, final Context context, final String publisherName, final String configId, AdvertisingIdInfo advertisingIdInfo, final Callback<SdkPlusConfig> getSdkPlusConfigCallback, final Callback<LanguagesConfig> getLanguagesConfigCallback) {
        ConfigManager.getDeviceId(context, advertisingIdInfo, new GetDeviceIdCallback(){

            @Override
            public void onRetrievedDeviceId(String deviceId) {
                Map<String, String> map = ConfigHelper.getConfigQueryParameters(sharedLocalStorage, context, deviceId);
                this.getConfigFromServer(map);
            }

            @Override
            public void onFailedToGetDeviceId() {
                Map<String, String> map = ConfigHelper.getConfigQueryParameters(sharedLocalStorage, context);
                this.getConfigFromServer(map);
            }

            private void getConfigFromServer(Map<String, String> map) {
                configHandler.getConfig(publisherName, configId, map, getSdkPlusConfigCallback);
                configHandler.getLanguagesConfig(publisherName, map, getLanguagesConfigCallback);
            }
        });
    }

    private static void getDeviceId(Context context, @NonNull AdvertisingIdInfo advertisingIdInfo, final GetDeviceIdCallback callback) {
        String deviceId = advertisingIdInfo.getAdvertisingId();
        if (deviceId != null) {
            if (deviceId.isEmpty()) {
                callback.onFailedToGetDeviceId();
            } else {
                callback.onRetrievedDeviceId(deviceId);
            }
        } else {
            advertisingIdInfo.updateAdvertisingIdAsync(context, new AdvertisingIdInfo.AdvertisingIdCallback(){

                public void onIdRetrieved(String s) {
                    if (s.isEmpty()) {
                        callback.onFailedToGetDeviceId();
                    } else {
                        callback.onRetrievedDeviceId(s);
                    }
                }

                public void onIdUnavailable() {
                    callback.onFailedToGetDeviceId();
                }
            });
        }
    }

    static class GetAllConfigsFromRemoteInteractor {
        OnGetAllConfigsCallback getAllConfigsCallback;
        private final Object dataLock = new Object();
        private final Object failLock = new Object();
        private SdkPlusConfig newConfig;
        private LanguagesConfig newLanguagesConfig;
        boolean hasFailed = false;

        GetAllConfigsFromRemoteInteractor() {
        }

        void execute(@NonNull SharedLocalStorage sharedLocalStorage, @NonNull IConfigHandler configHandler, Context context, String publisherName, String configId, @NonNull AdvertisingIdInfo advertisingIdInfo, OnGetAllConfigsCallback callback) {
            this.getAllConfigsCallback = callback;
            Callback<SdkPlusConfig> getSdkPlusConfigCallback = new Callback<SdkPlusConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(SdkPlusConfig response, String message) {
                    Object object = GetAllConfigsFromRemoteInteractor.this.dataLock;
                    synchronized (object) {
                        GetAllConfigsFromRemoteInteractor.this.newConfig = response;
                        if (GetAllConfigsFromRemoteInteractor.this.newConfig != null && GetAllConfigsFromRemoteInteractor.this.newConfig.getCoreConfig() != null) {
                            SdkPlusConfigValidator validator = new SdkPlusConfigValidator();
                            Gson gson = new Gson();
                            boolean isConfigValid = validator.isConfigValid(gson.toJson((Object)GetAllConfigsFromRemoteInteractor.this.newConfig));
                            if (!isConfigValid) {
                                GetAllConfigsFromRemoteInteractor.this.onFail(new Throwable("Sdk plus config is invalid"));
                            } else {
                                GetAllConfigsFromRemoteInteractor.this.onSuccess();
                            }
                        } else {
                            GetAllConfigsFromRemoteInteractor.this.onFail(new Throwable("Failed to parse config"));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    GetAllConfigsFromRemoteInteractor.this.onFail(t);
                }
            };
            Callback<LanguagesConfig> getLanguagesConfigCallback = new Callback<LanguagesConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(LanguagesConfig response, String message) {
                    Object object = GetAllConfigsFromRemoteInteractor.this.dataLock;
                    synchronized (object) {
                        GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig = response;
                        if (GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig != null && GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig.getLanguages() != null) {
                            GetAllConfigsFromRemoteInteractor.this.onSuccess();
                        } else {
                            GetAllConfigsFromRemoteInteractor.this.onFail(new Throwable("Failed to parse languages config"));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    GetAllConfigsFromRemoteInteractor.this.onFail(t);
                }
            };
            ConfigManager.getConfigWithDeviceId(sharedLocalStorage, configHandler, context, publisherName, configId, advertisingIdInfo, getSdkPlusConfigCallback, getLanguagesConfigCallback);
        }

        private void onSuccess() {
            if (!this.hasFailed && this.newConfig != null && this.newLanguagesConfig != null) {
                this.getAllConfigsCallback.onConfigsFetched(this.newConfig, this.newLanguagesConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFail(Throwable throwable) {
            Object object = this.failLock;
            synchronized (object) {
                if (this.hasFailed) {
                    return;
                }
                this.hasFailed = true;
            }
            this.getAllConfigsCallback.onConfigsFailed(throwable);
        }
    }

    static interface GetDeviceIdCallback {
        public void onRetrievedDeviceId(String var1);

        public void onFailedToGetDeviceId();
    }

    public static interface OnGetAllConfigsCallback {
        public void onConfigsFetched(SdkPlusConfig var1, LanguagesConfig var2);

        public void onConfigsFailed(Throwable var1);
    }

    private static class CachedLanguagesConfigContainer
    implements Parcelable {
        static final String CACHING_TIMESTAMP = "cachingTimestamp";
        static final String LANG_CONFIG = "languagesConfig";
        @SerializedName(value="cachingTimestamp")
        private final long cachingTimestamp;
        @SerializedName(value="languagesConfig")
        private final LanguagesConfig languagesConfig;
        public static final Parcelable.Creator<CachedLanguagesConfigContainer> CREATOR = new Parcelable.Creator<CachedLanguagesConfigContainer>(){

            public CachedLanguagesConfigContainer createFromParcel(Parcel source) {
                return new CachedLanguagesConfigContainer(source);
            }

            public CachedLanguagesConfigContainer[] newArray(int size) {
                return new CachedLanguagesConfigContainer[size];
            }
        };

        CachedLanguagesConfigContainer(long cachingTimestamp, LanguagesConfig languagesConfig) {
            this.cachingTimestamp = cachingTimestamp;
            this.languagesConfig = languagesConfig;
        }

        CachedLanguagesConfigContainer(Parcel in) {
            this.cachingTimestamp = in.readLong();
            this.languagesConfig = (LanguagesConfig)in.readParcelable(LanguagesConfig.class.getClassLoader());
        }

        boolean didExpire() {
            if (this.languagesConfig == null) {
                return true;
            }
            long timeSinceCacheCreated = System.currentTimeMillis() - this.cachingTimestamp;
            return timeSinceCacheCreated > this.languagesConfig.getConfigCacheExpirationTimeMs();
        }

        LanguagesConfig getLanguagesConfig() {
            return this.languagesConfig;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.cachingTimestamp);
            dest.writeParcelable((Parcelable)this.languagesConfig, flags);
        }
    }

    public static class CachedSdkConfigContainer
    implements Parcelable {
        static final String SDK_PLUS_CONFIG = "SdkPlusConfig";
        private final long cachingTimestamp;
        @SerializedName(value="SdkPlusConfig")
        private SdkPlusConfig sdkPlusConfig;
        public static final Parcelable.Creator<CachedSdkConfigContainer> CREATOR = new Parcelable.Creator<CachedSdkConfigContainer>(){

            public CachedSdkConfigContainer createFromParcel(Parcel in) {
                return new CachedSdkConfigContainer(in);
            }

            public CachedSdkConfigContainer[] newArray(int size) {
                return new CachedSdkConfigContainer[size];
            }
        };

        CachedSdkConfigContainer(Parcel in) {
            this.cachingTimestamp = in.readLong();
        }

        CachedSdkConfigContainer(long cachingTimestamp, SdkPlusConfig sdkPlusConfig) {
            this.cachingTimestamp = cachingTimestamp;
            this.sdkPlusConfig = sdkPlusConfig;
        }

        private boolean didExpire() {
            if (this.sdkPlusConfig == null) {
                return true;
            }
            long timeSinceCacheCreated = System.currentTimeMillis() - this.cachingTimestamp;
            return timeSinceCacheCreated > this.sdkPlusConfig.getCoreConfig().getConfigCacheExpirationTimeMs();
        }

        public long getCachingTimestamp() {
            return this.cachingTimestamp;
        }

        SdkPlusConfig getSdkPlusConfig() {
            return this.sdkPlusConfig;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.cachingTimestamp);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static interface AsyncConfigsUpdateCallback {
        public void onConfigUpdatedSuccessfully();

        public void onConfigUpdateFailed(Throwable var1);
    }
}

