/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared.network.handlers;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.network.Callback;
import com.taboola.android.plus.shared.network.ConfigApiService;
import com.taboola.android.plus.shared.network.handlers.BaseHandler;
import com.taboola.android.plus.shared.network.handlers.ConfigApiServiceImp;
import com.taboola.android.plus.shared.network.handlers.ConfigApiServiceMonitorImp;
import com.taboola.android.utils.Logger;
import com.taboola.lightnetwork.dynamic_url.DynamicRequest;
import com.taboola.lightnetwork.protocols.http.HttpError;
import com.taboola.lightnetwork.protocols.http.HttpManager;
import com.taboola.lightnetwork.protocols.http.HttpResponse;
import java.util.Map;

public class ConfigHandler
extends BaseHandler {
    private static final String TAG = "ConfigHandler";
    private ConfigApiService mConfigApiService;
    private Gson mGson;
    private HttpManager mHttpManager;

    public ConfigHandler() {
        super(TAG);
    }

    public void setHttpManager(HttpManager httpManager) {
        this.mHttpManager = httpManager;
        this.mConfigApiService = new ConfigApiServiceImp(httpManager);
        this.mGson = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();
    }

    public void getConfig(@NonNull String pubId, @NonNull String configId, @NonNull Map<String, String> query, final @Nullable Callback<SdkPlusConfig> callback) {
        block3: {
            try {
                DynamicRequest request = this.mConfigApiService.getConfigRequest(pubId, configId, query);
                this.sendUrlToMonitor(request.getFinalUrl());
                if (TextUtils.equals((CharSequence)"release", (CharSequence)"debug")) {
                    Logger.d((String)TAG, (String)("getConfig " + request.getFinalUrl()));
                }
                request.execute(new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse httpResponse) {
                        block4: {
                            try {
                                SdkPlusConfig config = (SdkPlusConfig)ConfigHandler.this.mGson.fromJson(httpResponse.mMessage, SdkPlusConfig.class);
                                if (config == null) {
                                    throw new Exception("Config is null");
                                }
                                Logger.d((String)ConfigHandler.TAG, (String)("getConfig success " + httpResponse.mMessage));
                                if (callback != null) {
                                    callback.onResponse(config, httpResponse.toString());
                                }
                            }
                            catch (Exception e) {
                                Logger.e((String)ConfigHandler.TAG, (String)("getConfig: error " + e.getLocalizedMessage()), (Throwable)e);
                                if (callback == null) break block4;
                                callback.onFailure(new Throwable(e.getLocalizedMessage()));
                            }
                        }
                    }

                    public void onError(HttpError httpError) {
                        Log.e((String)ConfigHandler.TAG, (String)("getConfig: error " + httpError));
                        if (callback != null) {
                            callback.onFailure(new Throwable(httpError.toString()));
                        }
                    }
                });
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getConfig: error " + e.getLocalizedMessage()), (Throwable)e);
                if (callback == null) break block3;
                callback.onFailure(new Throwable(e.getLocalizedMessage()));
            }
        }
    }

    public void getLanguagesConfig(@NonNull String pubId, @NonNull Map<String, String> queryMap, final @Nullable Callback<LanguagesConfig> callback) {
        block3: {
            try {
                DynamicRequest request = this.mConfigApiService.getLanguagesConfigRequest(pubId, queryMap);
                this.sendUrlToMonitor(request.getFinalUrl());
                if (TextUtils.equals((CharSequence)"release", (CharSequence)"debug")) {
                    Logger.d((String)TAG, (String)("getLanguagesConfig " + request.getFinalUrl()));
                }
                request.execute(new HttpManager.NetworkResponse(){

                    public void onResponse(HttpResponse httpResponse) {
                        block4: {
                            try {
                                LanguagesConfig languagesConfig = (LanguagesConfig)ConfigHandler.this.mGson.fromJson(httpResponse.mMessage, LanguagesConfig.class);
                                if (languagesConfig == null) {
                                    throw new Exception("LanguagesConfig is null");
                                }
                                Logger.d((String)ConfigHandler.TAG, (String)("getLanguagesConfig success " + httpResponse.mMessage));
                                if (callback != null) {
                                    callback.onResponse(languagesConfig, httpResponse.toString());
                                }
                            }
                            catch (Exception e) {
                                Log.e((String)ConfigHandler.TAG, (String)("getLanguagesConfig: error " + e.getLocalizedMessage()));
                                if (callback == null) break block4;
                                callback.onFailure(new Throwable(e.getLocalizedMessage()));
                            }
                        }
                    }

                    public void onError(HttpError httpError) {
                        Log.e((String)ConfigHandler.TAG, (String)("getLanguagesConfig: error " + httpError));
                        if (callback != null) {
                            callback.onFailure(new Throwable(httpError.toString()));
                        }
                    }
                });
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getLanguagesConfig: error " + e.getLocalizedMessage()), (Throwable)e);
                if (callback == null) break block3;
                callback.onFailure(new Throwable(e.getLocalizedMessage()));
            }
        }
    }

    public void enableMonitorMode() {
        this.mConfigApiService = new ConfigApiServiceMonitorImp(this.mHttpManager, this.mConfigApiService.getApiService());
    }
}

