/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.push_notifications.models.TBPushRawData;

@RequiresApi(api=21)
public class TBPushManualBiReporting {
    private static final String TAG = TBPushManualBiReporting.class.getSimpleName();

    public static void sendPushBreakingRenderEvent(final @NonNull TBPushRawData tbPushRawData) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (TBPushManualBiReporting.isManualReportingAllowed(taboolaPlus.getPushNotificationsManager())) {
                    taboolaPlus.getPushNotificationsManager().getAnalyticsManager().sendPushBreakingRenderEvent(tbPushRawData);
                } else {
                    Log.d((String)TAG, (String)"Manual reporting is not allowed");
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("sendPushBreakingRenderEvent: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    public static void sendPushBreakingDismissedEvent(final @NonNull TBPushRawData tbPushRawData) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (TBPushManualBiReporting.isManualReportingAllowed(taboolaPlus.getPushNotificationsManager())) {
                    taboolaPlus.getPushNotificationsManager().getAnalyticsManager().sendPushBreakingDismissedEvent(tbPushRawData);
                } else {
                    Log.d((String)TAG, (String)"Manual reporting is not allowed");
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("sendPushBreakingDismissedEvent: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    public static void sendTapPushBreakingEvent(final @NonNull TBPushRawData tbPushRawData) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (TBPushManualBiReporting.isManualReportingAllowed(taboolaPlus.getPushNotificationsManager())) {
                    taboolaPlus.getPushNotificationsManager().getAnalyticsManager().sendTapPushBreakingEvent(tbPushRawData);
                } else {
                    Log.d((String)TAG, (String)"Manual reporting is not allowed");
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("sendTapPushBreakingEvent: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    public static void sendPushBreakingOpenedSuccessfullyEvent(final @NonNull TBPushRawData tbPushRawData) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (TBPushManualBiReporting.isManualReportingAllowed(taboolaPlus.getPushNotificationsManager())) {
                    taboolaPlus.getPushNotificationsManager().getAnalyticsManager().sendPushBreakingOpenedSuccessfullyEvent(tbPushRawData);
                } else {
                    Log.d((String)TAG, (String)"Manual reporting is not allowed");
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("sendPushBreakingOpenedSuccessfullyEvent: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    public static void sendPushBreakingFailedToRenderEvent(final @NonNull TBPushRawData tbPushRawData, final @NonNull String errorMessage) {
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                if (TBPushManualBiReporting.isManualReportingAllowed(taboolaPlus.getPushNotificationsManager())) {
                    taboolaPlus.getPushNotificationsManager().getAnalyticsManager().sendPushBreakingFailedToRenderEvent(tbPushRawData, errorMessage);
                } else {
                    Log.d((String)TAG, (String)"Manual reporting is not allowed");
                }
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("sendPushBreakingFailedToRenderEvent: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
            }
        });
    }

    public static boolean isManualReportingAllowed(TBPushNotificationsManager tbPushNotificationsManager) {
        PushNotificationsConfig config = tbPushNotificationsManager.getPushNotificationsConfig();
        return PushNotificationsUtil.shouldAllowManualReporting(config);
    }
}

