/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.WakeUpContent;
import java.util.HashMap;
import org.json.JSONObject;

class PushValidationUtil {
    private static final String TAG = PushValidationUtil.class.getSimpleName();
    private static final String TITLE = "title";
    private static final String IMAGE = "image";
    private static final String URL = "url";
    private static final String BRAND = "brand";
    private static final String ID = "id";

    PushValidationUtil() {
    }

    static boolean isBreakingPushValid(@NonNull BreakingNotificationContent breakingNotificationContent, PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager) {
        String notificationContentImage;
        String itemId = PushValidationUtil.replaceEmptyItem(breakingNotificationContent.getId(), ID);
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(breakingNotificationContent.getTitle()))) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item title is invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item title", PushValidationUtil.replaceEmptyItem(breakingNotificationContent.getTitle(), TITLE), itemId);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(breakingNotificationContent.getDescription()))) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item description is invalid");
        }
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(notificationContentImage = breakingNotificationContent.getImage()))) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item image uri is invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item image", PushValidationUtil.replaceEmptyItem(notificationContentImage, IMAGE), itemId);
            return false;
        }
        if (!notificationContentImage.contains("taboola.com")) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item image uri is invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item image", PushValidationUtil.replaceEmptyItem(notificationContentImage, IMAGE), itemId);
            return false;
        }
        if (!PushValidationUtil.isClickUrlValid(breakingNotificationContent.getUrl())) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item url is invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item url", PushValidationUtil.replaceEmptyItem(breakingNotificationContent.getUrl(), URL), itemId);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(breakingNotificationContent.getId()))) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item id is invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item id", PushValidationUtil.replaceEmptyItem(breakingNotificationContent.getId(), ID), itemId);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(breakingNotificationContent.getBrand()))) {
            Log.d((String)TAG, (String)"isBreakingPushValid: item brand invalid");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid item brand", PushValidationUtil.replaceEmptyItem(breakingNotificationContent.getBrand(), BRAND), itemId);
            return false;
        }
        return true;
    }

    static boolean isWakePushValid(@NonNull WakeUpContent wakeUpContent, PushNotificationsAnalyticsManager manager) {
        String itemId = PushValidationUtil.replaceEmptyItem(wakeUpContent.getMessageId(), ID);
        if (TextUtils.isEmpty((CharSequence)PushValidationUtil.unescape(wakeUpContent.getMessageId()))) {
            Log.d((String)TAG, (String)"isWakePushValid: item id invalid");
            manager.sendInvalidPushItemEvent("Invalid item id", PushValidationUtil.replaceEmptyItem(wakeUpContent.getMessageId(), ID), itemId);
            return false;
        }
        return true;
    }

    static boolean isOcambaPushActionValid(@NonNull OcambaNotificationObject ocambaNotificationObject, @Nullable HashMap<String, String> customData, @Nullable String pushAction, @Nullable String messageId, @NonNull PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager) {
        if (customData != null) {
            if (!TextUtils.isEmpty((CharSequence)pushAction)) {
                return true;
            }
            Log.i((String)TAG, (String)"isNotificationObjectValid: invalid action");
            pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Invalid action", "Action: = " + pushAction + PushValidationUtil.getPushObjString(ocambaNotificationObject), messageId);
            return false;
        }
        Log.i((String)TAG, (String)"isNotificationObjectValid: customDataContent is invalid");
        pushNotificationsAnalyticsManager.sendInvalidPushItemEvent("Push object custom data is invalid", "Custom data from Ocamba notification object is null" + PushValidationUtil.getPushObjString(ocambaNotificationObject), "");
        return false;
    }

    private static String getPushObjString(@NonNull OcambaNotificationObject ocambaNotificationObject) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(TITLE, (Object)ocambaNotificationObject.getTitle());
            jsonObject.put(IMAGE, (Object)ocambaNotificationObject.getImage());
            jsonObject.put("description", (Object)ocambaNotificationObject.getDescription());
            jsonObject.put(URL, (Object)ocambaNotificationObject.getUrl());
            try {
                String customData = ocambaNotificationObject.getCustomData();
                if (!TextUtils.isEmpty((CharSequence)customData)) {
                    jsonObject.put("customData", (Object)new JSONObject(customData));
                } else {
                    jsonObject.put("customData", (Object)"");
                }
            }
            catch (Exception e) {
                jsonObject.put("customData", (Object)"");
            }
            return "\nPushObj = " + jsonObject.toString(2);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getPushObjString: error " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private static boolean isClickUrlValid(String clickUrl) {
        return PushValidationUtil.isUrlValid(PushValidationUtil.unescape(clickUrl));
    }

    private static boolean isUrlValid(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            return Patterns.WEB_URL.matcher(url).matches();
        }
        return false;
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }

    private static String replaceEmptyItem(@Nullable String brokenItem, String key) {
        return !TextUtils.isEmpty((CharSequence)brokenItem) ? brokenItem : key + " is empty";
    }
}

