/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.taboola.android.plus.notification.BridgeInternalNotification;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.TBPushRawData;
import com.taboola.android.plus.push_notifications.models.WakeUpContent;
import java.util.HashMap;

@RequiresApi(api=21)
public class PushNotificationsUtil {
    private static final String TAG = PushNotificationsUtil.class.getSimpleName();
    private static final String ACTION = "action";
    private static final String MESSAGE_ID = "messageId";
    private static final String BRAND_NAME = "brandName";
    private static final String TIMESTAMP = "timestamp";

    public static boolean shouldUsePushNotificationsFeature(PushNotificationsConfig config) {
        if (!config.isPushNotificationsFeatureEnabled()) {
            Log.v((String)TAG, (String)"Push notifications are disabled in remote config");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)config.getOcambaApiKey())) {
            Log.v((String)TAG, (String)"Push notifications are enabled in remote config");
            return true;
        }
        Log.e((String)TAG, (String)"Push notifications are enabled in remote config but ApiKey is missing");
        return false;
    }

    public static boolean shouldAllowManualRendering(PushNotificationsConfig config) {
        return config != null && config.isManualRenderingEnabled();
    }

    public static boolean shouldAllowManualReporting(PushNotificationsConfig config) {
        return config != null && config.isManualReportingEnabled();
    }

    static void onWakePushReceived(TBNotificationManager tbNotificationManager) {
        BridgeInternalNotification.onWakePushReceivedInternal(tbNotificationManager);
    }

    static BreakingNotificationContent parseOcambaObjectIntoBreaking(OcambaNotificationObject ocambaNotificationObject, HashMap<String, String> customDataMap, String messageId) {
        String title = ocambaNotificationObject.getTitle();
        String description = ocambaNotificationObject.getDescription();
        String image = ocambaNotificationObject.getImage();
        String url = ocambaNotificationObject.getUrl();
        String brand = PushNotificationsUtil.geBrandNameFromCustomData(customDataMap);
        return new BreakingNotificationContent(title, description, image, url, brand, messageId);
    }

    static TBPushRawData parseOcambaObjectIntoTBPushRawData(@NonNull OcambaNotificationObject ocambaNotificationObject, @NonNull HashMap<String, String> customDataMap) {
        return new TBPushRawData(ocambaNotificationObject.getTitle(), ocambaNotificationObject.getDescription(), ocambaNotificationObject.getImage(), ocambaNotificationObject.getUrl(), customDataMap);
    }

    static WakeUpContent parseOcambaObjectIntoWake(String messageId) {
        return new WakeUpContent(messageId);
    }

    private static String getStringFromMap(@Nullable HashMap<String, String> map, String key) {
        String value = null;
        if (map != null && !map.isEmpty()) {
            value = map.get(key);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    static String getActionFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, ACTION);
    }

    static String getMessageIdFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, MESSAGE_ID);
    }

    static String geBrandNameFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, BRAND_NAME);
    }

    static String geTimestampFromCustomData(@Nullable HashMap<String, String> customData) {
        return PushNotificationsUtil.getStringFromMap(customData, TIMESTAMP);
    }
}

