/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementTypeAdapter;
import com.taboola.android.plus.notification.NotificationContentState;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.shared.AbstractLocalStorage;
import com.taboola.android.utils.Logger;

public class TBNotificationLocalStore
extends AbstractLocalStorage {
    private static final String TAG = "TBNotificationLocalStor";
    private static final String SHARED_PREFS_FILE_NAME = "tb_notification_manager";
    private static final String SHARED_PREFS_KEY_TB_CONTENT = "tb_notification_content";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE = "notification_content_state";
    private static final String SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP = "tb_notification_refreshed_timestamp";
    private static final String SHARED_PREFS_KEY_DID_CLICK_ARROW = "did_click_arrow";
    private static final String SHARED_PREFS_KEY_PREVIOUS_STATE = "previous_state";
    private static final String SHARED_PREFS_KEY_UI_MODE = "ui_mode";
    private static final String SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "notification_blocked_by_config_event";
    private static final String SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME = "last_content_refresh_event_time";
    private static final String SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME = "last_auto_next_item_event_time";
    private static final String SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME = "last_render_event_time";
    private static final String SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME = "last_failed_to_render_event_time";
    private static final String LAST_DISMISS_EVENT_TIMESTAMP = "lastDismissEventTimestamp";
    private static final String LAST_RUNNING_NOTIFICATION_TIME = "last_running_notification_time";
    private static final String COUNT_OF_RENDERED_NOTIFICATIONS_TODAY = "max_notification_trigger_count_per_day";
    private static final String DISMISSED_NOTIFICATIONS_COUNT = "dismissed_notifications_count";
    private static final String ENGAGED_NOTIFICATIONS_COUNT = "engaged_notifications_count";
    private static final String CURRENT_ENGAGED_GROUP_NAME = "current_engaged_group_type";
    private static final String NORMAL_ENGAGED_GROUP = "Normal";
    private static final String SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "should_send_event_user_assigned_to_notification_engagement_group";
    public static final int SHARED_PREFS_KEY_ENABLED_STATE = 1;
    public static final int SHARED_PREFS_KEY_DISABLED_STATE = 0;
    private TBContent cachedContent;
    private NotificationContentState notificationContentState;

    public TBNotificationLocalStore(Context context) {
        super(context, SHARED_PREFS_FILE_NAME);
    }

    long getLastAutoNextItemEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME);
    }

    void setLastAutoNextItemEventTime(long lastTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_AUTO_NEXT_ITEM_EVENT_TIME, lastTime);
    }

    long getLastShownNotificationTimestamp() {
        return this.sharedPreferences.getLong(LAST_RUNNING_NOTIFICATION_TIME, 0L);
    }

    void setLastShownNotificationTime(long time) {
        this.sharedPreferences.edit().putLong(LAST_RUNNING_NOTIFICATION_TIME, time).apply();
    }

    int getCountOfRenderedNotificationsToday() {
        return this.sharedPreferences.getInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, 0);
    }

    void setCountOfRenderedNotificationsToday(int counter) {
        this.sharedPreferences.edit().putInt(COUNT_OF_RENDERED_NOTIFICATIONS_TODAY, counter).apply();
    }

    void setLastContentRefreshEventTime(long lastContentRefreshEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME, lastContentRefreshEventTime);
    }

    long getLastContentRefreshEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_CONTENT_REFRESH_EVENT_TIME);
    }

    void setLastRenderEventTimestamp(long lastRenderEventTimestamp) {
        this.putLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME, lastRenderEventTimestamp);
    }

    long getLastRenderEventTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_LAST_RENDER_EVENT_TIME);
    }

    void setLastDismissEventTimestamp(long lastDismissEventTimestamp) {
        this.putLong(LAST_DISMISS_EVENT_TIMESTAMP, lastDismissEventTimestamp);
    }

    long getLastDismissEventTimestamp() {
        return this.getLong(LAST_DISMISS_EVENT_TIMESTAMP);
    }

    void setLastFailedToRenderEventTime(long lastFailedToRenderEventTime) {
        this.putLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME, lastFailedToRenderEventTime);
    }

    long getLastFailedToRenderEventTime() {
        return this.getLong(SHARED_PREFS_KEY_LAST_FAILED_TO_RENDER_EVENT_TIME);
    }

    long getRefreshedTimestamp() {
        return this.getLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP);
    }

    void setRefreshedTimestamp(long refreshedTimestamp) {
        this.putLong(SHARED_PREFS_KEY_TB_REFRESHED_TIMESTAMP, refreshedTimestamp);
    }

    boolean getDidClickArrow() {
        return this.getBoolean(SHARED_PREFS_KEY_DID_CLICK_ARROW);
    }

    void setDidClickArrow(boolean didClickArrow) {
        this.putBoolean(SHARED_PREFS_KEY_DID_CLICK_ARROW, didClickArrow);
    }

    void setPreviousState(int previousState) {
        this.putInt(SHARED_PREFS_KEY_PREVIOUS_STATE, previousState);
    }

    int getPreviousState() {
        return this.getInt(SHARED_PREFS_KEY_PREVIOUS_STATE);
    }

    void setUiMode(String UiMode) {
        this.putString(SHARED_PREFS_KEY_UI_MODE, UiMode);
    }

    String getUiMode() {
        return this.getString(SHARED_PREFS_KEY_UI_MODE);
    }

    void setSendNotificationBlockedByConfigEvent() {
        this.putBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, true);
    }

    boolean isNotificationBlockedByConfigEventAlreadySend() {
        return this.getBoolean(SHARED_PREFS_KEY_NOTIFICATION_BLOCKED_BY_CONFIG_EVENT);
    }

    void setContent(TBContent content) {
        this.cachedContent = content;
        try {
            String contentJson = this.gson.toJson((Object)content);
            this.putString(SHARED_PREFS_KEY_TB_CONTENT, contentJson);
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("setContent error" + e), (Throwable)e);
        }
    }

    @Nullable
    TBContent getContent() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        String currentContentStr = this.getString(SHARED_PREFS_KEY_TB_CONTENT);
        if (!TextUtils.isEmpty((CharSequence)currentContentStr)) {
            try {
                Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(TBPlacement.class, (Object)new TBPlacementTypeAdapter()).create();
                this.cachedContent = (TBContent)gsonWithAdapter.fromJson(currentContentStr, TBContent.class);
                return this.cachedContent;
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)("getContent error" + e), (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    NotificationContentState getNotificationContentState() {
        if (this.notificationContentState != null) {
            return this.notificationContentState;
        }
        String contentStateJson = this.getString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE);
        if (contentStateJson != null) {
            this.notificationContentState = (NotificationContentState)this.gson.fromJson(contentStateJson, NotificationContentState.class);
            return this.notificationContentState;
        }
        return null;
    }

    void setNotificationContentState(NotificationContentState notificationContentState) {
        this.notificationContentState = notificationContentState;
        String contentStateJson = this.gson.toJson((Object)notificationContentState);
        this.putString(SHARED_PREFS_KEY_NOTIFICATION_CONTENT_STATE, contentStateJson);
    }

    void setCountOfDismissedNotifications(int countOfDismissedNotifications) {
        this.sharedPreferences.edit().putInt(DISMISSED_NOTIFICATIONS_COUNT, countOfDismissedNotifications).apply();
    }

    int getCountOfDismissedNotifications() {
        return this.sharedPreferences.getInt(DISMISSED_NOTIFICATIONS_COUNT, 0);
    }

    void setCountOfEngagedNotifications(int countOfEngagedNotifications) {
        this.sharedPreferences.edit().putInt(ENGAGED_NOTIFICATIONS_COUNT, countOfEngagedNotifications).apply();
    }

    int getCountOfEngagedNotifications() {
        return this.sharedPreferences.getInt(ENGAGED_NOTIFICATIONS_COUNT, 0);
    }

    void setCurrentEngagedGroupName(String groupName) {
        this.sharedPreferences.edit().putString(CURRENT_ENGAGED_GROUP_NAME, groupName).apply();
    }

    String getCurrentEngagedGroupName() {
        return this.sharedPreferences.getString(CURRENT_ENGAGED_GROUP_NAME, NORMAL_ENGAGED_GROUP);
    }

    void setShouldSendUserAssignedToNotificationEngagmentGroupEvent(boolean shouldSendEvent) {
        this.sharedPreferences.edit().putBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, shouldSendEvent).apply();
    }

    boolean shouldSendUserAssignedToNotificationEngagmentGroupEvent() {
        return this.sharedPreferences.getBoolean(SHOULD_SEND_EVENT_USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, true);
    }
}

