/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.TBNotificationRefreshJob;
import com.taboola.android.plus.shared.SharedLocalStorage;
import java.util.List;

public class OnApplicationUpdatedReceiver
extends BroadcastReceiver {
    private static final String TAG = OnApplicationUpdatedReceiver.class.getSimpleName();

    public void onReceive(final Context context, Intent intent) {
        Log.i((String)TAG, (String)"onReceive: application was just updated");
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"onReceive: Android version is less than LOLLIPOP. Ignoring call.");
            return;
        }
        SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(context);
        if (!sharedLocalStorage.isNotificationEnabled()) {
            Log.d((String)TAG, (String)"onReceive: notifications are disabled");
            return;
        }
        List<String> categories = sharedLocalStorage.getNotificationCategories();
        if (categories.isEmpty()) {
            Log.w((String)TAG, (String)"onReceive: failed to restore notification refresh job: empty categories");
            return;
        }
        BridgeInternal.reInit(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                TBNotificationManager notificationManager = taboolaPlus.getNotificationManager();
                notificationManager.dismissNotification();
                TBNotificationRefreshJob.schedulePeriodicRefresh(context, notificationManager.getSharedLocalStorage().getNotificationCategories(), notificationManager.getNotificationConfig().getRefreshIntervalMs());
                Log.i((String)TAG, (String)"onReceive: successfully restored notification refresh job");
            }
        }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("onReceive: failed to handle request : Taboola Plus restore failed : " + throwable.getMessage()));
            }
        });
    }
}

