/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class PlacementValidationUtil {
    private static final String TAG = PlacementValidationUtil.class.getSimpleName();
    private static final String THUMBNAIL_URL = "thumbnail";
    private static final String ITEM_TITLE = "name";
    private static final String CREATED_DATE = "created";
    private static final String CLICK_URL = "url";
    private static final String BRANDING = "branding";
    private static final String ORIGIN = "origin";
    private static final String SPONSORED_CONST = "sponsored";
    private static final String RECOMMENDATION_ITEM_ID = "id";

    public static boolean isPlacementValid(@NonNull TBPlacement placement, TBNotificationAnalyticsManager manager) {
        HashMap externalDataMap;
        if (placement.getItems() == null || placement.getItems().isEmpty()) {
            Log.d((String)TAG, (String)"isPlacementValid: no recommendation items");
            manager.sendInvalidItemInServerResponseEvent("No recommendation items", "", "");
            return false;
        }
        List items = placement.getItems();
        if (items.size() > 1) {
            Log.w((String)TAG, (String)"isPlacementValid: placement has more than one item");
        }
        if ((externalDataMap = ((TBRecommendationItem)placement.getItems().get(0)).getExtraDataMap()) == null || externalDataMap.isEmpty()) {
            Log.d((String)TAG, (String)"isPlacementValid: externalDataMap is empty or missing");
            manager.sendInvalidItemInServerResponseEvent("ExtraDataMap is empty or missing", "", "");
            return false;
        }
        String thumbnailUrl = PlacementValidationUtil.getThumbnailUrl((String)externalDataMap.get(THUMBNAIL_URL));
        String itemId = PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(PlacementValidationUtil.unescape(RECOMMENDATION_ITEM_ID)), RECOMMENDATION_ITEM_ID);
        if (!PlacementValidationUtil.hasItemId((String)externalDataMap.get(RECOMMENDATION_ITEM_ID))) {
            Log.d((String)TAG, (String)"isPlacementValid: recommendation item id is missing or invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid placement id", PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(RECOMMENDATION_ITEM_ID), RECOMMENDATION_ITEM_ID), itemId);
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)thumbnailUrl) || !PlacementValidationUtil.isUrlValid(thumbnailUrl)) {
            Log.d((String)TAG, (String)"isPlacementValid: thumbnail url invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid thumbnail url", PlacementValidationUtil.replaceEmptyItem(thumbnailUrl, THUMBNAIL_URL), itemId);
            return false;
        }
        if (!PlacementValidationUtil.isTitleValid((String)externalDataMap.get(ITEM_TITLE))) {
            Log.d((String)TAG, (String)"isPlacementValid: recommendation item name invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid recommendation item name", PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(ITEM_TITLE), ITEM_TITLE), itemId);
            return false;
        }
        if (!PlacementValidationUtil.isDateValid((String)externalDataMap.get(CREATED_DATE))) {
            Log.d((String)TAG, (String)"isPlacementValid: created date invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid created date", PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(CREATED_DATE), CREATED_DATE), itemId);
            return false;
        }
        if (!PlacementValidationUtil.isClickUrlValid((String)externalDataMap.get(CLICK_URL))) {
            Log.d((String)TAG, (String)"isPlacementValid: click url is missing or invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid click url", (String)externalDataMap.get(CLICK_URL), itemId);
            return false;
        }
        if (!PlacementValidationUtil.isBrandValid((String)externalDataMap.get(BRANDING))) {
            Log.d((String)TAG, (String)"isPlacementValid: branding item is missing or invalid");
            manager.sendInvalidItemInServerResponseEvent("Invalid branding item", PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(BRANDING), BRANDING), itemId);
            return false;
        }
        if (!PlacementValidationUtil.hasOriginItem((String)externalDataMap.get(ORIGIN))) {
            Log.d((String)TAG, (String)"isPlacementValid: invalid origin value for sponsored content");
            manager.sendInvalidItemInServerResponseEvent("Invalid origin item", PlacementValidationUtil.replaceEmptyItem((String)externalDataMap.get(ORIGIN), ORIGIN), itemId);
            return false;
        }
        return true;
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }

    private static String getThumbnailUrl(String thumbnail) {
        String thumbnailUrl = "";
        try {
            if (!TextUtils.isEmpty((CharSequence)thumbnail) && thumbnail.length() > 1) {
                thumbnail = thumbnail.substring(1, thumbnail.length() - 1);
                JSONObject thumbnailObject = new JSONObject(thumbnail);
                thumbnailUrl = String.valueOf(thumbnailObject.get(CLICK_URL));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return thumbnailUrl;
    }

    private static boolean hasItemId(String itemId) {
        return !TextUtils.isEmpty((CharSequence)PlacementValidationUtil.unescape(itemId));
    }

    private static boolean hasOriginItem(String originItem) {
        return !TextUtils.isEmpty((CharSequence)PlacementValidationUtil.unescape(originItem)) && PlacementValidationUtil.unescape(originItem).equalsIgnoreCase(SPONSORED_CONST);
    }

    private static boolean isDateValid(String createdDate) {
        boolean isValid;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        Date date = null;
        if (TextUtils.isEmpty((CharSequence)createdDate) || createdDate.length() < 2) {
            return false;
        }
        try {
            date = simpleDateFormat.parse(createdDate);
            isValid = true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            isValid = false;
        }
        return isValid;
    }

    private static boolean isTitleValid(String stringToCheck) {
        return !TextUtils.isEmpty((CharSequence)PlacementValidationUtil.unescape(stringToCheck));
    }

    private static boolean isClickUrlValid(String clickUrl) {
        return PlacementValidationUtil.isUrlValid(PlacementValidationUtil.unescape(clickUrl));
    }

    private static boolean isBrandValid(String brand) {
        return !TextUtils.isEmpty((CharSequence)PlacementValidationUtil.unescape(brand));
    }

    private static boolean isUrlValid(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            return Patterns.WEB_URL.matcher(url).matches();
        }
        return false;
    }

    private static String replaceEmptyItem(@Nullable String brokenItem, String key) {
        return !TextUtils.isEmpty((CharSequence)brokenItem) ? brokenItem : key + " is empty";
    }
}

