/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.UiThread;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import com.google.gson.Gson;
import com.ocamba.hoood.OcambaHoood;
import com.ocamba.hoood.transport.OcambaResponseCallback;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.push_notifications.OcambaInitCallback;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.PushNotificationsUtil;
import com.taboola.android.plus.push_notifications.TBPushNotificationRenderer;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.CustomDataContent;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import com.taboola.android.utils.Logger;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;

@RequiresApi(api=21)
public class TBPushNotificationsManager {
    private static final String TAG = TBPushNotificationsManager.class.getSimpleName();
    public static final String NOTIFICATION_TYPE_BREAKING = "breaking";
    public static final String NOTIFICATION_TYPE_WAKE = "wake";
    private final PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager;
    private final TBPushNotificationRenderer renderer;
    private final SharedLocalStorage sharedLocalStorage;
    private final Context appContext;
    private PushNotificationsConfig pushNotificationsConfig;
    private LocalizationStrings localizationStrings;
    private Boolean pushIsInit;
    private Executor mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();

    @UiThread
    public static boolean handleTaboolaPush(final RemoteMessage remoteMessage) {
        if (remoteMessage != null && !remoteMessage.getData().isEmpty() && OcambaHoood.notification().isOcambaMessage(remoteMessage)) {
            Log.d((String)TAG, (String)"handleTaboolaPush: handling Push notification");
            BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                @Override
                public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                    TBPushNotificationsManager manager = taboolaPlus.getPushNotificationsManager();
                    if (manager != null && manager.pushIsInit != null && manager.pushIsInit.booleanValue()) {
                        PushNotificationsConfig pushNotificationsConfig = manager.getPushNotificationsConfig();
                        boolean isPushFeatureEnabled = PushNotificationsUtil.shouldUsePushNotificationsFeature(pushNotificationsConfig);
                        if (isPushFeatureEnabled) {
                            OcambaHoood.notification().onMessageReceived(remoteMessage);
                        } else {
                            Log.v((String)TAG, (String)"handleTaboolaPush: Push notification ignored because Push Notifications feature is disabled");
                        }
                    } else {
                        Logger.e((String)TAG, (String)"handleTaboolaPush: Taboola Plus restore failed : push init failed");
                    }
                }
            }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

                @Override
                public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                    Log.e((String)TAG, (String)("handleTaboolaPush: Taboola Plus restore failed : " + throwable.getMessage()), (Throwable)throwable);
                }
            });
            return true;
        }
        Log.v((String)TAG, (String)"handleTaboolaPush: Push notification ignored because it was not sent by Taboola server");
        return false;
    }

    public static void onNewFirebaseToken(String token) {
        OcambaHoood.notification().pushToken(token);
    }

    @NonNull
    static String getNotificationAction(Map<String, String> data) {
        CustomDataContent customDataContent = (CustomDataContent)new Gson().fromJson(data.get("c"), CustomDataContent.class);
        if (customDataContent == null) {
            return "";
        }
        return customDataContent.getAction();
    }

    TBPushNotificationsManager(@NonNull Context context, @NonNull PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager, @NonNull SharedLocalStorage sharedLocalStorage) {
        this.appContext = context.getApplicationContext();
        this.pushNotificationsAnalyticsManager = pushNotificationsAnalyticsManager;
        this.sharedLocalStorage = sharedLocalStorage;
        this.renderer = new TBPushNotificationRenderer(context, this, this.getNotificationIcon());
    }

    void applyConfig(@NonNull PushNotificationsConfig pushNotificationsConfig, @NonNull LocalizationStrings localizationStrings) {
        this.pushNotificationsConfig = pushNotificationsConfig;
        this.localizationStrings = localizationStrings;
    }

    void initPushNotifications(final @NonNull TBPushNotificationsManager tbPushNotificationsManager, final @NonNull String nonLocalizedPubId, final @NonNull String localizedPubId, final @NonNull String configVariant, final @Nullable OcambaInitCallback initCallback) {
        OcambaHoood.push().setPushResponse(new OcambaResponseCallback(){

            public void onFailure(Exception e) {
                Logger.e((String)TAG, (String)("initPushNotifications error while init push " + e.getLocalizedMessage()), (Throwable)e);
                tbPushNotificationsManager.getAnalyticsManager().sendInitFailedEvent(e);
                TBPushNotificationsManager.this.pushIsInit = false;
                TBPushNotificationsManager.this.mainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (initCallback != null) {
                            initCallback.onFailure();
                        }
                    }
                });
            }

            public void onResponse(int code, String response) {
                Logger.d((String)TAG, (String)("initPushNotifications.onResponse() called with: code = [" + code + "], response = [" + response + "]"));
                OcambaHoood.notification().customLayout();
                TBPushNotificationsManager.sendOcambaTrackingData(tbPushNotificationsManager.getSharedLocalStorage(), TBPushNotificationsManager.this.appContext, nonLocalizedPubId, localizedPubId, configVariant);
                TBPushNotificationsManager.this.pushIsInit = true;
                TBPushNotificationsManager.this.mainThreadExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (initCallback != null) {
                            initCallback.onSuccess();
                        }
                    }
                });
            }
        }).init(this.pushNotificationsConfig.getOcambaApiKey());
    }

    private static void sendOcambaTrackingData(SharedLocalStorage sharedLocalStorage, @NonNull Context appContext, @NonNull String nonLocalizedPublisher, @NonNull String localizedPublisherName, @NonNull String configVariant) {
        HashMap<String, String> trackData = new HashMap<String, String>();
        trackData.put("device_id", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        trackData.put("os_name", "Android");
        trackData.put("platform", "Android");
        trackData.put("os_version", Build.VERSION.RELEASE);
        trackData.put("device_model", TBDeviceInfoUtil.getDeviceName());
        trackData.put("app_version", TBDeviceInfoUtil.getAppVersion(appContext));
        trackData.put("appId", appContext.getPackageName());
        trackData.put("device_manufacturer", Build.MANUFACTURER);
        trackData.put("device_brand", Build.MANUFACTURER);
        trackData.put("carrier", TBDeviceInfoUtil.getCarrier(appContext));
        trackData.put("language", Locale.getDefault().getLanguage().toUpperCase());
        trackData.put("adid", BridgeInternal.getAdvertisingIdInfo().getAdvertisingId());
        trackData.put("sdk+(TaboolaPlus)version", "1.3.5");
        trackData.put("sdk(TaboolaApi)version", "2.3.7");
        trackData.put("simCountry", TBDeviceInfoUtil.getSimCountry(sharedLocalStorage, appContext).toUpperCase());
        trackData.put("publisher", nonLocalizedPublisher);
        trackData.put("localizedPublisher", localizedPublisherName);
        trackData.put("configVariant", configVariant);
        OcambaHoood.track(trackData);
        OcambaHoood.sendTrack();
        Logger.d((String)TAG, (String)("sendPushTrackingData() called with: = [" + trackData.toString() + "]"));
    }

    void renderBreakingNotification(BreakingNotificationContent breakingNotificationContent) {
        TBPushNotificationRenderer.RenderResult renderResult = this.renderer.renderNotification(breakingNotificationContent, this.pushNotificationsConfig);
        if (renderResult.isSuccessful()) {
            this.pushNotificationsAnalyticsManager.sendPushBreakingRenderEvent(breakingNotificationContent);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.pushNotificationsAnalyticsManager.sendPushBreakingFailedToRenderEvent(breakingNotificationContent, renderResult.getErrorMessage());
        }
    }

    void dismissNotification() {
        Log.v((String)TAG, (String)"dismissPushNotification");
        this.renderer.dismissNotification();
    }

    PushNotificationsConfig getPushNotificationsConfig() {
        return this.pushNotificationsConfig;
    }

    boolean handleNotificationBlockByUser() {
        boolean areNotificationsBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(this.appContext, "Breaking news");
        this.pushNotificationsAnalyticsManager.sendCheckNotificationDisabledStatusEvent(areNotificationsBlockedByUser);
        if (areNotificationsBlockedByUser) {
            if (!this.sharedLocalStorage.isNotificationBlockBySystem()) {
                this.pushNotificationsAnalyticsManager.sendNotificationDisabledBySystemEvent();
                this.sharedLocalStorage.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (this.sharedLocalStorage.isNotificationBlockBySystem()) {
            this.pushNotificationsAnalyticsManager.sendNotificationEnabledBySystemEvent();
            this.sharedLocalStorage.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    private int getNotificationIcon() {
        if (this.sharedLocalStorage.getNotificationIcon() != -1) {
            return this.sharedLocalStorage.getNotificationIcon();
        }
        return this.appContext.getApplicationInfo().icon;
    }

    LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    @NonNull
    SharedLocalStorage getSharedLocalStorage() {
        return this.sharedLocalStorage;
    }

    PushNotificationsAnalyticsManager getAnalyticsManager() {
        return this.pushNotificationsAnalyticsManager;
    }
}

