/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.ocamba.hoood.notifications.OcambaNotificationObject;
import com.taboola.android.plus.notification.BridgeInternalNotification;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.push_notifications.PushNotificationsConfig;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.push_notifications.models.CustomDataContent;
import com.taboola.android.plus.push_notifications.models.WakeUpContent;

@RequiresApi(api=21)
public class PushNotificationsUtil {
    private static final String TAG = PushNotificationsUtil.class.getSimpleName();

    public static boolean shouldUsePushNotificationsFeature(PushNotificationsConfig config) {
        if (!config.isPushNotificationsFeatureEnabled()) {
            Log.v((String)TAG, (String)"Push notifications are disabled in remote config");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)config.getOcambaApiKey())) {
            Log.v((String)TAG, (String)"Push notifications are enabled in remote config");
            return true;
        }
        Log.e((String)TAG, (String)"Push notifications are enabled in remote config but ApiKey is missing");
        return false;
    }

    static void onWakePushReceived(TBNotificationManager tbNotificationManager) {
        BridgeInternalNotification.onWakePushReceivedInternal(tbNotificationManager);
    }

    static BreakingNotificationContent parseOcambaObjectIntoBreaking(OcambaNotificationObject ocambaNotificationObject) {
        CustomDataContent customDataContent = (CustomDataContent)new Gson().fromJson(ocambaNotificationObject.getCustomData(), CustomDataContent.class);
        String title = ocambaNotificationObject.getTitle();
        String description = ocambaNotificationObject.getDescription();
        String image = ocambaNotificationObject.getImage();
        String url = ocambaNotificationObject.getUrl();
        String brand = customDataContent.getBrandName();
        String id2 = customDataContent.getMessageId();
        BreakingNotificationContent breakingNotificationContent = new BreakingNotificationContent(title, description, image, url, brand, id2);
        return breakingNotificationContent;
    }

    static WakeUpContent parseOcambaObjectIntoWake(OcambaNotificationObject ocambaNotificationObject) {
        CustomDataContent customDataContent = (CustomDataContent)new Gson().fromJson(ocambaNotificationObject.getCustomData(), CustomDataContent.class);
        WakeUpContent wakeUpContent = new WakeUpContent(customDataContent.getMessageId());
        return wakeUpContent;
    }
}

