/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.widget.Toast;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.push_notifications.BridgeInternalPushNotification;
import com.taboola.android.plus.push_notifications.PushNotificationsAnalyticsManager;
import com.taboola.android.plus.push_notifications.TBPushNotificationsManager;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import java.util.HashMap;
import java.util.concurrent.Executor;

public class PushNotificationsStateReceiver
extends BroadcastReceiver {
    public static final String NOTIFICATION_TYPE = "notification_type";
    static final String INTENT_KEY_REQUEST_CODE = "intent_key_request_code";
    private static final String TAG = PushNotificationsStateReceiver.class.getSimpleName();
    private static final long NOTIFICATION_CLICK_DELAY = 3000L;
    private static long lastNotificationClickTime = 0L;
    private TBPushNotificationsManager tbPushNotificationsManager;
    private PushNotificationsAnalyticsManager pushNotificationsAnalyticsManager;
    private SharedLocalStorage sharedLocalStorage;
    private final Executor mainThreadExecutor = new TBNotificationExecutors.MainThreadExecutor();

    public void onReceive(final Context context, final Intent intent) {
        if (intent != null && intent.getExtras() != null) {
            if (Build.VERSION.SDK_INT < 21) {
                Log.e((String)TAG, (String)"onReceive : Android version is less than LOLLIPOP. No events were supposed to be sent.");
                return;
            }
            if (this.tbPushNotificationsManager == null) {
                BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                    @Override
                    @RequiresApi(api=21)
                    public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                        PushNotificationsStateReceiver.this.tbPushNotificationsManager = taboolaPlus.getPushNotificationsManager();
                        PushNotificationsStateReceiver.this.pushNotificationsAnalyticsManager = PushNotificationsStateReceiver.this.tbPushNotificationsManager.getAnalyticsManager();
                        PushNotificationsStateReceiver.this.tbPushNotificationsManager = taboolaPlus.getPushNotificationsManager();
                        PushNotificationsStateReceiver.this.sharedLocalStorage = PushNotificationsStateReceiver.this.tbPushNotificationsManager.getSharedLocalStorage();
                        if (TaboolaApi.getInstance().isInitialized()) {
                            PushNotificationsStateReceiver.this.handleRequest(context, intent);
                        } else {
                            String info = "TBNotificationStateReceiver: onReceive(): onTaboolaPlusRetrieved()";
                            PushNotificationsStateReceiver.this.pushNotificationsAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
                            final HashMap<String, String> extraProperties = PushNotificationsStateReceiver.this.sharedLocalStorage.getTaboolaPlusExtraProperties();
                            ConfigManager.getCurrentConfigs(PushNotificationsStateReceiver.this.sharedLocalStorage, context, PushNotificationsStateReceiver.this.sharedLocalStorage.getPublisher(), PushNotificationsStateReceiver.this.sharedLocalStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

                                @Override
                                @RequiresApi(api=21)
                                public void onConfigsFetched(final SdkPlusConfig config, final LanguagesConfig languagesConfig) {
                                    new TBNotificationExecutors.MainThreadExecutor().execute(new Runnable(){

                                        @Override
                                        public void run() {
                                            BridgeInternal.initTaboolaApi(PushNotificationsStateReceiver.this.sharedLocalStorage, context, config.getContentConfig(), languagesConfig, extraProperties);
                                            PushNotificationsStateReceiver.this.handleRequest(context, intent);
                                        }
                                    });
                                }

                                @Override
                                public void onConfigsFailed(Throwable throwable) {
                                    Log.e((String)TAG, (String)"onReceive: failed to handle request : onConfigsFailed: fail to get configs");
                                }
                            });
                        }
                    }
                }, new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

                    @Override
                    public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                        Log.e((String)TAG, (String)("onReceive: failed to handle request : Taboola Plus restore failed : " + throwable.getMessage()));
                    }
                });
            } else {
                this.handleRequest(context, intent);
            }
        }
    }

    @RequiresApi(api=21)
    private void handleRequest(Context context, Intent intent) {
        int reqCode = intent.getIntExtra(INTENT_KEY_REQUEST_CODE, -1);
        switch (reqCode) {
            case 4100: {
                BreakingNotificationContent breakingNotificationContent = (BreakingNotificationContent)intent.getParcelableExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT");
                this.pushNotificationsAnalyticsManager.sendPushBreakingDismissedEvent(breakingNotificationContent);
                break;
            }
            case 5300: {
                this.handlePushBreakingItemClick(context, intent);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("onReceive: Illegal request code: " + reqCode));
            }
        }
    }

    @RequiresApi(api=21)
    private void handlePushBreakingItemClick(Context context, Intent intent) {
        Log.v((String)TAG, (String)"onReceive: push item clicked");
        if (System.currentTimeMillis() < lastNotificationClickTime + 3000L) {
            return;
        }
        if (!ConditionCheckUtil.isNetworkAvailable(context)) {
            Toast.makeText((Context)context, (CharSequence)this.tbPushNotificationsManager.getLocalizationStrings().getNoNetworkConnection(), (int)1).show();
            return;
        }
        this.collapseStatusBar(context);
        BreakingNotificationContent breakingNotificationContent = (BreakingNotificationContent)intent.getParcelableExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT");
        Intent clickIntent = new Intent("com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT");
        clickIntent.setFlags(0x34000000);
        clickIntent.putExtra(NOTIFICATION_TYPE, "breaking");
        clickIntent.putExtra("com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_PUSH_CONTENT", (Parcelable)breakingNotificationContent);
        clickIntent.setPackage(context.getPackageName());
        try {
            context.startActivity(clickIntent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        this.pushNotificationsAnalyticsManager.sendTapPushBreakingEvent(breakingNotificationContent);
        BridgeInternalPushNotification.dismissNotification(this.tbPushNotificationsManager);
        lastNotificationClickTime = System.currentTimeMillis();
    }

    private void collapseStatusBar(Context applicationContext) {
        Log.d((String)TAG, (String)"collapseStatusBar: ");
        applicationContext.sendBroadcast(new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS"));
    }
}

