/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.shared.EventProperties;
import com.taboola.android.plus.shared.SharedAnalyticsManager;
import java.util.Arrays;
import java.util.List;

public class TBNotificationAnalyticsManager {
    public static final String NOTIFICATION_TYPE_READ_MORE = "Read more notification type";
    private static final String ENABLED_EVENT = "EnabledEvent";
    private static final String DISABLED_EVENT = "DisabledEvent";
    private static final String HOME_SCREEN_DISPLAYED_EVENT = "HSNDisplayed";
    private static final String HOME_SCREEN_TRIGGERED_EVENT = "HSNTriggered";
    private static final String CONTENT_REFRESH_SUCCESSFUL_EVENT = "ContentRefreshScss";
    private static final String CONTENT_REFRESH_FAILED_EVENT = "ContentRefreshFail";
    private static final String RENDER_EVENT_V2 = "RenderEvent_v2";
    private static final String FAILED_TO_RENDER_EVENT_V2 = "RenderFailed";
    private static final String FAILED_TO_LOAD_IMAGE_EVENT = "ImageLoadFail";
    private static final String NEXT_ITEM_EVENT = "NextItemEvent";
    private static final String AUTO_NEXT_ITEM_EVENT_V2 = "AutoNextItem";
    private static final String PREV_ITEM_EVENT = "PrevItemEvent";
    private static final String TAP_NOTIFICATION_EVENT = "TapNotif";
    private static final String DISMISSED_EVENT = "DismissedEvent";
    private static final String UNCAUGHT_EXCEPTION_EVENT = "UncaughtException";
    private static final String NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT = "FrqntCrshBlkdNotif";
    private static final String NOTIFICATION_BLOCKED_BY_CONFIG_EVENT = "CfgBllkdNotif";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED = "UserNotifEgmtPromot";
    private static final String USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED = "UserNotifEgmtDemot";
    private static final String USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP = "usrNotifEgmtGrpSet";
    private static final String INVALID_ITEM_IN_SERVER_RESPONSE = "InvalidItemSvrRes";
    private static final String TAG = TBNotificationAnalyticsManager.class.getSimpleName();
    @NonNull
    private Context appContext;
    @NonNull
    private final TBNotificationLocalStore localStore;
    @NonNull
    private SharedAnalyticsManager sharedAnalyticsManager;

    public TBNotificationAnalyticsManager(@NonNull Context appContext, @NonNull TBNotificationLocalStore localStore, @NonNull SharedAnalyticsManager sharedAnalyticsManager) {
        this.appContext = appContext;
        this.localStore = localStore;
        this.sharedAnalyticsManager = sharedAnalyticsManager;
    }

    public void sendInvalidItemInServerResponseEvent(String errorMessage, String errorDetails, String recommendationItemId) {
        EventProperties eventProperties = new EventProperties.Builder(INVALID_ITEM_IN_SERVER_RESPONSE, false).setErrorMessage(errorMessage).setError(errorDetails).setRecommendationItemId(recommendationItemId).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendEnabledEvent() {
        if (this.localStore.getPreviousState() == 0 || this.localStore.getPreviousState() == -1) {
            EventProperties eventProperties = new EventProperties.Builder(ENABLED_EVENT, true).build();
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setPreviousState(1);
        }
    }

    void sendDisabledEvent() {
        if (this.localStore.getPreviousState() == 1 || this.localStore.getPreviousState() == -1) {
            EventProperties eventProperties = new EventProperties.Builder(DISABLED_EVENT, true).build();
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setPreviousState(0);
        }
    }

    public void sendHomeScreenDisplayedEvent() {
        EventProperties eventProperties = new EventProperties.Builder(HOME_SCREEN_DISPLAYED_EVENT, false).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendHomeScreenTriggeredEvent() {
        EventProperties eventProperties = new EventProperties.Builder(HOME_SCREEN_TRIGGERED_EVENT, false).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendContentRefreshSuccessfulEvent(int responseItemCount) {
        EventProperties eventProperties = new EventProperties.Builder(CONTENT_REFRESH_SUCCESSFUL_EVENT, false).setResponseItemCount(responseItemCount).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
        this.localStore.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    void sendContentRefreshFailedEvent() {
        EventProperties eventProperties = new EventProperties.Builder(CONTENT_REFRESH_FAILED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
        this.localStore.setLastContentRefreshEventTime(System.currentTimeMillis());
    }

    void sendRenderEvent(List<TBPlacement> placements, boolean isTrendingItem) {
        long lastRenderEventTime;
        long lastContentRefreshTime = this.localStore.getLastContentRefreshEventTime();
        if (lastContentRefreshTime > (lastRenderEventTime = this.localStore.getLastRenderEventTimestamp())) {
            EventProperties eventProperties;
            if (placements != null && placements.size() > 1) {
                eventProperties = new EventProperties.Builder(RENDER_EVENT_V2, false).setUiMode(this.localStore.getUiMode()).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
            } else {
                TBPlacement placement = null;
                if (placements != null && !placements.isEmpty()) {
                    placement = placements.get(0);
                }
                eventProperties = new EventProperties.Builder(RENDER_EVENT_V2, false).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
            }
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setLastRenderEventTimestamp(System.currentTimeMillis());
        }
    }

    void sendFailedToRenderEvent(String reason) {
        long lastContentRefreshTime = this.localStore.getLastContentRefreshEventTime();
        long lastFailedToRenderEventTime = this.localStore.getLastFailedToRenderEventTime();
        if (lastFailedToRenderEventTime < lastContentRefreshTime) {
            EventProperties eventProperties = new EventProperties.Builder(FAILED_TO_RENDER_EVENT_V2, false).setError(reason).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setLastFailedToRenderEventTime(System.currentTimeMillis());
        }
    }

    void sendUserAssignedToNotificationEngagementGroupEvent(@NonNull String currentEngagementGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_ASSIGNED_TO_NOTIFICATION_ENGAGEMENT_GROUP, false).setNewNotificationEngagementGroupName(currentEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendUserNotificationEngagementGroupPromotedEvent(@NonNull String previousNotificationEngagementGroupName, @NonNull String newNotificationEngagementGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_PROMOTED, false).setPreviousNotificationEngagementGroupName(previousNotificationEngagementGroupName).setNewNotificationEngagementGroupName(newNotificationEngagementGroupName).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendUserNotificationEngagementGroupDemotedEvent(@NonNull String previousGroupName, @NonNull String newGroupName) {
        EventProperties eventProperties = new EventProperties.Builder(USER_NOTIFICATION_ENGAGEMENT_GROUP_DEMOTED, false).setPreviousNotificationEngagementGroupName(previousGroupName).setNewNotificationEngagementGroupName(newGroupName).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendFailedToLoadImage(@Nullable String url, @NonNull Throwable throwable, @Nullable String notificationType) {
        EventProperties.Builder propertiesBuilder = new EventProperties.Builder(FAILED_TO_LOAD_IMAGE_EVENT, false).setUrl(url).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setError(throwable.getMessage()).setExceptionMessage(throwable.getMessage()).setExceptionStackTrace(Arrays.toString(throwable.getStackTrace()));
        if (notificationType != null) {
            propertiesBuilder.setNotificationType(notificationType);
        }
        this.sharedAnalyticsManager.sendEvent(propertiesBuilder.build());
    }

    void sendNextItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem) {
        EventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = new EventProperties.Builder(NEXT_ITEM_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = new EventProperties.Builder(NEXT_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        }
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendAutoNextEvent() {
        long lastContentRefreshEventTime = this.localStore.getLastContentRefreshEventTime();
        long lastAutoNextItemEventTime = this.localStore.getLastAutoNextItemEventTime();
        if (lastAutoNextItemEventTime < lastContentRefreshEventTime) {
            EventProperties eventProperties = new EventProperties.Builder(AUTO_NEXT_ITEM_EVENT_V2, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setLastAutoNextItemEventTime(System.currentTimeMillis());
        }
    }

    void sendPrevItemEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem) {
        EventProperties eventProperties;
        if (placements != null && placements.size() > 1) {
            eventProperties = new EventProperties.Builder(PREV_ITEM_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPlacement(placements.get(0)).setIsTrendingItem(isTrendingItem).build();
        } else {
            TBPlacement placement = null;
            if (placements != null && !placements.isEmpty()) {
                placement = placements.get(0);
            }
            eventProperties = new EventProperties.Builder(PREV_ITEM_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).build();
        }
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendTapNotificationEvent(@NonNull TBPlacement placement, boolean isClickIgnored, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem, String randomCounter) {
        EventProperties eventProperties = new EventProperties.Builder(TAP_NOTIFICATION_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsClickIgnored(isClickIgnored).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendDismissedEvent(List<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean shouldThrottleDismissEvent, boolean isTrendingItem, String randomCounter) {
        boolean shouldSendDismissEvent = true;
        if (shouldThrottleDismissEvent) {
            shouldSendDismissEvent = this.localStore.getLastRenderEventTimestamp() > this.localStore.getLastDismissEventTimestamp();
        }
        Log.d((String)TAG, (String)("sendDismissedEvent: should send dismiss event " + shouldSendDismissEvent));
        if (shouldSendDismissEvent) {
            EventProperties eventProperties;
            if (placements != null && placements.size() > 1) {
                eventProperties = new EventProperties.Builder(DISMISSED_EVENT, true).setUiMode(this.localStore.getUiMode()).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placements.get(0)).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
            } else {
                TBPlacement placement = null;
                if (placements != null && !placements.isEmpty()) {
                    placement = placements.get(0);
                }
                eventProperties = new EventProperties.Builder(DISMISSED_EVENT, true).setCollapsedNotificationLayout(collapsedNotificationLayout).setExpandedNotificationLayout(expandedNotificationLayout).setPlacement(placement).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setIsTrendingItem(isTrendingItem).setRandomCounter(randomCounter).build();
            }
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setLastDismissEventTimestamp(System.currentTimeMillis());
        }
    }

    void sendNotificationBlockedByConfig() {
        if (!this.localStore.isNotificationBlockedByConfigEventAlreadySend()) {
            EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_BLOCKED_BY_CONFIG_EVENT, false).build();
            this.sharedAnalyticsManager.sendEvent(eventProperties);
            this.localStore.setSendNotificationBlockedByConfigEvent();
        }
    }

    public void sendNotificationBlockedByFrequentCrashes(int exceptionCount) {
        EventProperties eventProperties = new EventProperties.Builder(NOTIFICATION_BLOCKED_BY_FREQUENT_CRASHES_EVENT, false).setExceptionCount(exceptionCount).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendTaboolaApiNotInitializedEvent(String info) {
        this.sharedAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
    }

    public static void sendTaboolaApiNotInitializedEventWithoutContext(String info) {
        SharedAnalyticsManager.sendTaboolaApiNotInitializedEventWithoutContext(info);
    }
}

