/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.killSwitch.KillSwitchUtil;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.SharedAnalyticsManager;
import com.taboola.android.plus.shared.SharedLocalStorage;

class NotificationRenderRestrictionUtil {
    private static final String TAG = NotificationRenderRestrictionUtil.class.getSimpleName();

    NotificationRenderRestrictionUtil() {
    }

    static boolean isBlockedByKillSwitch(@NonNull Context appContext) {
        ConfigManager.CachedSdkConfigContainer cachedSdkConfig = ConfigManager.getCurrentSdkConfig(appContext);
        NotificationConfig notificationConfig = ConfigManager.CachedSdkConfigContainer.getNotificationConfig(cachedSdkConfig);
        if (notificationConfig != null && KillSwitchUtil.isNotificationBlockedByFrequentCrashes(appContext, notificationConfig.getKillSwitchConfig().getFrequentCrashBlockConfig())) {
            Log.i((String)TAG, (String)"Notification is blocked by frequent unhandled exceptions");
            return true;
        }
        return false;
    }

    @RequiresApi(api=21)
    static boolean isNotificationBlocked(@NonNull Context appContext, @NonNull TBNotificationLocalStore localStore, @NonNull SharedLocalStorage sharedLocalStorage, @NonNull TBNotificationAnalyticsManager analyticsManager, @NonNull SharedAnalyticsManager sharedAnalyticsManager, @NonNull NotificationConfig notificationConfig, @NonNull NotificationConfig.SmartNotificationFrequency.EngagementGroup currentGroup) {
        if (!NotificationRenderRestrictionUtil.areNetworkRestrictionsMet(notificationConfig, sharedLocalStorage, appContext)) {
            Log.i((String)TAG, (String)"No wifi connection");
            return true;
        }
        if (NotificationRenderRestrictionUtil.handleNotificationBlockByUser(sharedAnalyticsManager, sharedLocalStorage, appContext)) {
            Log.i((String)TAG, (String)"Not refreshing notification: Notifications are blocked by user");
            return true;
        }
        if (!TBDeviceInfoUtil.isDeviceSupported(notificationConfig)) {
            Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
            analyticsManager.sendNotificationBlockedByConfig();
            return true;
        }
        if (ConditionCheckUtil.isTriggerPerDayMaxCountReached(currentGroup.getMaxNotificationTriggerCountPerDay(), localStore.getCountOfRenderedNotificationsToday())) {
            Log.i((String)TAG, (String)"Notification is not shown because of max trigger times per day set in the config");
            return true;
        }
        if (!ConditionCheckUtil.didMinTriggerIntervalPass(localStore.getLastShownNotificationTimestamp(), currentGroup.getMinTriggerIntervalMs(), System.currentTimeMillis())) {
            Log.i((String)TAG, (String)"Notification is not shown because of min trigger interval set in the config");
            return true;
        }
        if (ConditionCheckUtil.isBlockedByAllowedTimeWindows(currentGroup.getAllowedIntervals())) {
            Log.i((String)TAG, (String)"Notification is not shown because of allow time windows set in the config");
            return true;
        }
        return false;
    }

    static boolean didRefreshIntervalPass(TBNotificationLocalStore localStore, NotificationConfig config) {
        long timeSinceLastRefreshMs = System.currentTimeMillis() - localStore.getRefreshedTimestamp();
        Log.d((String)"render", (String)("refresh: " + config.getRefreshIntervalMs() + "" + (timeSinceLastRefreshMs >= (long)config.getRefreshIntervalMs())));
        return timeSinceLastRefreshMs >= (long)config.getRefreshIntervalMs();
    }

    static boolean handleNotificationBlockByUser(@NonNull SharedAnalyticsManager analyticsManager, @NonNull SharedLocalStorage sharedLocalStorage, @NonNull Context appContext) {
        boolean areNotificationsBlockedByUser = ConditionCheckUtil.areNotificationsBlockedByUser(appContext, "Taboola Content");
        analyticsManager.sendCheckNotificationDisabledStatusEvent(areNotificationsBlockedByUser);
        if (areNotificationsBlockedByUser) {
            if (!sharedLocalStorage.isNotificationBlockBySystem()) {
                analyticsManager.sendNotificationDisabledBySystemEvent();
                sharedLocalStorage.setIsNotificationBlockBySystem(true);
            }
            return true;
        }
        if (sharedLocalStorage.isNotificationBlockBySystem()) {
            analyticsManager.sendNotificationEnabledBySystemEvent();
            sharedLocalStorage.setIsNotificationBlockBySystem(false);
        }
        return false;
    }

    @RequiresApi(api=21)
    private static boolean areNetworkRestrictionsMet(NotificationConfig notificationConfig, SharedLocalStorage sharedLocalStorage, Context appContext) {
        Boolean isWifiOnlyMode = notificationConfig.isWifiOnlyMode();
        if (isWifiOnlyMode == null) {
            isWifiOnlyMode = sharedLocalStorage.isWifiOnlyModeRuntimeFlag();
        }
        if (isWifiOnlyMode.booleanValue()) {
            return ConditionCheckUtil.isWifiConnectionAvailable(appContext);
        }
        return true;
    }
}

