/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.content.Context;
import android.support.annotation.NonNull;
import com.taboola.android.plus.shared.AbstractLocalStorage;

class HomeScreenLocalStorage
extends AbstractLocalStorage {
    private static final String SHARED_PREFS_FILE_NAME = "home_screen_local_storage";
    private static final String IS_HOME_SCREEN_ENABLE_BY_USER = "home_screen_enable_by_user";
    private static final String LAST_RUNNING_HOME_SCREEN_TIME = "last_running_home_screen_time";
    private static final String COUNT_OF_RUNNING_HOME_SCREEN_TODAY = "count_of_running_home_screen_today";

    HomeScreenLocalStorage(@NonNull Context applicationContext) {
        super(applicationContext, SHARED_PREFS_FILE_NAME);
    }

    void setIsHomeScreenEnabledByUser(boolean isEnabled) {
        this.putBoolean(IS_HOME_SCREEN_ENABLE_BY_USER, isEnabled);
    }

    boolean isHomeScreenEnabledByUser() {
        return this.getBoolean(IS_HOME_SCREEN_ENABLE_BY_USER);
    }

    long getLastRunningHomeScreenTime() {
        return this.sharedPreferences.getLong(LAST_RUNNING_HOME_SCREEN_TIME, 0L);
    }

    void setLastRunningHomeScreenTime(long time) {
        this.sharedPreferences.edit().putLong(LAST_RUNNING_HOME_SCREEN_TIME, time).apply();
    }

    int getCountOfRunningHomeScreenToday() {
        return this.sharedPreferences.getInt(COUNT_OF_RUNNING_HOME_SCREEN_TODAY, 0);
    }

    void setCountOfRunningHomeScreenToday(int counter) {
        this.sharedPreferences.edit().putInt(COUNT_OF_RUNNING_HOME_SCREEN_TODAY, counter).apply();
    }
}

