/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.push_notifications;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.push_notifications.models.BreakingNotificationContent;
import com.taboola.android.plus.shared.EventProperties;
import com.taboola.android.plus.shared.SharedAnalyticsManager;
import java.util.Arrays;

public class PushNotificationsAnalyticsManager {
    private static final String PUSH_ANY_RECEIVED_EVENT = "PushReceived";
    private static final String FAILED_TO_INIT_PUSH = "PushInitFail";
    private static final String PUSH_BREAKING_RENDER_EVENT = "PushBrkngRender";
    private static final String PUSH_BREAKING_FAILED_TO_RENDER_EVENT = "PushBrkngRenderFail";
    private static final String TAP_PUSH_BREAKING_EVENT = "TapPushBrkngNotif";
    private static final String PUSH_BREAKING_DISMISSED_EVENT = "PushBrkngDismiss";
    private static final String PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT = "PushBrkngOpenScss";
    private static final String INVALID_ANY_PUSH_NOTIFICATION_ITEM = "InvalidPushItem";
    @NonNull
    private Context appContext;
    @NonNull
    private SharedAnalyticsManager sharedAnalyticsManager;

    public PushNotificationsAnalyticsManager(@NonNull Context appContext, @NonNull SharedAnalyticsManager sharedAnalyticsManager) {
        this.appContext = appContext;
        this.sharedAnalyticsManager = sharedAnalyticsManager;
    }

    public void sendPushReceivedEvent(@Nullable String title, @Nullable String messageId, @Nullable String pushType) {
        EventProperties eventProperties = new EventProperties.Builder(PUSH_ANY_RECEIVED_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(title).setMessageId(messageId).setPushType(pushType).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendPushBreakingRenderEvent(BreakingNotificationContent breakingNotificationContent) {
        EventProperties eventProperties = new EventProperties.Builder(PUSH_BREAKING_RENDER_EVENT, false).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(breakingNotificationContent.getTitle()).setMessageId(breakingNotificationContent.getId()).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendPushBreakingFailedToRenderEvent(BreakingNotificationContent breakingNotificationContent, String errorMessage) {
        EventProperties eventProperties = new EventProperties.Builder(PUSH_BREAKING_FAILED_TO_RENDER_EVENT, false).setError(errorMessage).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(breakingNotificationContent.getTitle()).setMessageId(breakingNotificationContent.getId()).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendInitFailedEvent(Exception e) {
        EventProperties eventProperties = new EventProperties.Builder(FAILED_TO_INIT_PUSH, false).setError(e.getMessage()).setExceptionMessage(e.getMessage()).setExceptionStackTrace(Arrays.toString(e.getStackTrace())).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendTapPushBreakingEvent(BreakingNotificationContent breakingNotificationContent) {
        EventProperties eventProperties = new EventProperties.Builder(TAP_PUSH_BREAKING_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(breakingNotificationContent.getTitle()).setMessageId(breakingNotificationContent.getId()).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    public void sendPushBreakingOpenedSuccessfullyEvent(BreakingNotificationContent breakingNotificationContent) {
        EventProperties eventProperties = new EventProperties.Builder(PUSH_BREAKING_OPENED_SUCCESSFULLY_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(breakingNotificationContent.getTitle()).setMessageId(breakingNotificationContent.getId()).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendPushBreakingDismissedEvent(BreakingNotificationContent breakingNotificationContent) {
        EventProperties eventProperties = new EventProperties.Builder(PUSH_BREAKING_DISMISSED_EVENT, true).setIsDeviceLocked(TBDeviceInfoUtil.isDeviceLocked(this.appContext)).setPushNotificationTitle(breakingNotificationContent.getTitle()).setMessageId(breakingNotificationContent.getId()).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendInvalidPushItemEvent(String errorMessage, String errorDetails, String messageId) {
        EventProperties eventProperties = new EventProperties.Builder(INVALID_ANY_PUSH_NOTIFICATION_ITEM, false).setErrorMessage(errorMessage).setError(errorDetails).setMessageId(messageId).build();
        this.sharedAnalyticsManager.sendEvent(eventProperties);
    }

    void sendCheckNotificationDisabledStatusEvent(boolean isBlocked) {
        this.sharedAnalyticsManager.sendCheckNotificationDisabledStatusEvent(isBlocked);
    }

    void sendNotificationDisabledBySystemEvent() {
        this.sharedAnalyticsManager.sendNotificationDisabledBySystemEvent();
    }

    void sendNotificationEnabledBySystemEvent() {
        this.sharedAnalyticsManager.sendNotificationEnabledBySystemEvent();
    }

    void sendTaboolaApiNotInitializedEvent(String info) {
        this.sharedAnalyticsManager.sendTaboolaApiNotInitializedEvent(info);
    }
}

