/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taboola.android.plus.notification.NotificationConfig;

public class NotificationReadMoreConfig {
    private static final String TAG = NotificationReadMoreConfig.class.getSimpleName();
    private static final String LAYOUT_COLLAPSED_READ_MORE_STRING = "layout_collapsed_read_more";
    private static final String LAYOUT_EXPANDED_READ_MORE_STRING = "layout_expanded_read_more";
    private CollapsedLayout collapsedLayout;
    private ExpandedLayout expandedLayout;
    private NotificationConfig.LayoutSpecificConfigs layoutSpecificConfigs;
    private boolean shouldShowReadMore;

    static NotificationReadMoreConfig determineNotificationLayout(@NonNull NotificationConfig.ReadMoreConfig config, @IntRange(from=1L) int availableItemCount) {
        if (availableItemCount < 1) {
            throw new IllegalArgumentException("Item count must be greater than 0");
        }
        NotificationReadMoreConfig notificationReadMoreConfig = new NotificationReadMoreConfig();
        notificationReadMoreConfig.setLayoutSpecificConfigs(config.getLayoutSpecificConfigs());
        notificationReadMoreConfig.setShouldShowReadMore(config.shouldShowReadMore());
        CollapsedLayout preferredCollapsedLayout = CollapsedLayout.parseLayout(config.getPreferredCollapsedLayout());
        ExpandedLayout preferredExpandedLayout = ExpandedLayout.parseLayout(config.getPreferredExpandedLayout());
        if (preferredCollapsedLayout.getMinNumberOfItems() <= availableItemCount && preferredExpandedLayout.getMinNumberOfItems() <= availableItemCount) {
            notificationReadMoreConfig.setCollapsedLayout(preferredCollapsedLayout);
            notificationReadMoreConfig.setExpandedLayout(preferredExpandedLayout);
            return notificationReadMoreConfig;
        }
        notificationReadMoreConfig.setCollapsedLayout(CollapsedLayout.getDefaultLayout());
        notificationReadMoreConfig.setExpandedLayout(ExpandedLayout.getDefaultLayout());
        return notificationReadMoreConfig;
    }

    public int getMinNumberOfItems() {
        return Math.min(this.collapsedLayout.getMinNumberOfItems(), this.collapsedLayout.getMinNumberOfItems());
    }

    public int getMaxNumberOfItems() {
        return Math.max(this.collapsedLayout.getMaxNumberOfItems(), this.expandedLayout.getMaxNumberOfItems());
    }

    public CollapsedLayout getCollapsedLayout() {
        return this.collapsedLayout;
    }

    public void setCollapsedLayout(CollapsedLayout collapsedLayout) {
        this.collapsedLayout = collapsedLayout;
    }

    public ExpandedLayout getExpandedLayout() {
        return this.expandedLayout;
    }

    public void setExpandedLayout(ExpandedLayout expandedLayout) {
        this.expandedLayout = expandedLayout;
    }

    public NotificationConfig.LayoutSpecificConfigs getLayoutSpecificConfigs() {
        return this.layoutSpecificConfigs;
    }

    public void setLayoutSpecificConfigs(NotificationConfig.LayoutSpecificConfigs layoutSpecificConfigs) {
        this.layoutSpecificConfigs = layoutSpecificConfigs;
    }

    public void setShouldShowReadMore(boolean shouldShowReadMore) {
        this.shouldShowReadMore = shouldShowReadMore;
    }

    public static enum ExpandedLayout {
        ReadMore("layout_expanded_read_more", 1, 1);

        private String LayoutStringKey;
        private int minNumberOfItems;
        private int maxNumberOfItems;

        static ExpandedLayout parseLayout(String preferredExpandedLayoutString) {
            switch (preferredExpandedLayoutString) {
                case "layout_expanded_read_more": {
                    return ReadMore;
                }
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Expanded layout key. Using default");
            return ExpandedLayout.getDefaultLayout();
        }

        private ExpandedLayout(String layoutStringKey, int minNumberOfItems, int maxNumberOfItems) {
            this.LayoutStringKey = layoutStringKey;
            this.minNumberOfItems = minNumberOfItems;
            this.maxNumberOfItems = maxNumberOfItems;
        }

        public String getLayoutStringKey() {
            return this.LayoutStringKey;
        }

        public int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        public static ExpandedLayout getDefaultLayout() {
            return ReadMore;
        }

        public String toString() {
            return this.getLayoutStringKey();
        }
    }

    public static enum CollapsedLayout {
        ReadMore("layout_collapsed_read_more", 1, 1);

        private String LayoutStringKey;
        private int minNumberOfItems;
        private int maxNumberOfItems;

        static CollapsedLayout parseLayout(String preferredCollapsedLayoutString) {
            switch (preferredCollapsedLayoutString) {
                case "layout_collapsed_read_more": {
                    return ReadMore;
                }
            }
            Log.e((String)TAG, (String)"parseLayout: unknown Collapsed layout key. Using default");
            return CollapsedLayout.getDefaultLayout();
        }

        private CollapsedLayout(String layoutStringKey, int minNumberOfItems, int maxNumberOfItems) {
            this.LayoutStringKey = layoutStringKey;
            this.minNumberOfItems = minNumberOfItems;
            this.maxNumberOfItems = maxNumberOfItems;
        }

        public String getLayoutStringKey() {
            return this.LayoutStringKey;
        }

        public int getMinNumberOfItems() {
            return this.minNumberOfItems;
        }

        public int getMaxNumberOfItems() {
            return this.maxNumberOfItems;
        }

        public static CollapsedLayout getDefaultLayout() {
            return ReadMore;
        }

        public String toString() {
            return this.getLayoutStringKey();
        }
    }
}

