/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.homeScreenNews;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import com.google.gson.annotations.SerializedName;
import com.taboola.android.plus.shared.AllowedTimeWindows;
import java.util.ArrayList;
import java.util.List;

public class HomeScreenConfig
implements Parcelable {
    public static final String HOME_SCREEN_CONFIG = "homeScreenConfig";
    public static final String IS_HOME_SCREEN_FEATURE_ENABLED = "isHomeScreenFeatureEnabled";
    public static final String HOME_SCREEN_REFRESH_INTERVAL_MS = "refreshIntervalMs";
    public static final String HOME_SCREEN_TRIGGER_INTERVAL_MS = "minTriggerIntervalMs";
    public static final String HOME_SCREEN_TRIGGER_PER_DAY = "maxTriggerCountPerDay";
    public static final String HOME_SCREEN_ALLOWED_TIME_WINDOWS = "allowedTimeWindows";
    private static final String URL_TO_OPEN = "urlToOpen";
    public static final String PLACEMENT_TO_OPEN = "placementToOpen";
    @SerializedName(value="refreshIntervalMs")
    private long homeScreenRefreshIntervalMs;
    @SerializedName(value="placementToOpen")
    @NonNull
    @Size(min=0L)
    private String placementToOpen = "";
    @SerializedName(value="urlToOpen")
    @NonNull
    @Size(min=0L)
    private String urlToOpen = "";
    @SerializedName(value="minTriggerIntervalMs")
    private long homeScreenTriggerIntervalMs;
    @SerializedName(value="maxTriggerCountPerDay")
    private int maxTriggerCountPerDay;
    @SerializedName(value="isHomeScreenFeatureEnabled")
    private boolean isHomeScreenFeatureEnabled;
    @SerializedName(value="allowedTimeWindows")
    @NonNull
    @Size(min=0L)
    private List<AllowedTimeWindows> allowedIntervals = new ArrayList<AllowedTimeWindows>();
    public static final Parcelable.Creator<HomeScreenConfig> CREATOR = new Parcelable.Creator<HomeScreenConfig>(){

        public HomeScreenConfig createFromParcel(Parcel source) {
            return new HomeScreenConfig(source);
        }

        public HomeScreenConfig[] newArray(int size) {
            return new HomeScreenConfig[size];
        }
    };

    public HomeScreenConfig() {
    }

    protected HomeScreenConfig(Parcel in) {
        this.homeScreenRefreshIntervalMs = in.readLong();
        this.placementToOpen = in.readString();
        this.urlToOpen = in.readString();
        this.homeScreenTriggerIntervalMs = in.readLong();
        this.maxTriggerCountPerDay = in.readInt();
        this.isHomeScreenFeatureEnabled = in.readByte() != 0;
        ArrayList allowedIntervalsFromCreator = in.createTypedArrayList(AllowedTimeWindows.CREATOR);
        this.allowedIntervals = allowedIntervalsFromCreator != null ? allowedIntervalsFromCreator : new ArrayList();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.homeScreenRefreshIntervalMs);
        dest.writeString(this.placementToOpen);
        dest.writeString(this.urlToOpen);
        dest.writeLong(this.homeScreenTriggerIntervalMs);
        dest.writeInt(this.maxTriggerCountPerDay);
        dest.writeByte(this.isHomeScreenFeatureEnabled ? (byte)1 : 0);
        dest.writeTypedList(this.allowedIntervals);
    }

    public long getHomeScreenRefreshIntervalMs() {
        return this.homeScreenRefreshIntervalMs;
    }

    public int getMaxTriggerCountPerDay() {
        return this.maxTriggerCountPerDay;
    }

    @Size(min=0L)
    @NonNull
    public String getPlacementToOpen() {
        return this.placementToOpen;
    }

    @NonNull
    @Size(min=0L)
    public String getUrlToOpen() {
        return this.urlToOpen;
    }

    public boolean isHomeScreenFeatureEnabled() {
        return this.isHomeScreenFeatureEnabled;
    }

    @NonNull
    @Size(min=0L)
    public List<AllowedTimeWindows> getAllowedIntervals() {
        return this.allowedIntervals;
    }

    public long getHomeScreenTriggerIntervalMs() {
        return this.homeScreenTriggerIntervalMs;
    }

    public int describeContents() {
        return 0;
    }
}

