/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationContentState;
import com.taboola.android.plus.notification.NotificationItem;
import com.taboola.android.plus.notification.NotificationRemoteRepository;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationContentCallback;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationUtil;
import com.taboola.android.plus.shared.TBNotificationExecutors;
import com.taboola.android.utils.UrlUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

class TBNotificationRepository {
    private static final String TAG = TBNotificationRepository.class.getSimpleName();
    private final NotificationRemoteRepository contentManager;
    private final TBNotificationLocalStore store;
    private final TBNotificationAnalyticsManager analyticsManager;
    private final TBNotificationExecutors executors;

    TBNotificationRepository(NotificationRemoteRepository contentManager, TBNotificationLocalStore store, TBNotificationAnalyticsManager analyticsManager, TBNotificationExecutors executors) {
        this.contentManager = contentManager;
        this.store = store;
        this.analyticsManager = analyticsManager;
        this.executors = executors;
    }

    void loadNewContent(@NonNull ContentConfig contentConfig, final @NonNull NotificationConfig notificationConfig, @NonNull List<String> contentCategories, int imageWidth, int imageHeight, final @NonNull TBNotificationContentCallback callback) {
        int itemsBatchSizePerCategory = notificationConfig.getItemsBatchSize();
        String readMorePlacementName = null;
        if (notificationConfig.getReadMoreConfig().shouldShowReadMore()) {
            readMorePlacementName = notificationConfig.getReadMoreConfig().getPlacementName();
        }
        this.contentManager.getNotificationContent(contentConfig, notificationConfig.getPlacementName(), contentCategories, itemsBatchSizePerCategory, readMorePlacementName, imageWidth, imageHeight, this.analyticsManager, new NotificationRemoteRepository.OnNotificationContentFetchedCallback(){

            @Override
            public void onNotificationContentFetched(@NonNull TBContent notificationData) {
                TBNotificationRepository.this.store.setRefreshedTimestamp(System.currentTimeMillis());
                if (!TaboolaApi.getInstance().isInitialized()) {
                    String info = "TBNotificationRepository: loadNewContent: getNotificationContent(): onNotificationContentFetched()";
                    TBNotificationAnalyticsManager.sendTaboolaApiNotInitializedEventWithoutContext(info);
                }
                List<Integer> trendingItemsIds = TBNotificationUtil.generateTrendingItemIdsList(notificationData.getContentSize(), notificationConfig.getTrendingItemsCount());
                for (Integer trendingId : trendingItemsIds) {
                    notificationData.getItems().get(trendingId).setPlacementTrending(true);
                }
                TBNotificationRepository.this.setNotificationContent(notificationData);
                TBNotificationRepository.this.analyticsManager.sendContentRefreshSuccessfulEvent(notificationData.getContentSize());
                callback.onLoadedContent(notificationData);
            }

            @Override
            public void onNotificationContentFailed(Throwable throwable) {
                TBNotificationRepository.this.analyticsManager.sendContentRefreshFailedEvent();
                callback.onFailedToLoadContent(throwable);
            }
        });
    }

    void deletePlacement(final String imageUriToDelete, final OnDeletePlacementCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = TBNotificationRepository.this.store.getContent();
                final NotificationContentState contentState = TBNotificationRepository.this.store.getNotificationContentState();
                String zeroSizeUrlToDelete = UrlUtils.replaceImageSizeInUrl((String)imageUriToDelete, (int)0, (int)0);
                if (tbContent != null) {
                    ArrayList<NotificationItem> notificationItems = tbContent.getItems();
                    Iterator<NotificationItem> itemIterator = notificationItems.iterator();
                    while (itemIterator.hasNext()) {
                        NotificationItem notificationItem = itemIterator.next();
                        TBRecommendationItem item = (TBRecommendationItem)notificationItem.getPlacement().getItems().get(0);
                        String zeroSizeImageUri = TBNotificationUtil.getItemThumbnailUrl(item, 0, 0);
                        if (!zeroSizeUrlToDelete.equals(zeroSizeImageUri)) continue;
                        itemIterator.remove();
                        TBNotificationRepository.this.setNotificationContent(tbContent);
                        Log.d((String)TAG, (String)"deletePlacement by imageUri: found and deleted invalid item");
                        TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (contentState != null) {
                                    callback.onDeleted(tbContent, contentState);
                                }
                            }
                        });
                        return;
                    }
                    Log.d((String)TAG, (String)"deletePlacement by imageUri: deletion failed: didn't find an item (it's possible that item was already deleted by a different thumbnail fail)");
                }
            }
        });
    }

    void deletePlacement(final TBPlacement placementToDelete, final OnDeletePlacementCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent tbContent = TBNotificationRepository.this.store.getContent();
                final NotificationContentState contentState = TBNotificationRepository.this.store.getNotificationContentState();
                if (tbContent != null && tbContent.getItems() != null && !tbContent.getItems().isEmpty()) {
                    ArrayList<NotificationItem> notificationItems = tbContent.getItems();
                    Iterator<NotificationItem> itemIterator = notificationItems.iterator();
                    while (itemIterator.hasNext()) {
                        NotificationItem notificationItem = itemIterator.next();
                        TBPlacement tbPlacement = notificationItem.getPlacement();
                        if (!TBNotificationRepository.this.arePlacementsEqual(placementToDelete, tbPlacement)) continue;
                        itemIterator.remove();
                        TBNotificationRepository.this.setNotificationContent(tbContent);
                        TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                if (contentState != null) {
                                    callback.onDeleted(tbContent, contentState);
                                }
                            }
                        });
                        return;
                    }
                    Log.w((String)TAG, (String)"deletePlacement by item id : deletion failed: didn't find an item");
                } else {
                    Log.w((String)TAG, (String)"deletePlacement by item id : deletion failed: didn't find an item");
                }
            }
        });
    }

    private boolean arePlacementsEqual(TBPlacement placement1, TBPlacement placement2) {
        String firstId = (String)((TBRecommendationItem)placement1.getItems().get(0)).getExtraDataMap().get("id");
        String secondId = (String)((TBRecommendationItem)placement2.getItems().get(0)).getExtraDataMap().get("id");
        return firstId.equals(secondId);
    }

    private String getImageUri(TBPlacement tbPlacement) {
        String rawThumbnail = (String)((TBRecommendationItem)tbPlacement.getItems().get(0)).getExtraDataMap().get("thumbnail");
        try {
            return new JSONArray(rawThumbnail).getJSONObject(0).getString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    void fetchCurrentData(final FetchCurrentDataCallback callback) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                final TBContent content = TBNotificationRepository.this.store.getContent();
                final NotificationContentState notificationContentState = TBNotificationRepository.this.store.getNotificationContentState();
                TBNotificationRepository.this.executors.getMainThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onFetched(content, notificationContentState);
                    }
                });
            }
        });
    }

    void setNotificationState(final @Nullable NotificationContentState notificationContentState) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationRepository.this.store.setNotificationContentState(notificationContentState);
            }
        });
    }

    private void setNotificationContent(final @Nullable TBContent content) {
        this.executors.getDiskIOExecutor().execute(new Runnable(){

            @Override
            public void run() {
                TBNotificationRepository.this.store.setContent(content);
            }
        });
    }

    public static interface OnDeletePlacementCallback {
        public void onDeleted(@NonNull TBContent var1, @NonNull NotificationContentState var2);
    }

    public static interface FetchCurrentDataCallback {
        public void onFetched(@Nullable TBContent var1, @Nullable NotificationContentState var2);
    }
}

