/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.taboola.android.MonitorManager;
import com.taboola.android.monitor.TBAbsSdkFeature;
import com.taboola.android.monitor.TBAuthenticationPlus;
import com.taboola.android.monitor.TBPlusFeaturesParams;
import com.taboola.android.monitor.TBSdkFeature;
import com.taboola.android.monitor.TBSuspendMonitor;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.utils.Logger;
import com.taboola.android.utils.MonitorUtils;
import com.taboola.android.utils.SdkDetailsHelper;
import com.taboola.android.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

class MonitorHelper {
    private static final String TAG = "MonitorHelper";

    MonitorHelper() {
    }

    static void initSdkMonitor(Context appCtx) {
        try {
            if (MonitorUtils.isSdkMonitorInstalled((Context)appCtx)) {
                Messenger monitorMessenger = new Messenger((Handler)new MonitorHandler());
                MonitorManager monitorManager = MonitorManager.getInstance((String)SdkDetailsHelper.getApplicationName((Context)appCtx));
                monitorManager.bindService(appCtx);
                monitorManager.sendGetFeatureSet(monitorMessenger, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Parser {
        static final String FEATURE_PASSWORD = "376c21021b2800b444ae9214a5b251460c04490611dadf1585987e12ce0b6c21";
        private static final String TAG = "Parser";
        static List<Class<? extends TBAbsSdkFeature>> CLASS_LIST = new ArrayList<Class<? extends TBAbsSdkFeature>>();

        private Parser() {
        }

        private static SparseArray<TBSdkFeature> parseSdkFeatures(String sdkFeaturesString) {
            SparseArray sdkFeatures = new SparseArray();
            boolean isAuthenticated = false;
            try {
                JSONObject sdkFeaturesJsonObject = new JSONObject(sdkFeaturesString);
                for (Class<? extends TBAbsSdkFeature> clazz : CLASS_LIST) {
                    try {
                        int keyInt = clazz.getField("KEY").getInt(null);
                        JSONObject sdkFeatureJsonObject = sdkFeaturesJsonObject.optJSONObject(String.valueOf(keyInt));
                        if (sdkFeatureJsonObject == null) continue;
                        TBAbsSdkFeature tbSdkFeature = clazz.newInstance();
                        tbSdkFeature.initFromJSON(sdkFeatureJsonObject);
                        sdkFeatures.put(keyInt, (Object)tbSdkFeature);
                    }
                    catch (Exception e) {
                        Logger.e((String)TAG, (String)e.toString(), (Throwable)e);
                    }
                }
                TBAuthenticationPlus tbAuthentication = (TBAuthenticationPlus)((Object)sdkFeatures.get(0));
                String password = tbAuthentication != null ? tbAuthentication.getPassword() : "";
                String keyHash = SecurityUtils.getSHA256((String)password).toLowerCase();
                isAuthenticated = TextUtils.equals((CharSequence)FEATURE_PASSWORD, (CharSequence)keyHash);
                sdkFeatures.remove(0);
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
            if (!isAuthenticated) {
                sdkFeatures.clear();
                TBSuspendMonitor tbSuspendMonitor = new TBSuspendMonitor();
                tbSuspendMonitor.setShouldSuspend(true);
                sdkFeatures.put(2, (Object)tbSuspendMonitor);
            }
            return sdkFeatures;
        }

        static {
            CLASS_LIST.add(TBAuthenticationPlus.class);
            CLASS_LIST.add(TBPlusFeaturesParams.class);
        }
    }

    private static class MonitorHandler
    extends Handler {
        private MonitorHandler() {
        }

        public void handleMessage(Message msg) {
            Bundle data = msg.getData();
            switch (msg.what) {
                case 232: {
                    try {
                        String sdkFeaturesString = data.getString("MONITOR_FEATURE_SET_LIST");
                        if (TextUtils.isEmpty((CharSequence)sdkFeaturesString)) break;
                        SparseArray sdkFeatures = Parser.parseSdkFeatures(sdkFeaturesString);
                        TaboolaPlus.setSdkFeatures((SparseArray<TBSdkFeature>)sdkFeatures);
                        break;
                    }
                    catch (Exception e) {
                        Log.e((String)MonitorHelper.TAG, (String)"error while try to parse sdk features", (Throwable)e);
                    }
                }
            }
        }
    }
}

