/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.taboola.android.global_components.advertisingid.AdvertisingIdInfo;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.monitor.ConfigHelper;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import com.taboola.android.plus.shared.SharedLocalStorage;
import com.taboola.android.plus.shared.network.Callback;
import com.taboola.android.plus.shared.network.handlers.ConfigHandler;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class ConfigManager {
    private static final String TAG = ConfigManager.class.getSimpleName();
    public static final String MINIMAL_SUPPORTED_CONFIG_VERSION = "1.2.3";
    private static final String SHARED_PREFS_KEY = "com.taboola.android.reader.SHARED_PREFERENCES_KEY";
    private static final String CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY = "CURRENT_SDK_CONFIG_JSON_v1_2";
    private static final String NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY = "NEW_SDK_CONFIG_JSON_v1_2";
    private static final String CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY = "CURRENT_LANGUAGES_CONFIG_JSON";
    private static final String NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY = "NEW_LANGUAGES_CONFIG_JSON";

    public static void getCurrentConfigs(@NonNull Context applicationContext, @NonNull String publisherName, @NonNull String configId, @NonNull OnGetAllConfigsCallback callback) {
        CachedSdkConfigContainer configContainer = ConfigManager.getCurrentSdkConfig(applicationContext);
        SdkPlusConfig sdkPlusConfig = configContainer != null ? configContainer.getSdkPlusConfig() : null;
        CachedLanguagesConfigContainer languagesConfigContainer = ConfigManager.getCurrentLanguagesConfig(applicationContext);
        if (sdkPlusConfig != null && languagesConfigContainer != null && ConfigManager.isConfigVersionSupported(MINIMAL_SUPPORTED_CONFIG_VERSION, sdkPlusConfig.getConfigVersion())) {
            callback.onConfigsFetched(sdkPlusConfig, languagesConfigContainer.getLanguagesConfig());
        } else {
            Log.d((String)TAG, (String)"getCurrentConfigs: config cache is empty or expired, getting new configs");
            ConfigManager.getAllConfigsFromRemote(applicationContext, publisherName, configId, callback);
        }
    }

    static void getNewConfigs(@NonNull Context applicationContext, @NonNull String publisherName, @NonNull String configId, boolean shouldApplyNewConfig, @NonNull OnGetAllConfigsCallback callback) {
        CachedSdkConfigContainer configContainer = ConfigManager.getNewSdkConfig(applicationContext);
        CachedLanguagesConfigContainer languagesConfigContainer = ConfigManager.getNewLanguagesConfig(applicationContext);
        if (configContainer != null && languagesConfigContainer != null && !configContainer.didExpire() && !languagesConfigContainer.didExpire() && ConfigManager.isConfigVersionSupported(MINIMAL_SUPPORTED_CONFIG_VERSION, configContainer.getSdkPlusConfig().getConfigVersion())) {
            if (shouldApplyNewConfig) {
                ConfigManager.setCurrentSdkConfig(applicationContext, configContainer);
                ConfigManager.setCurrentLanguagesConfig(applicationContext, languagesConfigContainer);
            }
            callback.onConfigsFetched(configContainer.getSdkPlusConfig(), languagesConfigContainer.getLanguagesConfig());
        } else {
            Log.d((String)TAG, (String)"getNewConfigs: config cache is empty or expired, getting new configs");
            ConfigManager.getAllConfigsFromRemote(applicationContext, publisherName, configId, callback);
        }
    }

    private static void getAllConfigsFromRemote(final @NonNull Context applicationContext, @NonNull String publisherName, @NonNull String configId, final @NonNull OnGetAllConfigsCallback callback) {
        new GetAllConfigsFromRemoteInteractor().execute(applicationContext, publisherName, configId, new OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                Log.d((String)TAG, (String)"getCurrentConfigs: successfully fetched configs from remote");
                CachedSdkConfigContainer configContainer = new CachedSdkConfigContainer(System.currentTimeMillis(), config);
                CachedLanguagesConfigContainer languagesConfigContainer = new CachedLanguagesConfigContainer(System.currentTimeMillis(), languagesConfig);
                ConfigManager.setCurrentSdkConfig(applicationContext, configContainer);
                ConfigManager.setNewSdkConfig(applicationContext, configContainer);
                ConfigManager.setCurrentLanguagesConfig(applicationContext, languagesConfigContainer);
                ConfigManager.setNewLanguagesConfig(applicationContext, languagesConfigContainer);
                if (ConfigManager.isConfigVersionSupported(ConfigManager.MINIMAL_SUPPORTED_CONFIG_VERSION, configContainer.getSdkPlusConfig().getConfigVersion())) {
                    callback.onConfigsFetched(config, languagesConfig);
                } else {
                    Throwable throwable = new Throwable("minimal config version supported by sdk+ is higher than currently available on the server");
                    Log.e((String)TAG, (String)("error while getting configs from remote: " + throwable.getMessage()));
                    callback.onConfigsFailed(throwable);
                }
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("failed to get configs from remote: " + throwable.getMessage()));
                callback.onConfigsFailed(throwable);
            }
        });
    }

    public static void triggerAsyncConfigsUpdate(final Context applicationContext, String publisherName, String configId) {
        Callback<SdkPlusConfig> getSdkConfigCallback = new Callback<SdkPlusConfig>(){

            @Override
            public void onResponse(SdkPlusConfig response, String message) {
                Log.d((String)TAG, (String)"triggerAsyncConfigUpdate: onResponse successful. ");
                ConfigManager.setNewSdkConfig(applicationContext, new CachedSdkConfigContainer(System.currentTimeMillis(), response));
            }

            @Override
            public void onFailure(Throwable t) {
                Log.e((String)TAG, (String)("triggerAsyncConfigUpdate: onFailure: failed to refresh config. " + t.getMessage()), (Throwable)t);
            }
        };
        Callback<LanguagesConfig> getLanguagesConfigCallback = new Callback<LanguagesConfig>(){

            @Override
            public void onResponse(LanguagesConfig response, String message) {
                Log.d((String)TAG, (String)"triggerAsyncLanguagesConfigUpdate: onResponse successful. ");
                ConfigManager.setNewLanguagesConfig(applicationContext, new CachedLanguagesConfigContainer(System.currentTimeMillis(), response));
            }

            @Override
            public void onFailure(Throwable t) {
                Log.e((String)TAG, (String)("triggerAsyncLanguagesConfigUpdate: onFailure: failed to refresh config. " + t.getMessage()), (Throwable)t);
            }
        };
        ConfigManager.getConfigWithDeviceId(applicationContext, publisherName, configId, getSdkConfigCallback, getLanguagesConfigCallback);
    }

    public static void clearConfigCache(Context appContext) {
        ConfigManager.setCurrentSdkConfig(appContext, null);
        ConfigManager.setNewSdkConfig(appContext, null);
        ConfigManager.setCurrentLanguagesConfig(appContext, null);
        ConfigManager.setNewLanguagesConfig(appContext, null);
    }

    private static void setCurrentSdkConfig(Context appContext, CachedSdkConfigContainer config) {
        Gson gsonWithAdapter = new GsonBuilder().registerTypeAdapter(LocalizationStrings.class, (Object)new LocalizationStrings.LocalizationStringsJsonAdapter()).create();
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY, gsonWithAdapter.toJson((Object)config)).apply();
    }

    private static void setNewSdkConfig(Context appContext, CachedSdkConfigContainer config) {
        SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(appContext);
        sharedLocalStorage.setPreviousConfig(sharedLocalStorage.getCurrentConfig());
        if (config != null) {
            sharedLocalStorage.setCurrentConfig(config.sdkPlusConfig);
        } else {
            sharedLocalStorage.setCurrentConfig(null);
        }
        ConfigManager.updateAnalyticsEnabledState(appContext);
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY, new Gson().toJson((Object)config)).apply();
    }

    private static void updateAnalyticsEnabledState(@NonNull Context context) {
        SharedLocalStorage sharedLocalStorage = new SharedLocalStorage(context);
        SdkPlusConfig previousConfig = sharedLocalStorage.getPreviousConfigObj();
        SdkPlusConfig currentConfig = sharedLocalStorage.getCurrentConfigObj();
        if (currentConfig == null) {
            sharedLocalStorage.setAmplitudeAnalyticsEnabled(false);
            sharedLocalStorage.setKustoAnalyticsEnabled(false);
            return;
        }
        float currentAmplitudeReportFrequency = currentConfig.getContentConfig().getAmplitudeReportFrequency();
        float currentKustoReportFrequency = currentConfig.getContentConfig().getKustoReportFrequency();
        if (previousConfig == null || previousConfig.getContentConfig().getAmplitudeReportFrequency() != currentAmplitudeReportFrequency) {
            sharedLocalStorage.setAmplitudeAnalyticsEnabled(ConfigManager.shouldReportToAmplitude(currentAmplitudeReportFrequency));
        }
        if (previousConfig == null || previousConfig.getContentConfig().getKustoReportFrequency() != currentKustoReportFrequency) {
            sharedLocalStorage.setKustoAnalyticsEnabled(ConfigManager.shouldReportToKusto(currentKustoReportFrequency));
        }
    }

    private static boolean shouldReportToKusto(float kustoReportFrequency) {
        return (float)new Random().nextInt(100) <= kustoReportFrequency * 100.0f;
    }

    private static boolean shouldReportToAmplitude(float amplitudeReportFrequency) {
        return (float)new Random().nextInt(100) <= amplitudeReportFrequency * 100.0f;
    }

    private static void setCurrentLanguagesConfig(Context appContext, CachedLanguagesConfigContainer config) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, new Gson().toJson((Object)config)).apply();
    }

    private static void setNewLanguagesConfig(Context appContext, CachedLanguagesConfigContainer config) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        preferences.edit().putString(NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, new Gson().toJson((Object)config)).apply();
    }

    @Nullable
    public static CachedSdkConfigContainer getCurrentSdkConfig(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String configJson = preferences.getString(CURRENT_SDK_CONFIG_JSON_SHARED_PREFS_KEY, null);
        return (CachedSdkConfigContainer)new Gson().fromJson(configJson, CachedSdkConfigContainer.class);
    }

    @Nullable
    private static CachedSdkConfigContainer getNewSdkConfig(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String configJson = preferences.getString(NEW_SDK_CONFIG_JSON_SHARED_PREFS_KEY, null);
        return (CachedSdkConfigContainer)new Gson().fromJson(configJson, CachedSdkConfigContainer.class);
    }

    @Nullable
    private static CachedLanguagesConfigContainer getCurrentLanguagesConfig(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String configJson = preferences.getString(CURRENT_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, null);
        return (CachedLanguagesConfigContainer)new Gson().fromJson(configJson, CachedLanguagesConfigContainer.class);
    }

    @Nullable
    private static CachedLanguagesConfigContainer getNewLanguagesConfig(Context appContext) {
        SharedPreferences preferences = appContext.getSharedPreferences(SHARED_PREFS_KEY, 0);
        String configJson = preferences.getString(NEW_LANGUAGES_CONFIG_JSON_SHARED_PREFS_KEY, null);
        return (CachedLanguagesConfigContainer)new Gson().fromJson(configJson, CachedLanguagesConfigContainer.class);
    }

    static boolean isConfigVersionSupported(@NonNull String minimalSupportedVersionString, @NonNull String availableVersionString) {
        if (availableVersionString.length() == 0) {
            return false;
        }
        if (availableVersionString.equalsIgnoreCase(minimalSupportedVersionString)) {
            return true;
        }
        int suffixStartIndex = availableVersionString.indexOf("-");
        if (suffixStartIndex == -1) {
            suffixStartIndex = availableVersionString.length();
        }
        String availableVersionWithoutSuffix = availableVersionString.substring(0, suffixStartIndex);
        String[] minimalVersionSplit = minimalSupportedVersionString.split("\\.");
        String[] availableVersionSplit = availableVersionWithoutSuffix.split("\\.");
        if (availableVersionSplit.length != 3) {
            throw new IllegalArgumentException("Invalid available config version");
        }
        for (int i = 0; i < 3; ++i) {
            int minimalVersionInt = Integer.valueOf(minimalVersionSplit[i]);
            int availableVersionInt = Integer.valueOf(availableVersionSplit[i]);
            int comparisonResult = availableVersionInt - minimalVersionInt;
            if (comparisonResult > 0) {
                return true;
            }
            if (comparisonResult >= 0) continue;
            return false;
        }
        throw new IllegalStateException(String.format("Error while validating config version. available: %1$s, minimal supported %2$s", availableVersionString, minimalSupportedVersionString));
    }

    public static String getLocalizedPublisherName(Context applicationContext, LanguagesConfig languagesConfigJson) {
        String matchedName;
        Map<String, String> publisherMap = languagesConfigJson.getLanguages().getLocalizedPublisherMap();
        String language = Locale.getDefault().getLanguage().toUpperCase();
        String country = TBDeviceInfoUtil.getSimCountry(applicationContext).toUpperCase();
        if (!TextUtils.isEmpty((CharSequence)country) && !TextUtils.isEmpty((CharSequence)(matchedName = publisherMap.get(language + "_" + country)))) {
            return matchedName;
        }
        matchedName = publisherMap.get(language + "*");
        if (!TextUtils.isEmpty((CharSequence)matchedName)) {
            return matchedName;
        }
        if (!TextUtils.isEmpty((CharSequence)country) && !TextUtils.isEmpty((CharSequence)(matchedName = publisherMap.get("*" + country)))) {
            return matchedName;
        }
        return publisherMap.get("default");
    }

    private static void getConfigWithDeviceId(final Context context, final String publisherName, final String configId, final Callback<SdkPlusConfig> getSdkPlusConfigCallback, final Callback<LanguagesConfig> getLanguagesConfigCallback) {
        ConfigManager.getDeviceId(context, new GetDeviceIdCallback(){

            @Override
            public void onRetrievedDeviceId(String deviceId) {
                Map<String, String> map = ConfigHelper.getConfigQueryParameters(context, deviceId);
                this.getConfigFromServer(map);
            }

            @Override
            public void onFailedToGetDeviceId() {
                Map<String, String> map = ConfigHelper.getConfigQueryParameters(context);
                this.getConfigFromServer(map);
            }

            private void getConfigFromServer(Map<String, String> map) {
                ConfigHandler configHandler = BridgeInternal.getNetworkManager().getConfigHandler();
                configHandler.getConfig(publisherName, configId, map, getSdkPlusConfigCallback);
                configHandler.getLanguagesConfig(publisherName, map, getLanguagesConfigCallback);
            }
        });
    }

    private static void getDeviceId(Context context, final GetDeviceIdCallback callback) {
        String deviceId = BridgeInternal.getAdvertisingIdInfo().getAdvertisingId();
        if (deviceId != null) {
            if (deviceId.isEmpty()) {
                callback.onFailedToGetDeviceId();
            } else {
                callback.onRetrievedDeviceId(deviceId);
            }
        } else {
            BridgeInternal.getAdvertisingIdInfo().updateAdvertisingIdAsync(context, new AdvertisingIdInfo.AdvertisingIdCallback(){

                public void onIdRetrieved(String s) {
                    if (s.isEmpty()) {
                        callback.onFailedToGetDeviceId();
                    } else {
                        callback.onRetrievedDeviceId(s);
                    }
                }

                public void onIdUnavailable() {
                    callback.onFailedToGetDeviceId();
                }
            });
        }
    }

    static class GetAllConfigsFromRemoteInteractor {
        OnGetAllConfigsCallback getAllConfigsCallback;
        private final Object dataLock = new Object();
        private final Object failLock = new Object();
        private SdkPlusConfig newConfig;
        private LanguagesConfig newLanguagesConfig;
        boolean hasFailed = false;

        GetAllConfigsFromRemoteInteractor() {
        }

        void execute(Context context, String publisherName, String configId, OnGetAllConfigsCallback callback) {
            this.getAllConfigsCallback = callback;
            Callback<SdkPlusConfig> getSdkPlusConfigCallback = new Callback<SdkPlusConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(SdkPlusConfig response, String message) {
                    Object object = GetAllConfigsFromRemoteInteractor.this.dataLock;
                    synchronized (object) {
                        GetAllConfigsFromRemoteInteractor.this.newConfig = response;
                        if (GetAllConfigsFromRemoteInteractor.this.newConfig != null && GetAllConfigsFromRemoteInteractor.this.newConfig.getContentConfig() != null && GetAllConfigsFromRemoteInteractor.this.newConfig.getNotificationConfig() != null) {
                            GetAllConfigsFromRemoteInteractor.this.onSuccess();
                        } else {
                            GetAllConfigsFromRemoteInteractor.this.onFail(new Throwable("Failed to parse config"));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    GetAllConfigsFromRemoteInteractor.this.onFail(t);
                }
            };
            Callback<LanguagesConfig> getLanguagesConfigCallback = new Callback<LanguagesConfig>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(LanguagesConfig response, String message) {
                    Object object = GetAllConfigsFromRemoteInteractor.this.dataLock;
                    synchronized (object) {
                        GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig = response;
                        if (GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig != null && GetAllConfigsFromRemoteInteractor.this.newLanguagesConfig.getLanguages() != null) {
                            GetAllConfigsFromRemoteInteractor.this.onSuccess();
                        } else {
                            GetAllConfigsFromRemoteInteractor.this.onFail(new Throwable("Failed to parse languages config"));
                        }
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    GetAllConfigsFromRemoteInteractor.this.onFail(t);
                }
            };
            ConfigManager.getConfigWithDeviceId(context, publisherName, configId, getSdkPlusConfigCallback, getLanguagesConfigCallback);
        }

        private void onSuccess() {
            if (!this.hasFailed && this.newConfig != null && this.newLanguagesConfig != null) {
                this.getAllConfigsCallback.onConfigsFetched(this.newConfig, this.newLanguagesConfig);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFail(Throwable throwable) {
            Object object = this.failLock;
            synchronized (object) {
                if (this.hasFailed) {
                    return;
                }
                this.hasFailed = true;
            }
            this.getAllConfigsCallback.onConfigsFailed(throwable);
        }
    }

    private static interface GetDeviceIdCallback {
        public void onRetrievedDeviceId(String var1);

        public void onFailedToGetDeviceId();
    }

    public static interface OnGetAllConfigsCallback {
        public void onConfigsFetched(SdkPlusConfig var1, LanguagesConfig var2);

        public void onConfigsFailed(Throwable var1);
    }

    private static class CachedLanguagesConfigContainer
    implements Parcelable {
        private long cachingTimestamp;
        private LanguagesConfig languagesConfig;
        public static final Parcelable.Creator<CachedLanguagesConfigContainer> CREATOR = new Parcelable.Creator<CachedLanguagesConfigContainer>(){

            public CachedLanguagesConfigContainer createFromParcel(Parcel in) {
                return new CachedLanguagesConfigContainer(in);
            }

            public CachedLanguagesConfigContainer[] newArray(int size) {
                return new CachedLanguagesConfigContainer[size];
            }
        };

        protected CachedLanguagesConfigContainer(Parcel in) {
            this.cachingTimestamp = in.readLong();
        }

        public CachedLanguagesConfigContainer(long cachingTimestamp, LanguagesConfig languagesConfig) {
            this.cachingTimestamp = cachingTimestamp;
            this.languagesConfig = languagesConfig;
        }

        public boolean didExpire() {
            long timeSinceCacheCreated = System.currentTimeMillis() - this.cachingTimestamp;
            return timeSinceCacheCreated > this.languagesConfig.getConfigCacheExpirationTimeMs();
        }

        public LanguagesConfig getLanguagesConfig() {
            return this.languagesConfig;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.cachingTimestamp);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static class CachedSdkConfigContainer
    implements Parcelable {
        private long cachingTimestamp;
        private SdkPlusConfig sdkPlusConfig;
        public static final Parcelable.Creator<CachedSdkConfigContainer> CREATOR = new Parcelable.Creator<CachedSdkConfigContainer>(){

            public CachedSdkConfigContainer createFromParcel(Parcel in) {
                return new CachedSdkConfigContainer(in);
            }

            public CachedSdkConfigContainer[] newArray(int size) {
                return new CachedSdkConfigContainer[size];
            }
        };

        CachedSdkConfigContainer(Parcel in) {
            this.cachingTimestamp = in.readLong();
        }

        CachedSdkConfigContainer(long cachingTimestamp, SdkPlusConfig sdkPlusConfig) {
            this.cachingTimestamp = cachingTimestamp;
            this.sdkPlusConfig = sdkPlusConfig;
        }

        private boolean didExpire() {
            long timeSinceCacheCreated = System.currentTimeMillis() - this.cachingTimestamp;
            return timeSinceCacheCreated > this.sdkPlusConfig.getConfigCacheExpirationTimeMs();
        }

        public long getCachingTimestamp() {
            return this.cachingTimestamp;
        }

        public SdkPlusConfig getSdkPlusConfig() {
            return this.sdkPlusConfig;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.cachingTimestamp);
        }

        public int describeContents() {
            return 0;
        }

        public static NotificationConfig getNotificationConfig(CachedSdkConfigContainer cachedSdkConfig) {
            if (cachedSdkConfig == null) {
                return null;
            }
            SdkPlusConfig sdkPlusConfig = cachedSdkConfig.getSdkPlusConfig();
            if (sdkPlusConfig == null) {
                return null;
            }
            return sdkPlusConfig.getNotificationConfig();
        }
    }
}

