/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.shared;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.HashSet;

public class MigrationManager {
    private static final String TAG = MigrationManager.class.getSimpleName();
    private static final int LATEST_VERSION = 2;
    private static final String SHARED_LOCAL_STORAGE = "shared_local_storage";
    private static final String PULL_NOTIFICATION_LOCAL_STORAGE = "tb_notification_manager";

    public static boolean isMigrationRequired(Context context) {
        SharedPreferences sharLocStorPreferences = context.getSharedPreferences(SHARED_LOCAL_STORAGE, 0);
        boolean isFileCreated = context.getSharedPreferences(PULL_NOTIFICATION_LOCAL_STORAGE, 0) != null;
        int version = sharLocStorPreferences.getInt("local_storage_schema_version", 1);
        Log.i((String)TAG, (String)("is migration required? " + (isFileCreated && version < 2) + ", current version: " + version));
        return isFileCreated && version < 2;
    }

    public static void migrate(Context context) {
        SharedPreferences sharLocStorPreferences = context.getSharedPreferences(SHARED_LOCAL_STORAGE, 0);
        MigrationManager.updatePreferences(sharLocStorPreferences, context);
    }

    private static void updatePreferences(SharedPreferences sharLocStorPreferences, Context context) {
        SharedPreferences pullNotifSharedPreferences = context.getSharedPreferences(PULL_NOTIFICATION_LOCAL_STORAGE, 0);
        SharedPreferences.Editor edit = sharLocStorPreferences.edit();
        edit.putBoolean("tb_notification_enabled", pullNotifSharedPreferences.getBoolean("tb_notification_enabled", true));
        edit.putBoolean("tb_notification_enabled", pullNotifSharedPreferences.getBoolean("tb_notification_enabled", true));
        edit.putBoolean("is_notification_block_by_system", pullNotifSharedPreferences.getBoolean("is_notification_block_by_system", false));
        edit.putBoolean("tb_only_wifi_mode", pullNotifSharedPreferences.getBoolean("tb_only_wifi_mode", true));
        edit.putBoolean("is_amplitude_analytics_enabled", pullNotifSharedPreferences.getBoolean("is_amplitude_analytics_enabled", true));
        edit.putBoolean("is_kibana_analytics_enabled", pullNotifSharedPreferences.getBoolean("is_kibana_analytics_enabled", true));
        edit.putInt("tb_notification_icon_id", pullNotifSharedPreferences.getInt("tb_notification_icon_id", 1));
        edit.putInt("local_storage_schema_version", 2);
        edit.putLong("last_check_notification_disabled_status_event_time", pullNotifSharedPreferences.getLong("last_check_notification_disabled_status_event_time", 1L));
        edit.putLong("tb_last_event_time", pullNotifSharedPreferences.getLong("tb_last_event_time", 1L));
        edit.putString("tb_notification_application_name", pullNotifSharedPreferences.getString("tb_notification_application_name", ""));
        edit.putString("tb_config_variant", pullNotifSharedPreferences.getString("tb_config_variant", ""));
        edit.putString("taboola_plus_extra_properties", pullNotifSharedPreferences.getString("taboola_plus_extra_properties", ""));
        edit.putString("tb_publisher", pullNotifSharedPreferences.getString("tb_publisher", ""));
        edit.putString("tb_config_id", pullNotifSharedPreferences.getString("tb_config_id", ""));
        edit.putString("sim_country", pullNotifSharedPreferences.getString("sim_country", ""));
        edit.putString("tb_non_clickable_url_marker", pullNotifSharedPreferences.getString("tb_non_clickable_url_marker", ""));
        edit.putString("tb_previous_config", pullNotifSharedPreferences.getString("tb_previous_config", ""));
        edit.putString("tb_current_config", pullNotifSharedPreferences.getString("tb_current_config", ""));
        edit.putStringSet("crahses_events_need_to_send_to_kusto", pullNotifSharedPreferences.getStringSet("crahses_events_need_to_send_to_kusto", new HashSet()));
        edit.putStringSet("crahses_events_need_to_send_to_amplitude", pullNotifSharedPreferences.getStringSet("crahses_events_need_to_send_to_amplitude", new HashSet()));
        edit.putStringSet("tb_notification_categories", pullNotifSharedPreferences.getStringSet("tb_notification_categories", new HashSet()));
        edit.apply();
    }
}

