/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.PersistableBundle;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;
import com.taboola.android.plus.BridgeInternal;
import com.taboola.android.plus.TaboolaPlus;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationRefreshCallback;
import com.taboola.android.plus.notification.NotificationRenderRestrictionUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.shared.SharedAnalyticsManager;
import com.taboola.android.plus.shared.SharedLocalStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@RequiresApi(api=21)
public class TBNotificationRefreshJob
extends JobService {
    private static final String TAG = TBNotificationRefreshJob.class.getSimpleName();
    private static final int JOB_ID = 64879717;
    private static final String BUNDLE_EXTRAS_CATEGORIES = "com.taboola.android.plus.notification.job.extras.categories";
    private static final String BUNDLE_EXTRAS_REFRESH_INTERVAL_MS = "com.taboola.android.plus.notification.job.extras.refreshIntervalMs";
    private static final String CATEGORIES_DELIMITER = ", ";
    private static final long REFRESH_JOB_MINIMUM_INTERVAL_MS = 900000L;

    static void schedulePeriodicRefresh(@NonNull Context context, @NonNull List<String> categories, long refreshIntervalMs) {
        Log.v((String)TAG, (String)("Scheduling periodic refreshNotification with categories: " + categories.toString() + " and interval: " + refreshIntervalMs));
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ComponentName componentName = new ComponentName(context, TBNotificationRefreshJob.class);
        long actualRefreshInterval = Math.max(900000L, refreshIntervalMs);
        JobInfo.Builder builder = new JobInfo.Builder(64879717, componentName);
        builder.setPeriodic(actualRefreshInterval);
        builder.setPersisted(true);
        PersistableBundle extras = new PersistableBundle();
        extras.putString(BUNDLE_EXTRAS_CATEGORIES, TextUtils.join((CharSequence)CATEGORIES_DELIMITER, categories));
        extras.putLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS, refreshIntervalMs);
        builder.setExtras(extras);
        jobScheduler.schedule(builder.build());
    }

    static void cancelPeriodicRefresh(Context context) {
        Log.v((String)TAG, (String)"Canceling periodic refresh");
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.cancel(64879717);
    }

    public boolean onStartJob(final JobParameters params) {
        Log.d((String)TAG, (String)"onStartJob() called");
        final TaboolaPlus.TaboolaPlusRetrieveFailedCallback failedCallback = new TaboolaPlus.TaboolaPlusRetrieveFailedCallback(){

            @Override
            public void onTaboolaPlusRetrieveFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("onStartJob: failed to update content : Taboola Plus restore failed : " + throwable.getMessage()));
                TBNotificationRefreshJob.this.jobFinished(params, false);
            }
        };
        BridgeInternal.restore(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

            @Override
            public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                NotificationConfig notificationConfig;
                TBNotificationLocalStore localStore = taboolaPlus.getNotificationManager().getLocalStore();
                if (!NotificationRenderRestrictionUtil.didRefreshIntervalPass(localStore, notificationConfig = taboolaPlus.getNotificationManager().getNotificationConfig())) {
                    Log.i((String)TAG, (String)"onStartJob: trying to refreshNotification content before refreshNotification interval have passed");
                    TBNotificationRefreshJob.this.jobFinished(params, false);
                    return;
                }
                boolean shouldDismissNotification = taboolaPlus.getNotificationManager().getNotificationConfig().shouldDismissNotificationOnJobRun();
                if (shouldDismissNotification) {
                    taboolaPlus.getNotificationManager().dismissNotification();
                }
                BridgeInternal.reInit(new TaboolaPlus.TaboolaPlusRetrievedCallback(){

                    @Override
                    public void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus) {
                        TBNotificationRefreshJob.this.onTaboolaPlusRetrieved(taboolaPlus, params);
                    }
                }, failedCallback);
            }
        }, failedCallback);
        return true;
    }

    private void onTaboolaPlusRetrieved(TaboolaPlus taboolaPlus, final JobParameters params) {
        final TBNotificationManager notificationManager = taboolaPlus.getNotificationManager();
        TBNotificationLocalStore localStore = notificationManager.getLocalStore();
        SharedLocalStorage sharedLocalStorage = notificationManager.getSharedLocalStorage();
        TBNotificationAnalyticsManager analyticsManager = notificationManager.getAnalyticsManager();
        SharedAnalyticsManager sharedAnalyticsManager = notificationManager.getSharedAnalyticsManager();
        NotificationConfig config = notificationManager.getNotificationConfig();
        TBNotificationManager.updateCurrentEngagementGroup(config, localStore, analyticsManager);
        NotificationConfig.SmartNotificationFrequency.EngagementGroup currentGroup = TBNotificationManager.getCurrentEngagementGroup(config, localStore.getCurrentEngagedGroupName());
        boolean isNotificationBlocked = NotificationRenderRestrictionUtil.isNotificationBlocked(this.getApplicationContext(), localStore, sharedLocalStorage, analyticsManager, sharedAnalyticsManager, config, currentGroup);
        boolean didRefreshIntervalPass = NotificationRenderRestrictionUtil.didRefreshIntervalPass(localStore, config);
        boolean blockedByKillSwitch = NotificationRenderRestrictionUtil.isBlockedByKillSwitch(this.getApplicationContext());
        if (blockedByKillSwitch || isNotificationBlocked || !didRefreshIntervalPass) {
            this.onNotificationUpdateFinished(notificationManager, params);
            return;
        }
        PersistableBundle extras = params.getExtras();
        String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
        ArrayList<String> categories = categoriesStr == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)));
        notificationManager.refreshNotification(categories, new NotificationRefreshCallback(){

            @Override
            public void onNotificationRefreshSuccessful() {
                Log.i((String)TAG, (String)"Notification content refreshed successfully!");
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }

            @Override
            public void onNotificationRefreshFailed(Throwable t) {
                Log.e((String)TAG, (String)("Failed to refresh Notification content with error: " + t.getMessage()));
                TBNotificationRefreshJob.this.onNotificationUpdateFinished(notificationManager, params);
            }
        });
    }

    private void onNotificationUpdateFinished(TBNotificationManager notificationManager, JobParameters params) {
        int newRefreshIntervalMs;
        PersistableBundle extras = params.getExtras();
        long currentRefreshIntervalMs = extras.getLong(BUNDLE_EXTRAS_REFRESH_INTERVAL_MS);
        if (currentRefreshIntervalMs != (long)(newRefreshIntervalMs = notificationManager.getNotificationConfig().getRefreshIntervalMs())) {
            Log.i((String)TAG, (String)"onNotificationUpdateFinished: notification RefreshInterval has changed. Rescheduling job");
            String categoriesStr = extras.getString(BUNDLE_EXTRAS_CATEGORIES);
            ArrayList<String> categories = new ArrayList<String>(Arrays.asList(categoriesStr.split(CATEGORIES_DELIMITER)));
            notificationManager.getBackgroundManager().schedulePeriodicRefresh(categories, newRefreshIntervalMs);
        }
        this.jobFinished(params, false);
    }

    public boolean onStopJob(JobParameters params) {
        Log.w((String)TAG, (String)"Job stopped by OS");
        return false;
    }

    static boolean isTaskRunning(@NonNull Context context) {
        JobScheduler scheduler = (JobScheduler)context.getSystemService("jobscheduler");
        boolean hasBeenScheduled = false;
        if (scheduler != null) {
            for (JobInfo jobInfo : scheduler.getAllPendingJobs()) {
                if (jobInfo.getId() != 64879717) continue;
                hasBeenScheduled = true;
                break;
            }
        }
        return hasBeenScheduled;
    }
}

