/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationRenderRestrictionUtil;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationManager;
import com.taboola.android.plus.notification.TBNotificationRefreshJob;
import com.taboola.android.plus.shared.SharedNotificationUtil;
import com.taboola.android.utils.UrlUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TBNotificationUtil {
    private static final String TAG = TBNotificationUtil.class.getSimpleName();
    private final Context context;
    private TBNotificationLocalStore localStore;
    private static final String TB_ITEM_KEY_TITLE = "name";
    private static final String TB_ITEM_KEY_THUMBNAIL = "thumbnail";
    private static final String TB_ITEM_KEY_DATE = "created";
    private static final String TB_ITEM_KEY_BRAND = "branding";
    private static final String TB_ITEM_KEY_DESCRIPTION = "description";
    private static final String TB_ITEM_KEY_DISTRIBUTED_CONTENT = "is-dc";
    private static final String TB_ITEM_KEY_ORIGIN = "origin";
    private static final String TB_ITEM_BOOLEAN_VALUE_FALSE = "false";
    private static final String TB_ITEM_ORIGIN_VALUE_SPONSORED = "sponsored";
    private static final String GENERAL_NOTIFICATION_CATEGORY = "general";

    TBNotificationUtil(Context context, TBNotificationLocalStore localStore) {
        this.context = context;
        this.localStore = localStore;
    }

    int dpToPx(int dp) {
        float density = this.context.getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    @RequiresApi(api=21)
    static void onWakePushReceived(TBNotificationManager notificationManager) {
        Context context = notificationManager.getAppContext();
        TBNotificationLocalStore localStore = notificationManager.getLocalStore();
        NotificationConfig notificationConfig = notificationManager.getNotificationConfig();
        List<String> categories = localStore.getNotificationCategories();
        boolean isBlockedByKillSwitch = NotificationRenderRestrictionUtil.isBlockedByKillSwitch(context);
        if (localStore.isNotificationEnabled() && !isBlockedByKillSwitch) {
            if (categories.isEmpty()) {
                categories.add(GENERAL_NOTIFICATION_CATEGORY);
            }
            if (TBNotificationRefreshJob.isTaskRunning(context)) {
                Log.i((String)TAG, (String)"onWakePushReceived: job is scheduled, no actions needed");
            } else {
                Log.i((String)TAG, (String)"onWakePushReceived: periodic refresh job is not scheduled, scheduling");
                TBNotificationRefreshJob.schedulePeriodicRefresh(context, categories, notificationConfig.getRefreshIntervalMs());
            }
        } else {
            Log.i((String)TAG, (String)"onWakePushReceived: wake push ignored: either notifications are not enabled or killswitch is activated");
        }
    }

    String getApplicationName(NotificationConfig config) {
        String appName = config.getApplicationName();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        appName = this.localStore.getApplicationName();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            return appName;
        }
        return SharedNotificationUtil.getCurrentApplicationName(this.context);
    }

    public static List<Integer> generateTrendingItemIdsList(int contentSize, int trendingCount) {
        if (trendingCount > contentSize) {
            trendingCount = contentSize;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(contentSize);
        for (int i = 0; i < contentSize; ++i) {
            list.add(i);
        }
        Collections.shuffle(list);
        return list.subList(0, trendingCount);
    }

    String getItemDate(TBRecommendationItem item, String nowLabelText) {
        return this.getTimeBetween((String)item.getExtraDataMap().get(TB_ITEM_KEY_DATE), nowLabelText);
    }

    String getItemTitle(@NonNull TBRecommendationItem item) {
        return this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_TITLE));
    }

    @Nullable
    static String getItemThumbnailUrl(@NonNull TBRecommendationItem item, int imageWidth, int imageHeight) {
        try {
            String thumbnail = (String)item.getExtraDataMap().get(TB_ITEM_KEY_THUMBNAIL);
            if (TextUtils.isEmpty((CharSequence)thumbnail)) {
                Log.e((String)TAG, (String)"getItemThumbnailUrl: missing thumbnail url");
                return null;
            }
            JSONArray thumbnailJsonArray = new JSONArray(thumbnail);
            if (thumbnailJsonArray.length() > 0) {
                JSONObject thumbnailJsonObj = (JSONObject)thumbnailJsonArray.get(0);
                String imageUrl = thumbnailJsonObj.getString("url");
                return UrlUtils.replaceImageSizeInUrl((String)imageUrl, (int)imageHeight, (int)imageWidth);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"getItemThumbnailUrl: ", (Throwable)e);
        }
        return null;
    }

    String getItemBrand(@NonNull TBRecommendationItem item) {
        return this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_BRAND));
    }

    String getItemDescription(@NonNull TBRecommendationItem item) {
        return this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DESCRIPTION));
    }

    private String getTimeBetween(@NonNull String createdTime, String nowLabelText) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        Date date = null;
        try {
            date = simpleDateFormat.parse(createdTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        if (System.currentTimeMillis() < date.getTime()) {
            return nowLabelText;
        }
        return (String)DateUtils.getRelativeTimeSpanString((long)date.getTime());
    }

    private String unescape(String s) {
        if (s == null) {
            return null;
        }
        return s.replace("\"", "").replace("\\", "");
    }

    boolean hasItemSponsoredContent(@NonNull TBRecommendationItem item) {
        if (item.getExtraDataMap().containsKey(TB_ITEM_KEY_DISTRIBUTED_CONTENT)) {
            return this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_DISTRIBUTED_CONTENT)).equalsIgnoreCase(TB_ITEM_BOOLEAN_VALUE_FALSE) && item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)).equalsIgnoreCase(TB_ITEM_ORIGIN_VALUE_SPONSORED);
        }
        return item.getExtraDataMap().containsKey(TB_ITEM_KEY_ORIGIN) && this.unescape((String)item.getExtraDataMap().get(TB_ITEM_KEY_ORIGIN)).equalsIgnoreCase(TB_ITEM_ORIGIN_VALUE_SPONSORED);
    }
}

