/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.Size;
import android.support.annotation.UiThread;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBRecommendationItem;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.api.TaboolaOnClickListener;
import com.taboola.android.plus.ConfigManager;
import com.taboola.android.plus.PublicApi;
import com.taboola.android.plus.R;
import com.taboola.android.plus.SdkPlusConfig;
import com.taboola.android.plus.content.ContentConfig;
import com.taboola.android.plus.content.LanguagesConfig;
import com.taboola.android.plus.notification.NotificationBackgroundManager;
import com.taboola.android.plus.notification.NotificationConfig;
import com.taboola.android.plus.notification.NotificationContent;
import com.taboola.android.plus.notification.NotificationContentState;
import com.taboola.android.plus.notification.NotificationLayoutConfig;
import com.taboola.android.plus.notification.NotificationReadMoreConfig;
import com.taboola.android.plus.notification.NotificationRefreshCallback;
import com.taboola.android.plus.notification.NotificationRemoteRepository;
import com.taboola.android.plus.notification.NotificationRenderRestrictionUtil;
import com.taboola.android.plus.notification.TBContent;
import com.taboola.android.plus.notification.TBDeviceInfoUtil;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationContentCallback;
import com.taboola.android.plus.notification.TBNotificationExecutors;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.notification.TBNotificationRenderer;
import com.taboola.android.plus.notification.TBNotificationRepository;
import com.taboola.android.plus.notification.TBNotificationStateReceiver;
import com.taboola.android.plus.notification.TBNotificationUtil;
import com.taboola.android.plus.shared.ConditionCheckUtil;
import com.taboola.android.plus.shared.LocalizationStrings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

@Keep
@RequiresApi(api=21)
public class TBNotificationManager
implements PublicApi.PublicTBNotificationManager {
    private static final String TAG = TBNotificationManager.class.getSimpleName();
    public static final String NOTIFICATION_TYPE_TRENDING = "trending";
    public static final String NOTIFICATION_CLICK_INTENT_ACTION = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT";
    public static final String NOTIFICATION_CLICK_UNLOCK = "com.taboola.android.plus.notification.UNLOCK_SCREEN_CLICK_EVENT";
    public static final String NOTIFICATION_CLICK_INTENT_EXTRA_PLACEMENT = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_PLACEMENT";
    public static final String NOTIFICATION_CLICK_INTENT_EXTRA_ITEM_INDEX = "com.taboola.android.plus.notification.NOTIFICATION_CLICK_EVENT_ITEM_INDEX";
    public static final String PLACEMENT_CLICK_URL_KEY = "url";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_IS_TRENDING";
    static final String NOTIFICATION_INTENT_EXTRA_KEY_RANDOM_THUMBNAIL_NUMBER = "com.taboola.android.plus.notification.NOTIFICATION_INTENT_EXTRA_KEY_RANDOM_THUMBNAIL_NUMBER";
    static final String EMPTY_GROUP_NAME = "Default";
    private final Context appContext;
    private final TBNotificationLocalStore localStore;
    private final TBNotificationUtil notificationUtil;
    private final TBNotificationAnalyticsManager analyticsManager;
    private final TBNotificationRenderer renderer;
    private final TBNotificationRepository contentRepository;
    private final NotificationBackgroundManager backgroundManager;
    private ContentConfig contentConfig;
    private NotificationConfig config;
    private LocalizationStrings localizationStrings;
    @NonNull
    private List<String> categories = new ArrayList<String>();
    private final int thumbnailHeight;
    private final int thumbnailWidth;
    private HashMap<TBPlacement, Boolean> contentList = new HashMap();

    @UiThread
    public static void handleClick(final @NonNull Intent intent, final @NonNull Context activityContext, final @Nullable Map<String, String> taboolaExtraProperties, final @Nullable TaboolaOnClickListener onClickListener) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.e((String)TAG, (String)"handleClick : Android version is less than LOLLIPOP. No clicks were supposed to happen.");
            return;
        }
        TBNotificationLocalStore localStorage = new TBNotificationLocalStore(activityContext.getApplicationContext());
        ConfigManager.getCurrentConfigs(activityContext.getApplicationContext(), localStorage.getPublisher(), localStorage.getConfigId(), new ConfigManager.OnGetAllConfigsCallback(){

            @Override
            public void onConfigsFetched(SdkPlusConfig config, LanguagesConfig languagesConfig) {
                HashMap<String, String> taboolaApiExtraProperties;
                HashMap<String, String> mergedExtraProperties = new HashMap<String, String>();
                if (taboolaExtraProperties != null) {
                    mergedExtraProperties.putAll(taboolaExtraProperties);
                }
                if ((taboolaApiExtraProperties = config.getContentConfig().getTaboolaApiConfig().getTaboolaApiExtraProperties()) != null) {
                    mergedExtraProperties.putAll(taboolaApiExtraProperties);
                }
                mergedExtraProperties.put("enableFullRawDataResponse", "true");
                TaboolaApi.getInstance().setExtraProperties(mergedExtraProperties).setOnClickListener(onClickListener);
                TBNotificationManager.handleClick(intent, activityContext);
            }

            @Override
            public void onConfigsFailed(Throwable throwable) {
                Log.e((String)TAG, (String)("handleClick: failed to get configs: " + throwable.getMessage()));
            }
        });
    }

    @UiThread
    public static void handleClick(@NonNull Intent intent, @NonNull Context activityContext) {
        Bundle extras = intent.getExtras();
        if (intent.getAction() != null && intent.getAction().equals(NOTIFICATION_CLICK_INTENT_ACTION) && extras != null) {
            if (Build.VERSION.SDK_INT < 21) {
                Log.e((String)TAG, (String)"handleClick : Android version is less than LOLLIPOP. No clicks were supposed to happen.");
                return;
            }
            Log.d((String)TAG, (String)("handling notification click with: intent = [" + intent + "]"));
            boolean isTrending = NOTIFICATION_TYPE_TRENDING.equals(extras.getString("notification_type"));
            if (isTrending) {
                TBPlacement placement = (TBPlacement)extras.getParcelable(NOTIFICATION_CLICK_INTENT_EXTRA_PLACEMENT);
                int itemIndex = extras.getInt(NOTIFICATION_CLICK_INTENT_EXTRA_ITEM_INDEX);
                TBRecommendationItem item = (TBRecommendationItem)placement.getItems().get(itemIndex);
                TBNotificationLocalStore localStore = new TBNotificationLocalStore(activityContext.getApplicationContext());
                String clickUrl = (String)item.getExtraDataMap().get(PLACEMENT_CLICK_URL_KEY);
                String nonClickableUrlMarker = localStore.getNonClickableUrlMarker();
                if (!TextUtils.isEmpty((CharSequence)nonClickableUrlMarker) && clickUrl.contains(nonClickableUrlMarker)) {
                    Log.i((String)TAG, (String)"handleClick: item clickIgnored");
                } else if (TaboolaApi.getInstance().isInitialized()) {
                    item.handleClick(activityContext);
                } else {
                    String info = "TBNotificationManager: handleClick()";
                    new TBNotificationAnalyticsManager(activityContext.getApplicationContext(), new TBNotificationLocalStore(activityContext.getApplicationContext())).sendTaboolaApiNotInitializedEvent(info);
                }
            } else {
                Log.e((String)TAG, (String)"unknown taboola notification type");
            }
        }
    }

    TBNotificationManager(@NonNull Context context, @NonNull TBNotificationLocalStore localStore, @NonNull NotificationRemoteRepository contentManager, @NonNull TBNotificationAnalyticsManager analyticsManager) {
        this.appContext = context.getApplicationContext();
        this.localStore = localStore;
        this.analyticsManager = analyticsManager;
        this.notificationUtil = new TBNotificationUtil(this.appContext, localStore);
        this.renderer = new TBNotificationRenderer(this.appContext, this, this.notificationUtil, this.getNotificationIcon());
        this.contentRepository = new TBNotificationRepository(contentManager, localStore, this.analyticsManager, new TBNotificationExecutors());
        this.backgroundManager = new NotificationBackgroundManager(this.appContext);
        this.thumbnailHeight = (int)this.appContext.getResources().getDimension(R.dimen.tbn_expanded_img_height);
        this.thumbnailWidth = this.notificationUtil.getScreenWidth();
    }

    void applyConfig(NotificationConfig config, ContentConfig contentConfig, LocalizationStrings localizationStrings) {
        this.config = config;
        this.contentConfig = contentConfig;
        this.localizationStrings = localizationStrings;
    }

    @Override
    public TBNotificationManager setNotificationIcon(int iconId) {
        this.localStore.setNotificationIcon(iconId);
        this.renderer.setNotificationIcon(this.getNotificationIcon());
        return this;
    }

    @Override
    public TBNotificationManager setApplicationName(String applicationName) {
        this.localStore.setApplicationName(applicationName);
        return this;
    }

    @Override
    public TBNotificationManager setIsWifiOnlyMode(boolean isWifiOnlyMode) {
        this.localStore.setWifiOnlyModeRuntimeFlag(isWifiOnlyMode);
        return this;
    }

    @Override
    public TBNotificationManager setCategories(@NonNull List<String> newCategories) {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"setCategories : Android version is less than LOLLIPOP. Ignoring call.");
            return this;
        }
        Log.d((String)TAG, (String)("setCategories() called with: newCategories = [" + newCategories + "]"));
        List<String> allowedCategories = this.config.getAllowedCategories();
        ArrayList<String> filteredCategories = new ArrayList<String>();
        for (String category : newCategories) {
            if (allowedCategories.contains(category)) {
                filteredCategories.add(category);
                continue;
            }
            Log.w((String)TAG, (String)("setCategories: ignored category [" + category + "]. (not specified in config)"));
        }
        this.categories = filteredCategories;
        this.localStore.setNotificationCategories(this.categories);
        if (this.isEnabled() && !this.categories.isEmpty()) {
            if (TBDeviceInfoUtil.isDeviceSupported(this.config)) {
                this.initialNotificationRefresh();
            } else {
                this.analyticsManager.sendNotificationBlockedByConfig();
                Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
            }
        }
        return this;
    }

    @Override
    public TBNotificationManager enable() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"enable: Android version is less than LOLLIPOP. Ignoring call.");
            return this;
        }
        Log.i((String)TAG, (String)"Notification enabled");
        if (TBDeviceInfoUtil.isDeviceSupported(this.config)) {
            this.localStore.setEnabled(true);
            this.analyticsManager.sendEnabledEvent();
            if (this.backgroundManager.isPeriodicRefreshRunning()) {
                Log.i((String)TAG, (String)"enable() call ignored: notification refresh job is already running");
            } else if (!this.categories.isEmpty()) {
                this.initialNotificationRefresh();
            }
        } else {
            this.analyticsManager.sendNotificationBlockedByConfig();
            Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
        }
        return this;
    }

    @Override
    public TBNotificationManager disable() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"disable: Android version is less than LOLLIPOP. Ignoring call.");
            return this;
        }
        Log.i((String)TAG, (String)"Notification disabled");
        this.localStore.setEnabled(false);
        this.backgroundManager.stopAllBackgroundTasks();
        this.dismissNotification();
        this.renderer.onNotificationsDisabled();
        this.analyticsManager.sendDisabledEvent();
        return this;
    }

    @RequiresApi(api=21)
    TBNotificationManager enableInternal() {
        Log.i((String)TAG, (String)"Notification enabledInternal");
        if (TBDeviceInfoUtil.isDeviceSupported(this.config)) {
            this.localStore.setEnabled(true);
            if (this.backgroundManager.isPeriodicRefreshRunning()) {
                Log.i((String)TAG, (String)"enableInternal() call ignored: notification refresh job is already running");
            } else if (!this.categories.isEmpty()) {
                this.initialNotificationRefresh();
            }
        } else {
            this.analyticsManager.sendNotificationBlockedByConfig();
            Log.i((String)TAG, (String)"Notifications is blocked by config on the device");
        }
        return this;
    }

    @RequiresApi(api=21)
    TBNotificationManager disableInternal() {
        Log.i((String)TAG, (String)" disableInternal Notification disabled");
        this.localStore.setEnabled(false);
        this.backgroundManager.stopAllBackgroundTasks();
        this.dismissNotification();
        this.renderer.onNotificationsDisabled();
        return this;
    }

    @Override
    public boolean isEnabled() {
        if (Build.VERSION.SDK_INT < 21) {
            Log.i((String)TAG, (String)"isEnabled: Android version is less than LOLLIPOP. Ignoring call.");
            return false;
        }
        return this.localStore.isNotificationEnabled();
    }

    private void initialNotificationRefresh() {
        Log.d((String)TAG, (String)"initialNotificationRefresh() called");
        TBNotificationManager.updateCurrentEngagementGroup(this.config, this.localStore, this.analyticsManager);
        NotificationConfig.SmartNotificationFrequency.EngagementGroup currentGroup = TBNotificationManager.getCurrentEngagementGroup(this.config, this.localStore.getCurrentEngagedGroupName());
        boolean isNotificationBlocked = NotificationRenderRestrictionUtil.isNotificationBlocked(this.appContext, this.localStore, this.analyticsManager, this.config, currentGroup);
        boolean blockedByKillSwitch = NotificationRenderRestrictionUtil.isBlockedByKillSwitch(this.appContext);
        if (blockedByKillSwitch) {
            return;
        }
        if (isNotificationBlocked) {
            this.backgroundManager.schedulePeriodicRefresh(this.categories, this.config.getRefreshIntervalMs());
            return;
        }
        this.refreshNotification(this.categories, new NotificationRefreshCallback(){

            @Override
            public void onNotificationRefreshSuccessful() {
                Log.d((String)TAG, (String)"onNotificationRefreshSuccessful() called");
                TBNotificationManager.this.backgroundManager.schedulePeriodicRefresh(TBNotificationManager.this.categories, TBNotificationManager.this.config.getRefreshIntervalMs());
            }

            @Override
            public void onNotificationRefreshFailed(Throwable t) {
                Log.i((String)TAG, (String)("onNotificationRefreshFailed() called with: error = [" + t.getMessage() + "]"));
                TBNotificationManager.this.backgroundManager.schedulePeriodicRefresh(TBNotificationManager.this.categories, TBNotificationManager.this.config.getRefreshIntervalMs());
            }
        });
    }

    static NotificationConfig.SmartNotificationFrequency.EngagementGroup getCurrentEngagementGroup(@NonNull NotificationConfig config, @NonNull String groupName) {
        List<NotificationConfig.SmartNotificationFrequency.EngagementGroup> engagementGroups = config.getSmartNotificationFrequency().getEngagementGroups();
        if (!engagementGroups.isEmpty()) {
            for (NotificationConfig.SmartNotificationFrequency.EngagementGroup group : engagementGroups) {
                if (!group.getGroupName().equalsIgnoreCase(groupName)) continue;
                Log.d((String)TAG, (String)("getCurrentEngagementGroup: current group name is: " + group.getGroupName()));
                return group;
            }
        }
        Log.d((String)TAG, (String)"getCurrentEngagementGroup: create Default group");
        return new NotificationConfig.SmartNotificationFrequency.EngagementGroup().setGroupName(EMPTY_GROUP_NAME).setAllowedIntervals(config.getAllowedIntervals()).setMaxTriggerCountPerDay(config.getMaxNotificationTriggerCountPerDay()).setMinTriggerIntervalMs(config.getMinTriggerIntervalMs());
    }

    static void updateCurrentEngagementGroup(@NonNull NotificationConfig config, @NonNull TBNotificationLocalStore localStore, @NonNull TBNotificationAnalyticsManager analyticsManager) {
        NotificationConfig.SmartNotificationFrequency.EngagementGroup currentEngagementGroup = TBNotificationManager.getCurrentEngagementGroup(config, localStore.getCurrentEngagedGroupName());
        if (localStore.shouldSendUserAssignedToNotificationEngagmentGroupEvent()) {
            analyticsManager.sendUserAssignedToNotificationEngagementGroupEvent(currentEngagementGroup.getGroupName());
            localStore.setShouldSendUserAssignedToNotificationEngagmentGroupEvent(false);
        }
        if (currentEngagementGroup.getGroupName().equals(EMPTY_GROUP_NAME)) {
            Log.v((String)TAG, (String)"updateCurrentEngagementGroup: no actions needed, current group name is Default");
            return;
        }
        String updateGroupTo = TextUtils.isEmpty((CharSequence)currentEngagementGroup.getUpgradeTo()) ? currentEngagementGroup.getGroupName() : currentEngagementGroup.getUpgradeTo();
        String downgradeGroupTo = TextUtils.isEmpty((CharSequence)currentEngagementGroup.getDowngradeTo()) ? currentEngagementGroup.getGroupName() : currentEngagementGroup.getDowngradeTo();
        if (ConditionCheckUtil.shouldChangeUserGroup(localStore.getCountOfEngagedNotifications(), currentEngagementGroup.getEngagedNotificationLimit())) {
            Log.d((String)TAG, (String)("updateCurrentEngagementGroup: update group to: " + updateGroupTo));
            localStore.setCurrentEngagedGroupName(updateGroupTo);
            analyticsManager.sendUserNotificationEngagementGroupPromotedEvent(currentEngagementGroup.getGroupName(), updateGroupTo);
        } else if (ConditionCheckUtil.shouldChangeUserGroup(localStore.getCountOfDismissedNotifications(), currentEngagementGroup.getDismissedNotificationLimit())) {
            Log.d((String)TAG, (String)("updateCurrentEngagementGroup: downgrade group to: " + downgradeGroupTo));
            localStore.setCurrentEngagedGroupName(downgradeGroupTo);
            analyticsManager.sendUserNotificationEngagementGroupDemotedEvent(currentEngagementGroup.getGroupName(), downgradeGroupTo);
        }
    }

    void refreshNotification(@NonNull List<String> categories, final @NonNull NotificationRefreshCallback callback) {
        Log.v((String)TAG, (String)"refreshNotification() called");
        if (categories.isEmpty()) {
            callback.onNotificationRefreshFailed(new Throwable("Categories list is empty"));
            return;
        }
        this.contentRepository.loadNewContent(this.contentConfig, this.config, categories, this.thumbnailWidth, this.thumbnailHeight, new TBNotificationContentCallback(){

            @Override
            public void onLoadedContent(@NonNull TBContent tbContent) {
                if (tbContent.isEmpty()) {
                    TBNotificationManager.this.dismissNotification();
                    Log.d((String)TAG, (String)"onLoadedContent: notification content is empty");
                } else {
                    TBNotificationManager.this.renderNewNotification(tbContent, 0);
                }
                callback.onNotificationRefreshSuccessful();
            }

            @Override
            public void onFailedToLoadContent(@NonNull Throwable t) {
                callback.onNotificationRefreshFailed(t);
            }
        });
    }

    private void renderNewNotification(@NonNull @Size(min=1L) TBContent tbContent, int firstPlacementIndex) {
        NotificationLayoutConfig notificationLayoutConfig = NotificationLayoutConfig.determineNotificationLayout(this.config.getLayoutConfig(), tbContent.getPlacements().size());
        this.renderer.prefetchThumbnails(tbContent, notificationLayoutConfig.getCollapsedLayout(), notificationLayoutConfig.getExpandedLayout());
        int itemCountToDisplay = Math.min(notificationLayoutConfig.getMaxNumberOfItems(), tbContent.getContentSize());
        this.contentList.clear();
        for (TBPlacement item : tbContent.getPlacements()) {
            this.contentList.put(item, false);
        }
        NotificationContentState notificationContentState = new NotificationContentState(firstPlacementIndex, itemCountToDisplay);
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, notificationContentState, notificationLayoutConfig);
        this.contentRepository.setNotificationState(notificationContentState);
        this.renderNotification(notificationContent, notificationLayoutConfig, true);
    }

    private NotificationContent determineNotificationContent(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState notificationContentState, @NonNull NotificationLayoutConfig notificationLayoutConfig) {
        ArrayList<TBPlacement> currentNotificationPlacements = new ArrayList<TBPlacement>(tbContent.getPlacements().subList(notificationContentState.getFirstPlacementIndex(), notificationContentState.getFirstPlacementIndex() + notificationContentState.getItemCountToDisplay()));
        NotificationContent notificationContent = new NotificationContent(currentNotificationPlacements);
        notificationContent.setApplicationName(this.notificationUtil.getApplicationName(this.config));
        notificationContent.setShouldShowHint(!this.localStore.getDidClickArrow());
        notificationContent.setIsTrendingItem(tbContent.getItems().get(notificationContentState.getFirstPlacementIndex()).getPlacementTrending());
        if (notificationLayoutConfig.getCollapsedLayout() == NotificationLayoutConfig.CollapsedLayout.MultipleThumbnails || notificationLayoutConfig.getExpandedLayout() == NotificationLayoutConfig.ExpandedLayout.MultipleThumbnails) {
            notificationContent.setHasMultiplePages(false);
        } else {
            notificationContent.setHasMultiplePages(notificationContentState.getItemCountToDisplay() * 2 <= tbContent.getContentSize());
        }
        return notificationContent;
    }

    private NotificationContent determineReadMoreNotificationContent(@NonNull @Size(min=1L) TBContent tbContent) {
        ArrayList<TBPlacement> currentNotificationPlacements = new ArrayList<TBPlacement>();
        if (tbContent.getReadMoreNotificationItem() != null) {
            currentNotificationPlacements.add(tbContent.getReadMoreNotificationItem().getPhotoPlacement());
        } else {
            currentNotificationPlacements.add(null);
        }
        currentNotificationPlacements.add(tbContent.getReadMoreNotificationItem().getContentPlacement());
        NotificationContent notificationContent = new NotificationContent(currentNotificationPlacements);
        notificationContent.setHasMultiplePages(true);
        notificationContent.setApplicationName(this.notificationUtil.getApplicationName(this.config));
        return notificationContent;
    }

    void removePlacement(String imageUri) {
        Log.v((String)TAG, (String)"removePlacement() called");
        this.backgroundManager.cancelContentSwitchTimer();
        this.contentRepository.deletePlacement(imageUri, this.getOnDeletePlacementCallback());
    }

    void removePlacement(TBPlacement placement) {
        Log.v((String)TAG, (String)"removePlacement() called");
        this.backgroundManager.cancelContentSwitchTimer();
        this.contentRepository.deletePlacement(placement, this.getOnDeletePlacementCallback());
    }

    @NonNull
    private TBNotificationRepository.OnDeletePlacementCallback getOnDeletePlacementCallback() {
        return new TBNotificationRepository.OnDeletePlacementCallback(){

            @Override
            public void onDeleted(@NonNull TBContent currentContent, @NonNull NotificationContentState contentState) {
                if (currentContent.isEmpty()) {
                    TBNotificationManager.this.dismissNotification();
                } else {
                    int firstPlacementIndex;
                    for (firstPlacementIndex = contentState.getFirstPlacementIndex(); firstPlacementIndex >= currentContent.getContentSize(); --firstPlacementIndex) {
                    }
                    TBNotificationManager.this.renderNewNotification(currentContent, firstPlacementIndex);
                }
            }
        };
    }

    void renderPrevPage(final boolean shouldReportNextPageVisibility) {
        this.contentRepository.fetchCurrentData(new TBNotificationRepository.FetchCurrentDataCallback(){

            @Override
            public void onFetched(@Nullable TBContent content, @Nullable NotificationContentState contentState) {
                if (content != null && !content.isEmpty() && contentState != null) {
                    if (TBNotificationManager.this.shouldShowReadMore() && content.getReadMoreNotificationItem() != null) {
                        TBNotificationManager.this.renderReadMoreNotificationPage(content, contentState, false);
                    } else {
                        TBNotificationManager.this.renderPrevNotificationPage(content, contentState, shouldReportNextPageVisibility);
                    }
                } else {
                    Log.w((String)TAG, (String)"renderPrevPage: trying to render prev page while content or contentState is null");
                }
            }
        });
    }

    void renderNextPage(final boolean shouldReportNextPageVisibility) {
        this.contentRepository.fetchCurrentData(new TBNotificationRepository.FetchCurrentDataCallback(){

            @Override
            public void onFetched(@Nullable TBContent content, @Nullable NotificationContentState contentState) {
                if (content != null && !content.isEmpty() && contentState != null) {
                    if (TBNotificationManager.this.shouldShowReadMore() && content.getReadMoreNotificationItem() != null) {
                        TBNotificationManager.this.renderReadMoreNotificationPage(content, contentState, true);
                    } else {
                        TBNotificationManager.this.renderNextNotificationPage(content, contentState, shouldReportNextPageVisibility);
                    }
                } else {
                    Log.w((String)TAG, (String)"renderNextPage: trying to render next page while content or contentState is null");
                }
            }
        });
    }

    private boolean shouldShowReadMore() {
        boolean areNotificationsRead = Collections.frequency(new ArrayList<Boolean>(this.contentList.values()), false) == 0;
        return this.config.getReadMoreConfig().shouldShowReadMore() && areNotificationsRead;
    }

    private void renderPrevNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState, boolean shouldReportNextPageVisibility) {
        NotificationLayoutConfig notificationLayoutConfig = NotificationLayoutConfig.determineNotificationLayout(this.config.getLayoutConfig(), 1);
        NotificationContentState newNotificationContentState = new NotificationContentState(this.getPrevPlacementIndex(tbContent.getContentSize(), currentNotificationContentState.getFirstPlacementIndex()));
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, newNotificationContentState, notificationLayoutConfig);
        if (shouldReportNextPageVisibility) {
            this.contentList.put(tbContent.getPlacements().get(this.getPrevPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
            this.contentList.put(tbContent.getPlacements().get(currentNotificationContentState.getFirstPlacementIndex()), true);
            TBNotificationStateReceiver.reportVisibility(this.appContext, this, notificationContent.getPlacements());
        }
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.renderNotification(notificationContent, notificationLayoutConfig, false);
    }

    private void renderNextNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState, boolean shouldReportNextPageVisibility) {
        NotificationLayoutConfig notificationLayoutConfig = NotificationLayoutConfig.determineNotificationLayout(this.config.getLayoutConfig(), 1);
        NotificationContentState newNotificationContentState = new NotificationContentState(this.getNextPlacementIndex(tbContent.getContentSize(), currentNotificationContentState.getFirstPlacementIndex()));
        NotificationContent notificationContent = this.determineNotificationContent(tbContent, newNotificationContentState, notificationLayoutConfig);
        if (shouldReportNextPageVisibility) {
            this.contentList.put(tbContent.getPlacements().get(currentNotificationContentState.getFirstPlacementIndex()), true);
            this.contentList.put(tbContent.getPlacements().get(this.getNextPlacementIndex(tbContent.getPlacements().size(), currentNotificationContentState.getFirstPlacementIndex())), true);
            TBNotificationStateReceiver.reportVisibility(this.appContext, this, notificationContent.getPlacements());
        }
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.renderNotification(notificationContent, notificationLayoutConfig, false);
    }

    private void renderReadMoreNotificationPage(@NonNull @Size(min=1L) TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState, boolean isNext) {
        NotificationReadMoreConfig notificationReadMoreConfig = NotificationReadMoreConfig.determineNotificationLayout(this.config.getReadMoreConfig(), 1);
        int firstPlacementIndex = currentNotificationContentState.getFirstPlacementIndex();
        int index = isNext ? this.getNextPlacementIndex(tbContent.getContentSize(), firstPlacementIndex) : this.getPrevPlacementIndex(tbContent.getContentSize(), firstPlacementIndex);
        NotificationContentState newNotificationContentState = new NotificationContentState(index);
        NotificationContent notificationContent = this.determineReadMoreNotificationContent(tbContent);
        this.refreshContentList(tbContent, currentNotificationContentState);
        this.contentRepository.setNotificationState(newNotificationContentState);
        this.backgroundManager.cancelContentSwitchTimer();
        TBNotificationRenderer.RenderResult renderResult = this.renderer.renderReadMoreNotification(notificationContent, notificationReadMoreConfig, this.renderRandomNumber());
        if (renderResult.isSuccessful()) {
            this.onContentRenderSuccess(notificationContent, false);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.analyticsManager.sendFailedToRenderEvent(renderResult.getErrorMessage());
        }
    }

    String renderRandomNumber() {
        Random random = new Random();
        Integer randomNumber = random.nextInt(5) + 5;
        String randomString = randomNumber == 9 ? randomNumber + "+" : randomNumber.toString();
        return randomString;
    }

    void refreshContentList(TBContent tbContent, @NonNull NotificationContentState currentNotificationContentState) {
        for (TBPlacement item : tbContent.getPlacements()) {
            this.contentList.put(item, false);
        }
    }

    private int getNextPlacementIndex(int availableItemCount, int currentIndex) {
        int newIndex = currentIndex + 1;
        if (newIndex < availableItemCount) {
            return newIndex;
        }
        return 0;
    }

    private int getPrevPlacementIndex(int availableItemCount, int currentIndex) {
        int prevIndex = currentIndex - 1;
        if (prevIndex >= 0) {
            return prevIndex;
        }
        return availableItemCount - 1;
    }

    private void renderNotification(@NonNull NotificationContent notificationContent, @NonNull NotificationLayoutConfig notificationLayoutConfig, boolean isNewNotification) {
        this.backgroundManager.cancelContentSwitchTimer();
        TBNotificationRenderer.RenderResult renderResult = this.renderer.renderNotification(notificationContent, notificationLayoutConfig);
        if (renderResult.isSuccessful()) {
            this.onContentRenderSuccess(notificationContent, isNewNotification);
        } else {
            Log.e((String)TAG, (String)("Failed to renderContent with error: " + renderResult.getErrorMessage()));
            this.analyticsManager.sendFailedToRenderEvent(renderResult.getErrorMessage());
        }
    }

    void dismissNotification() {
        Log.v((String)TAG, (String)"dismissNotification");
        this.backgroundManager.cancelContentSwitchTimer();
        this.renderer.dismissNotification();
    }

    void onDismissed(@NonNull ArrayList<TBPlacement> placements, String collapsedNotificationLayout, String expandedNotificationLayout, boolean isTrendingItem, String randomThumbnailNumber) {
        this.backgroundManager.cancelContentSwitchTimer();
        this.analyticsManager.sendDismissedEvent(placements, collapsedNotificationLayout, expandedNotificationLayout, this.config.shouldThrottleDismissEvent(), isTrendingItem, randomThumbnailNumber);
    }

    private void onContentRenderSuccess(@NonNull NotificationContent notificationContent, boolean isNewNotification) {
        if (isNewNotification) {
            this.updateSuccessfulRenderCounter(this.localStore.getLastShownNotificationTimestamp());
            this.localStore.setLastShownNotificationTime(System.currentTimeMillis());
        }
        if (notificationContent.hasMultiplePages()) {
            this.backgroundManager.scheduleContentSwitchTimer(this.config.getSwitchContentIntervalMs());
        }
        this.analyticsManager.sendRenderEvent(notificationContent.getPlacements(), notificationContent.isTrendingItem());
    }

    private void updateSuccessfulRenderCounter(long lastShownNotificationTimestamp) {
        if (!DateUtils.isToday((long)lastShownNotificationTimestamp)) {
            this.localStore.setCountOfRenderedNotificationsToday(0);
        }
        int counter = this.localStore.getCountOfRenderedNotificationsToday();
        this.localStore.setCountOfRenderedNotificationsToday(++counter);
    }

    NotificationConfig getNotificationConfig() {
        return this.config;
    }

    LocalizationStrings getLocalizationStrings() {
        return this.localizationStrings;
    }

    NotificationBackgroundManager getBackgroundManager() {
        return this.backgroundManager;
    }

    TBNotificationLocalStore getLocalStore() {
        return this.localStore;
    }

    Context getAppContext() {
        return this.appContext;
    }

    TBNotificationAnalyticsManager getAnalyticsManager() {
        return this.analyticsManager;
    }

    private int getNotificationIcon() {
        if (this.localStore.getNotificationIcon() != -1) {
            return this.localStore.getNotificationIcon();
        }
        return this.appContext.getApplicationInfo().icon;
    }
}

