/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.taboola.android.api.TBPlacement;
import com.taboola.android.api.TBPlacementRequest;
import com.taboola.android.api.TBRecommendationRequestCallback;
import com.taboola.android.api.TBRecommendationsRequest;
import com.taboola.android.api.TBRecommendationsResponse;
import com.taboola.android.api.TaboolaApi;
import com.taboola.android.plus.notification.TBNotificationAnalyticsManager;
import com.taboola.android.plus.notification.TBNotificationLocalStore;
import com.taboola.android.plus.shared.PlacementValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class GetMultipleCategoriesInteractor {
    private static final String TAG = GetMultipleCategoriesInteractor.class.getSimpleName();
    private Context applicationContext;
    private int requestsToComplete;
    private final Object resultLock = new Object();
    private volatile int completedRequests;
    private volatile Map<String, List<TBPlacement>> requestsResult;
    private volatile boolean hasFailed;

    GetMultipleCategoriesInteractor(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    void execute(@NonNull Collection<String> categorizedPlacementNames, int numberOfItems, @NonNull String readMorePlacementName, int imageHeight, int imageWidth, final TBNotificationAnalyticsManager analyticsManager, final GetNewNotificationContentCallback callback) {
        this.requestsToComplete = categorizedPlacementNames.size();
        this.completedRequests = 0;
        this.requestsResult = new HashMap<String, List<TBPlacement>>();
        this.hasFailed = false;
        HashMap<String, List<Object>> finalPlacementNames = new HashMap<String, List<Object>>();
        if (readMorePlacementName != null) {
            ++numberOfItems;
            ArrayList<String> readMorePlacements = new ArrayList<String>();
            readMorePlacements.add(readMorePlacementName);
            finalPlacementNames.put("read_more", readMorePlacements);
            ++this.requestsToComplete;
        }
        finalPlacementNames.putAll(GetMultipleCategoriesInteractor.getPlacementNamesWithCounter(categorizedPlacementNames, numberOfItems));
        for (Map.Entry entry : finalPlacementNames.entrySet()) {
            final String categoryName = (String)entry.getKey();
            GetMultipleCategoriesInteractor.getContentFromTrc(this.applicationContext, (List)entry.getValue(), imageHeight, imageWidth, new TBRecommendationRequestCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFetched(TBRecommendationsResponse response) {
                    ArrayList validPlacements = new ArrayList();
                    for (Map.Entry entry1 : response.getPlacementsMap().entrySet()) {
                        if (PlacementValidationUtil.isPlacementValid((TBPlacement)entry1.getValue(), analyticsManager)) {
                            validPlacements.add(entry1.getValue());
                            continue;
                        }
                        Log.w((String)TAG, (String)"onNotificationContentFetched: invalid placement");
                    }
                    Object object = GetMultipleCategoriesInteractor.this.resultLock;
                    synchronized (object) {
                        GetMultipleCategoriesInteractor.this.requestsResult.put(categoryName, validPlacements);
                        GetMultipleCategoriesInteractor.this.completedRequests++;
                        if (GetMultipleCategoriesInteractor.this.completedRequests == GetMultipleCategoriesInteractor.this.requestsToComplete && !GetMultipleCategoriesInteractor.this.hasFailed) {
                            callback.onContentFetched(GetMultipleCategoriesInteractor.this.requestsResult);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onRecommendationsFailed(Throwable throwable) {
                    Object object = GetMultipleCategoriesInteractor.this.resultLock;
                    synchronized (object) {
                        if (!GetMultipleCategoriesInteractor.this.hasFailed) {
                            GetMultipleCategoriesInteractor.this.hasFailed = true;
                            callback.onContentFailed(throwable);
                        }
                        Log.e((String)TAG, (String)"onContentFailed: ", (Throwable)throwable);
                    }
                }
            });
        }
    }

    @NonNull
    private static Map<String, List<String>> getPlacementNamesWithCounter(Collection<String> categorizedPlacementNames, int numberOfItems) {
        HashMap<String, List<String>> finalPlacementNames = new HashMap<String, List<String>>();
        for (String categorizedName : categorizedPlacementNames) {
            ArrayList<String> categoryPlacements = new ArrayList<String>(numberOfItems);
            for (int i = numberOfItems - 1; i >= 0; --i) {
                categoryPlacements.add(categorizedName + " " + i);
            }
            finalPlacementNames.put(categorizedName, categoryPlacements);
        }
        return finalPlacementNames;
    }

    private static void getContentFromTrc(Context applicationContext, List<String> placementNames, int imageHeight, int imageWidth, TBRecommendationRequestCallback callback) {
        TBRecommendationsRequest request = new TBRecommendationsRequest("http://example.com", "text");
        for (String categorizedPlacementName : placementNames) {
            TBPlacementRequest placementRequest = new TBPlacementRequest(categorizedPlacementName, 1).setThumbnailSize(imageWidth, imageHeight).setAvailable(false);
            request.addPlacementRequest(placementRequest);
        }
        if (TaboolaApi.getInstance().isInitialized()) {
            TaboolaApi.getInstance().fetchRecommendations(request, callback);
        } else {
            Log.e((String)TAG, (String)"getContentFromTrc: TaboolaApi is not initialized");
            callback.onRecommendationsFailed(new Throwable("TaboolaApi is not initialized"));
            String info = "GetNewNotificationContentInteractor: getContentFromTrc: before fetchRecommendations()";
            new TBNotificationAnalyticsManager(applicationContext, new TBNotificationLocalStore(applicationContext)).sendTaboolaApiNotInitializedEvent(info);
        }
    }

    static interface GetNewNotificationContentCallback {
        public void onContentFetched(Map<String, List<TBPlacement>> var1);

        public void onContentFailed(Throwable var1);
    }
}

