/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.android.plus.notification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class CookieStore
implements CookieJar {
    private final Set<Cookie> cookieStore = new HashSet<Cookie>();

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.cookieStore.addAll(cookies);
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> validCookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieStore) {
            this.LogCookie(cookie);
            if (cookie.expiresAt() < System.currentTimeMillis()) continue;
            validCookies.add(cookie);
        }
        return validCookies;
    }

    private void LogCookie(Cookie cookie) {
        System.out.println("String: " + cookie.toString());
        System.out.println("Expires: " + cookie.expiresAt());
        System.out.println("Hash: " + cookie.hashCode());
        System.out.println("Path: " + cookie.path());
        System.out.println("Domain: " + cookie.domain());
        System.out.println("Name: " + cookie.name());
        System.out.println("Value: " + cookie.value());
    }
}

